/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.druid.client.CachingQueryRunner;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.guice.annotations.Processing;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.BySegmentQueryRunner;
import org.apache.druid.query.CPUTimeMetricQueryRunner;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.MetricsEmittingQueryRunner;
import org.apache.druid.query.NoopQueryRunner;
import org.apache.druid.query.PerSegmentOptimizingQueryRunner;
import org.apache.druid.query.PerSegmentQueryOptimizationContext;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.ReferenceCountingSegmentQueryRunner;
import org.apache.druid.query.ReportTimelineMissingSegmentQueryRunner;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.spec.SpecificSegmentQueryRunner;
import org.apache.druid.query.spec.SpecificSegmentSpec;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.SetAndVerifyContextQueryRunner;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.PartitionHolder;
import org.joda.time.Interval;

public class ServerManager
implements QuerySegmentWalker {
    private static final EmittingLogger log = new EmittingLogger(ServerManager.class);
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final ServiceEmitter emitter;
    private final ExecutorService exec;
    private final CachePopulator cachePopulator;
    private final Cache cache;
    private final ObjectMapper objectMapper;
    private final CacheConfig cacheConfig;
    private final SegmentManager segmentManager;
    private final ServerConfig serverConfig;

    @Inject
    public ServerManager(QueryRunnerFactoryConglomerate conglomerate, ServiceEmitter emitter, @Processing ExecutorService exec, CachePopulator cachePopulator, @Smile ObjectMapper objectMapper, Cache cache, CacheConfig cacheConfig, SegmentManager segmentManager, ServerConfig serverConfig) {
        this.conglomerate = conglomerate;
        this.emitter = emitter;
        this.exec = exec;
        this.cachePopulator = cachePopulator;
        this.cache = cache;
        this.objectMapper = objectMapper;
        this.cacheConfig = cacheConfig;
        this.segmentManager = segmentManager;
        this.serverConfig = serverConfig;
    }

    private DataSource getInnerMostDataSource(DataSource dataSource) {
        if (dataSource instanceof QueryDataSource) {
            return this.getInnerMostDataSource(((QueryDataSource)dataSource).getQuery().getDataSource());
        }
        return dataSource;
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        final QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            throw new ISE("Unknown query type[%s].", new Object[]{query.getClass()});
        }
        final QueryToolChest toolChest = factory.getToolchest();
        final AtomicLong cpuTimeAccumulator = new AtomicLong(0L);
        DataSource dataSource = this.getInnerMostDataSource(query.getDataSource());
        if (!(dataSource instanceof TableDataSource)) {
            throw new UnsupportedOperationException("data source type '" + dataSource.getClass().getName() + "' unsupported");
        }
        String dataSourceName = this.getDataSourceName(dataSource);
        final VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = this.segmentManager.getTimeline(dataSourceName);
        if (timeline == null) {
            return new NoopQueryRunner();
        }
        FunctionalIterable queryRunners = FunctionalIterable.create(intervals).transformCat((Function)new Function<Interval, Iterable<TimelineObjectHolder<String, ReferenceCountingSegment>>>(){

            public Iterable<TimelineObjectHolder<String, ReferenceCountingSegment>> apply(Interval input) {
                return timeline.lookup(input);
            }
        }).transformCat(new Function<TimelineObjectHolder<String, ReferenceCountingSegment>, Iterable<QueryRunner<T>>>(){

            public Iterable<QueryRunner<T>> apply(final @Nullable TimelineObjectHolder<String, ReferenceCountingSegment> holder) {
                if (holder == null) {
                    return null;
                }
                return FunctionalIterable.create((Iterable)holder.getObject()).transform(new Function<PartitionChunk<ReferenceCountingSegment>, QueryRunner<T>>(){

                    public QueryRunner<T> apply(PartitionChunk<ReferenceCountingSegment> input) {
                        return ServerManager.this.buildAndDecorateQueryRunner(factory, toolChest, (ReferenceCountingSegment)input.getObject(), new SegmentDescriptor(holder.getInterval(), (String)holder.getVersion(), input.getChunkNumber()), cpuTimeAccumulator);
                    }
                });
            }
        });
        return CPUTimeMetricQueryRunner.safeBuild((QueryRunner)new FinalizeResultsQueryRunner(toolChest.mergeResults(factory.mergeRunners(this.exec, (Iterable)queryRunners)), toolChest), (QueryToolChest)toolChest, (ServiceEmitter)this.emitter, (AtomicLong)cpuTimeAccumulator, (boolean)true);
    }

    private String getDataSourceName(DataSource dataSource) {
        return (String)Iterables.getOnlyElement((Iterable)dataSource.getNames());
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        final QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            log.makeAlert("Unknown query type, [%s]", new Object[]{query.getClass()}).addData("dataSource", (Object)query.getDataSource()).emit();
            return new NoopQueryRunner();
        }
        final QueryToolChest toolChest = factory.getToolchest();
        String dataSourceName = this.getDataSourceName(query.getDataSource());
        final VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = this.segmentManager.getTimeline(dataSourceName);
        if (timeline == null) {
            return new NoopQueryRunner();
        }
        final AtomicLong cpuTimeAccumulator = new AtomicLong(0L);
        FunctionalIterable queryRunners = FunctionalIterable.create(specs).transformCat(new Function<SegmentDescriptor, Iterable<QueryRunner<T>>>(){

            public Iterable<QueryRunner<T>> apply(SegmentDescriptor input) {
                PartitionHolder entry = timeline.findEntry(input.getInterval(), (Object)input.getVersion());
                if (entry == null) {
                    return Collections.singletonList(new ReportTimelineMissingSegmentQueryRunner(input));
                }
                PartitionChunk chunk = entry.getChunk(input.getPartitionNumber());
                if (chunk == null) {
                    return Collections.singletonList(new ReportTimelineMissingSegmentQueryRunner(input));
                }
                ReferenceCountingSegment adapter = (ReferenceCountingSegment)chunk.getObject();
                return Collections.singletonList(ServerManager.this.buildAndDecorateQueryRunner(factory, toolChest, adapter, input, cpuTimeAccumulator));
            }
        });
        return CPUTimeMetricQueryRunner.safeBuild((QueryRunner)new FinalizeResultsQueryRunner(toolChest.mergeResults(factory.mergeRunners(this.exec, (Iterable)queryRunners)), toolChest), (QueryToolChest)toolChest, (ServiceEmitter)this.emitter, (AtomicLong)cpuTimeAccumulator, (boolean)true);
    }

    private <T> QueryRunner<T> buildAndDecorateQueryRunner(QueryRunnerFactory<T, Query<T>> factory, QueryToolChest<T, Query<T>> toolChest, ReferenceCountingSegment adapter, SegmentDescriptor segmentDescriptor, AtomicLong cpuTimeAccumulator) {
        SpecificSegmentSpec segmentSpec = new SpecificSegmentSpec(segmentDescriptor);
        SegmentId segmentId = adapter.getId();
        String segmentIdString = segmentId.toString();
        MetricsEmittingQueryRunner metricsEmittingQueryRunnerInner = new MetricsEmittingQueryRunner(this.emitter, toolChest, (QueryRunner)new ReferenceCountingSegmentQueryRunner(factory, adapter, segmentDescriptor), QueryMetrics::reportSegmentTime, queryMetrics -> queryMetrics.segment(segmentIdString));
        CachingQueryRunner cachingQueryRunner = new CachingQueryRunner(segmentIdString, segmentDescriptor, this.objectMapper, this.cache, (QueryToolChest)toolChest, metricsEmittingQueryRunnerInner, this.cachePopulator, this.cacheConfig);
        BySegmentQueryRunner bySegmentQueryRunner = new BySegmentQueryRunner(segmentId, adapter.getDataInterval().getStart(), cachingQueryRunner);
        MetricsEmittingQueryRunner metricsEmittingQueryRunnerOuter = new MetricsEmittingQueryRunner(this.emitter, toolChest, (QueryRunner)bySegmentQueryRunner, QueryMetrics::reportSegmentAndCacheTime, queryMetrics -> queryMetrics.segment(segmentIdString)).withWaitMeasuredFromNow();
        SpecificSegmentQueryRunner specificSegmentQueryRunner = new SpecificSegmentQueryRunner((QueryRunner)metricsEmittingQueryRunnerOuter, segmentSpec);
        PerSegmentOptimizingQueryRunner perSegmentOptimizingQueryRunner = new PerSegmentOptimizingQueryRunner((QueryRunner)specificSegmentQueryRunner, new PerSegmentQueryOptimizationContext(segmentDescriptor));
        return new SetAndVerifyContextQueryRunner(this.serverConfig, CPUTimeMetricQueryRunner.safeBuild((QueryRunner)perSegmentOptimizingQueryRunner, toolChest, (ServiceEmitter)this.emitter, (AtomicLong)cpuTimeAccumulator, (boolean)false));
    }
}

