/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.utils.ZKPaths;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.server.coordination.DataSegmentChangeCallback;
import org.apache.druid.server.coordination.DataSegmentChangeHandler;
import org.apache.druid.server.coordination.DataSegmentChangeRequest;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.SegmentChangeRequestNoop;
import org.apache.druid.server.coordination.SegmentLoadDropHandler;
import org.apache.druid.server.initialization.ZkPathsConfig;

@Deprecated
public class ZkCoordinator {
    private static final EmittingLogger log = new EmittingLogger(ZkCoordinator.class);
    private final Object lock = new Object();
    private final DataSegmentChangeHandler dataSegmentChangeHandler;
    private final ObjectMapper jsonMapper;
    private final ZkPathsConfig zkPaths;
    private final DruidServerMetadata me;
    private final CuratorFramework curator;
    private volatile PathChildrenCache loadQueueCache;
    private volatile boolean started = false;
    private final ExecutorService segmentLoadUnloadService;

    @Inject
    public ZkCoordinator(SegmentLoadDropHandler loadDropHandler, ObjectMapper jsonMapper, ZkPathsConfig zkPaths, DruidServerMetadata me, CuratorFramework curator, SegmentLoaderConfig config) {
        this.dataSegmentChangeHandler = loadDropHandler;
        this.jsonMapper = jsonMapper;
        this.zkPaths = zkPaths;
        this.me = me;
        this.curator = curator;
        this.segmentLoadUnloadService = Execs.multiThreaded((int)config.getNumLoadingThreads(), (String)"ZKCoordinator--%d");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            log.info("Starting zkCoordinator for server[%s]", new Object[]{this.me.getName()});
            String loadQueueLocation = ZKPaths.makePath((String)this.zkPaths.getLoadQueuePath(), (String)this.me.getName());
            String servedSegmentsLocation = ZKPaths.makePath((String)this.zkPaths.getServedSegmentsPath(), (String)this.me.getName());
            String liveSegmentsLocation = ZKPaths.makePath((String)this.zkPaths.getLiveSegmentsPath(), (String)this.me.getName());
            this.loadQueueCache = new PathChildrenCache(this.curator, loadQueueLocation, true, true, Execs.singleThreaded((String)"ZkCoordinator"));
            try {
                this.curator.newNamespaceAwareEnsurePath(loadQueueLocation).ensure(this.curator.getZookeeperClient());
                this.curator.newNamespaceAwareEnsurePath(servedSegmentsLocation).ensure(this.curator.getZookeeperClient());
                this.curator.newNamespaceAwareEnsurePath(liveSegmentsLocation).ensure(this.curator.getZookeeperClient());
                this.loadQueueCache.getListenable().addListener((Object)new PathChildrenCacheListener(){

                    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) {
                        ChildData child = event.getData();
                        switch (event.getType()) {
                            case CHILD_ADDED: {
                                ZkCoordinator.this.childAdded(child);
                                break;
                            }
                            case CHILD_REMOVED: {
                                log.info("zNode[%s] was removed", new Object[]{event.getData().getPath()});
                                break;
                            }
                            default: {
                                log.info("Ignoring event[%s]", new Object[]{event});
                            }
                        }
                    }
                });
                this.loadQueueCache.start();
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e, IOException.class);
                throw new RuntimeException(e);
            }
            this.started = true;
        }
    }

    private void childAdded(ChildData child) {
        this.segmentLoadUnloadService.submit(() -> {
            final String path = child.getPath();
            SegmentChangeRequestNoop request = new SegmentChangeRequestNoop();
            try {
                final DataSegmentChangeRequest finalRequest = (DataSegmentChangeRequest)this.jsonMapper.readValue(child.getData(), DataSegmentChangeRequest.class);
                finalRequest.go(this.dataSegmentChangeHandler, new DataSegmentChangeCallback(){

                    @Override
                    public void execute() {
                        try {
                            ((ChildrenDeletable)ZkCoordinator.this.curator.delete().guaranteed()).forPath(path);
                            log.info("Completed request [%s]", new Object[]{finalRequest.asString()});
                        }
                        catch (Exception e) {
                            try {
                                ((ChildrenDeletable)ZkCoordinator.this.curator.delete().guaranteed()).forPath(path);
                            }
                            catch (Exception e1) {
                                log.error((Throwable)e1, "Failed to delete zNode[%s], but ignoring exception.", new Object[]{path});
                            }
                            log.error((Throwable)e, "Exception while removing zNode[%s]", new Object[]{path});
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            catch (Exception e) {
                try {
                    ((ChildrenDeletable)this.curator.delete().guaranteed()).forPath(path);
                }
                catch (Exception e1) {
                    log.error((Throwable)e1, "Failed to delete zNode[%s], but ignoring exception.", new Object[]{path});
                }
                log.makeAlert((Throwable)e, "Segment load/unload: uncaught exception.", new Object[0]).addData("node", (Object)path).addData("nodeProperties", (Object)request).emit();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        log.info("Stopping ZkCoordinator for [%s]", new Object[]{this.me});
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            try {
                this.loadQueueCache.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.loadQueueCache = null;
                this.started = false;
            }
        }
    }

    public boolean isStarted() {
        return this.started;
    }
}

