/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.ClientCompactQueryTuningConfig;
import org.apache.druid.segment.IndexSpec;
import org.joda.time.Period;

public class DataSourceCompactionConfig {
    public static final long DEFAULT_TARGET_COMPACTION_SIZE_BYTES = 0x19000000L;
    private static final int DEFAULT_COMPACTION_TASK_PRIORITY = 25;
    private static final boolean DEFAULT_KEEP_SEGMENT_GRANULARITY = true;
    private static final long DEFAULT_INPUT_SEGMENT_SIZE_BYTES = 0x19000000L;
    private static final int DEFAULT_NUM_INPUT_SEGMENTS = 150;
    private static final Period DEFAULT_SKIP_OFFSET_FROM_LATEST = new Period((Object)"P1D");
    private final String dataSource;
    private final boolean keepSegmentGranularity;
    private final int taskPriority;
    private final long inputSegmentSizeBytes;
    @Nullable
    private final Long targetCompactionSizeBytes;
    @Nullable
    private final Integer maxRowsPerSegment;
    private final int maxNumSegmentsToCompact;
    private final Period skipOffsetFromLatest;
    private final UserCompactTuningConfig tuningConfig;
    private final Map<String, Object> taskContext;

    @JsonCreator
    public DataSourceCompactionConfig(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="keepSegmentGranularity") @Nullable Boolean keepSegmentGranularity, @JsonProperty(value="taskPriority") @Nullable Integer taskPriority, @JsonProperty(value="inputSegmentSizeBytes") @Nullable Long inputSegmentSizeBytes, @JsonProperty(value="targetCompactionSizeBytes") @Nullable Long targetCompactionSizeBytes, @JsonProperty(value="maxRowsPerSegment") @Nullable Integer maxRowsPerSegment, @JsonProperty(value="maxNumSegmentsToCompact") @Nullable Integer maxNumSegmentsToCompact, @JsonProperty(value="skipOffsetFromLatest") @Nullable Period skipOffsetFromLatest, @JsonProperty(value="tuningConfig") @Nullable UserCompactTuningConfig tuningConfig, @JsonProperty(value="taskContext") @Nullable Map<String, Object> taskContext) {
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        this.keepSegmentGranularity = keepSegmentGranularity == null ? true : keepSegmentGranularity;
        this.taskPriority = taskPriority == null ? 25 : taskPriority;
        this.inputSegmentSizeBytes = inputSegmentSizeBytes == null ? 0x19000000L : inputSegmentSizeBytes;
        this.targetCompactionSizeBytes = DataSourceCompactionConfig.getValidTargetCompactionSizeBytes(targetCompactionSizeBytes, maxRowsPerSegment, tuningConfig);
        this.maxRowsPerSegment = maxRowsPerSegment;
        this.maxNumSegmentsToCompact = maxNumSegmentsToCompact == null ? 150 : maxNumSegmentsToCompact;
        this.skipOffsetFromLatest = skipOffsetFromLatest == null ? DEFAULT_SKIP_OFFSET_FROM_LATEST : skipOffsetFromLatest;
        this.tuningConfig = tuningConfig;
        this.taskContext = taskContext;
        Preconditions.checkArgument((this.maxNumSegmentsToCompact > 1 ? 1 : 0) != 0, (Object)"numTargetCompactionSegments should be larger than 1");
    }

    @Nullable
    private static Long getValidTargetCompactionSizeBytes(@Nullable Long targetCompactionSizeBytes, @Nullable Integer maxRowsPerSegment, @Nullable UserCompactTuningConfig tuningConfig) {
        if (targetCompactionSizeBytes != null) {
            Preconditions.checkArgument((!DataSourceCompactionConfig.hasPartitionConfig(maxRowsPerSegment, tuningConfig) ? 1 : 0) != 0, (String)"targetCompactionSizeBytes[%s] cannot be used with maxRowsPerSegment[%s] and maxTotalRows[%s]", (Object[])new Object[]{targetCompactionSizeBytes, maxRowsPerSegment, tuningConfig == null ? null : tuningConfig.getMaxTotalRows()});
            return targetCompactionSizeBytes;
        }
        return DataSourceCompactionConfig.hasPartitionConfig(maxRowsPerSegment, tuningConfig) ? null : Long.valueOf(0x19000000L);
    }

    private static boolean hasPartitionConfig(@Nullable Integer maxRowsPerSegment, @Nullable UserCompactTuningConfig tuningConfig) {
        return maxRowsPerSegment != null || tuningConfig != null && tuningConfig.getMaxTotalRows() != null;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public boolean isKeepSegmentGranularity() {
        return this.keepSegmentGranularity;
    }

    @JsonProperty
    public int getTaskPriority() {
        return this.taskPriority;
    }

    @JsonProperty
    public long getInputSegmentSizeBytes() {
        return this.inputSegmentSizeBytes;
    }

    @JsonProperty
    public int getMaxNumSegmentsToCompact() {
        return this.maxNumSegmentsToCompact;
    }

    @JsonProperty
    @Nullable
    public Long getTargetCompactionSizeBytes() {
        return this.targetCompactionSizeBytes;
    }

    @JsonProperty
    @Nullable
    public Integer getMaxRowsPerSegment() {
        return this.maxRowsPerSegment;
    }

    @JsonProperty
    public Period getSkipOffsetFromLatest() {
        return this.skipOffsetFromLatest;
    }

    @JsonProperty
    @Nullable
    public UserCompactTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    @JsonProperty
    @Nullable
    public Map<String, Object> getTaskContext() {
        return this.taskContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceCompactionConfig that = (DataSourceCompactionConfig)o;
        return this.keepSegmentGranularity == that.keepSegmentGranularity && this.taskPriority == that.taskPriority && this.inputSegmentSizeBytes == that.inputSegmentSizeBytes && this.maxNumSegmentsToCompact == that.maxNumSegmentsToCompact && Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.targetCompactionSizeBytes, that.targetCompactionSizeBytes) && Objects.equals(this.skipOffsetFromLatest, that.skipOffsetFromLatest) && Objects.equals(this.tuningConfig, that.tuningConfig) && Objects.equals(this.taskContext, that.taskContext);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.keepSegmentGranularity, this.taskPriority, this.inputSegmentSizeBytes, this.targetCompactionSizeBytes, this.maxNumSegmentsToCompact, this.skipOffsetFromLatest, this.tuningConfig, this.taskContext);
    }

    public static class UserCompactTuningConfig
    extends ClientCompactQueryTuningConfig {
        @JsonCreator
        public UserCompactTuningConfig(@JsonProperty(value="maxRowsInMemory") @Nullable Integer maxRowsInMemory, @JsonProperty(value="maxTotalRows") @Nullable Integer maxTotalRows, @JsonProperty(value="indexSpec") @Nullable IndexSpec indexSpec, @JsonProperty(value="maxPendingPersists") @Nullable Integer maxPendingPersists, @JsonProperty(value="pushTimeout") @Nullable Long pushTimeout) {
            super(null, maxRowsInMemory, maxTotalRows, indexSpec, maxPendingPersists, pushTimeout);
        }

        @Override
        @Nullable
        @JsonIgnore
        public Integer getMaxRowsPerSegment() {
            throw new UnsupportedOperationException();
        }
    }
}

