/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.utils.ZKPaths;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.DruidDataSource;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.ServerInventoryView;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.curator.discovery.ServiceAnnouncer;
import org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.CoordinatorIndexingServiceHelper;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.metadata.MetadataSegmentManager;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordinator.BalancerStrategy;
import org.apache.druid.server.coordinator.BalancerStrategyFactory;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.LoadPeonCallback;
import org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.druid.server.coordinator.LoadQueueTaskMaster;
import org.apache.druid.server.coordinator.SegmentReplicantLookup;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.helper.DruidCoordinatorBalancer;
import org.apache.druid.server.coordinator.helper.DruidCoordinatorCleanupOvershadowed;
import org.apache.druid.server.coordinator.helper.DruidCoordinatorCleanupUnneeded;
import org.apache.druid.server.coordinator.helper.DruidCoordinatorHelper;
import org.apache.druid.server.coordinator.helper.DruidCoordinatorLogger;
import org.apache.druid.server.coordinator.helper.DruidCoordinatorRuleRunner;
import org.apache.druid.server.coordinator.helper.DruidCoordinatorSegmentCompactor;
import org.apache.druid.server.coordinator.helper.DruidCoordinatorSegmentInfoLoader;
import org.apache.druid.server.coordinator.rules.LoadRule;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.server.initialization.ZkPathsConfig;
import org.apache.druid.server.lookup.cache.LookupCoordinatorManager;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;
import org.joda.time.Duration;

@ManageLifecycle
public class DruidCoordinator {
    static final Comparator<DataSegment> SEGMENT_COMPARATOR_RECENT_FIRST = Ordering.from((Comparator)Comparators.intervalsByEndThenStart()).onResultOf(DataSegment::getInterval).compound((Comparator)Ordering.natural()).reverse();
    private static final EmittingLogger log = new EmittingLogger(DruidCoordinator.class);
    private final Object lock = new Object();
    private final DruidCoordinatorConfig config;
    private final ZkPathsConfig zkPaths;
    private final JacksonConfigManager configManager;
    private final MetadataSegmentManager metadataSegmentManager;
    private final ServerInventoryView serverInventoryView;
    private final MetadataRuleManager metadataRuleManager;
    private final CuratorFramework curator;
    private final ServiceEmitter emitter;
    private final IndexingServiceClient indexingServiceClient;
    private final ScheduledExecutorService exec;
    private final LoadQueueTaskMaster taskMaster;
    private final Map<String, LoadQueuePeon> loadManagementPeons;
    private final ServiceAnnouncer serviceAnnouncer;
    private final DruidNode self;
    private final Set<DruidCoordinatorHelper> indexingServiceHelpers;
    private final BalancerStrategyFactory factory;
    private final LookupCoordinatorManager lookupCoordinatorManager;
    private final DruidLeaderSelector coordLeaderSelector;
    private final DruidCoordinatorSegmentCompactor segmentCompactor;
    private volatile boolean started = false;
    private volatile SegmentReplicantLookup segmentReplicantLookup = null;
    private volatile DataSourcesSnapshot dataSourcesSnapshot = null;

    @Inject
    public DruidCoordinator(DruidCoordinatorConfig config, ZkPathsConfig zkPaths, JacksonConfigManager configManager, MetadataSegmentManager metadataSegmentManager, ServerInventoryView serverInventoryView, MetadataRuleManager metadataRuleManager, CuratorFramework curator, ServiceEmitter emitter, ScheduledExecutorFactory scheduledExecutorFactory, IndexingServiceClient indexingServiceClient, LoadQueueTaskMaster taskMaster, ServiceAnnouncer serviceAnnouncer, @Self DruidNode self, @CoordinatorIndexingServiceHelper Set<DruidCoordinatorHelper> indexingServiceHelpers, BalancerStrategyFactory factory, LookupCoordinatorManager lookupCoordinatorManager, @Coordinator DruidLeaderSelector coordLeaderSelector) {
        this(config, zkPaths, configManager, metadataSegmentManager, serverInventoryView, metadataRuleManager, curator, emitter, scheduledExecutorFactory, indexingServiceClient, taskMaster, serviceAnnouncer, self, new ConcurrentHashMap<String, LoadQueuePeon>(), indexingServiceHelpers, factory, lookupCoordinatorManager, coordLeaderSelector);
    }

    DruidCoordinator(DruidCoordinatorConfig config, ZkPathsConfig zkPaths, JacksonConfigManager configManager, MetadataSegmentManager metadataSegmentManager, ServerInventoryView serverInventoryView, MetadataRuleManager metadataRuleManager, CuratorFramework curator, ServiceEmitter emitter, ScheduledExecutorFactory scheduledExecutorFactory, IndexingServiceClient indexingServiceClient, LoadQueueTaskMaster taskMaster, ServiceAnnouncer serviceAnnouncer, DruidNode self, ConcurrentMap<String, LoadQueuePeon> loadQueuePeonMap, Set<DruidCoordinatorHelper> indexingServiceHelpers, BalancerStrategyFactory factory, LookupCoordinatorManager lookupCoordinatorManager, DruidLeaderSelector coordLeaderSelector) {
        this.config = config;
        this.zkPaths = zkPaths;
        this.configManager = configManager;
        this.metadataSegmentManager = metadataSegmentManager;
        this.serverInventoryView = serverInventoryView;
        this.metadataRuleManager = metadataRuleManager;
        this.curator = curator;
        this.emitter = emitter;
        this.indexingServiceClient = indexingServiceClient;
        this.taskMaster = taskMaster;
        this.serviceAnnouncer = serviceAnnouncer;
        this.self = self;
        this.indexingServiceHelpers = indexingServiceHelpers;
        this.exec = scheduledExecutorFactory.create(1, "Coordinator-Exec--%d");
        this.loadManagementPeons = loadQueuePeonMap;
        this.factory = factory;
        this.lookupCoordinatorManager = lookupCoordinatorManager;
        this.coordLeaderSelector = coordLeaderSelector;
        this.segmentCompactor = new DruidCoordinatorSegmentCompactor(indexingServiceClient);
    }

    public boolean isLeader() {
        return this.coordLeaderSelector.isLeader();
    }

    public Map<String, LoadQueuePeon> getLoadManagementPeons() {
        return this.loadManagementPeons;
    }

    public Map<String, Object2LongMap<String>> computeUnderReplicationCountsPerDataSourcePerTier() {
        HashMap<String, Object2LongMap<String>> underReplicationCountsPerDataSourcePerTier = new HashMap<String, Object2LongMap<String>>();
        if (this.segmentReplicantLookup == null) {
            return underReplicationCountsPerDataSourcePerTier;
        }
        Iterable<DataSegment> dataSegments = this.iterateAvailableDataSegments();
        if (dataSegments == null) {
            return underReplicationCountsPerDataSourcePerTier;
        }
        DateTime now = DateTimes.nowUtc();
        block0: for (DataSegment segment : dataSegments) {
            List<Rule> rules = this.metadataRuleManager.getRulesWithDefault(segment.getDataSource());
            for (Rule rule : rules) {
                if (!(rule instanceof LoadRule) || !rule.appliesTo(segment, now)) continue;
                ((LoadRule)rule).getTieredReplicants().forEach((tier, ruleReplicants) -> {
                    int currentReplicants = this.segmentReplicantLookup.getLoadedReplicants(segment.getId(), (String)tier);
                    Object2LongMap underReplicationPerDataSource = underReplicationCountsPerDataSourcePerTier.computeIfAbsent((String)tier, ignored -> new Object2LongOpenHashMap());
                    ((Object2LongOpenHashMap)underReplicationPerDataSource).addTo((Object)segment.getDataSource(), (long)Math.max(ruleReplicants - currentReplicants, 0));
                });
                continue block0;
            }
        }
        return underReplicationCountsPerDataSourcePerTier;
    }

    public Object2LongMap<String> getSegmentAvailability() {
        Object2LongOpenHashMap retVal = new Object2LongOpenHashMap();
        if (this.segmentReplicantLookup == null) {
            return retVal;
        }
        Iterable<DataSegment> dataSegments = this.iterateAvailableDataSegments();
        if (dataSegments == null) {
            return retVal;
        }
        for (DataSegment segment : dataSegments) {
            if (this.segmentReplicantLookup.getLoadedReplicants(segment.getId()) == 0) {
                retVal.addTo((Object)segment.getDataSource(), 1L);
                continue;
            }
            retVal.addTo((Object)segment.getDataSource(), 0L);
        }
        return retVal;
    }

    public Map<String, Double> getLoadStatus() {
        HashMap<String, Double> loadStatus = new HashMap<String, Double>();
        Collection dataSources = Optional.ofNullable(this.dataSourcesSnapshot).map(m -> m.getDataSources()).orElse(null);
        if (dataSources == null) {
            return loadStatus;
        }
        for (ImmutableDruidDataSource dataSource : dataSources) {
            HashSet segments = Sets.newHashSet(dataSource.getSegments());
            int availableSegmentSize = segments.size();
            for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
                DruidDataSource loadedView = druidServer.getDataSource(dataSource.getName());
                if (loadedView == null) continue;
                for (DataSegment serverSegment : loadedView.getSegments()) {
                    segments.remove(serverSegment);
                }
            }
            int unloadedSegmentSize = segments.size();
            loadStatus.put(dataSource.getName(), 100.0 * ((double)(availableSegmentSize - unloadedSegmentSize) / (double)availableSegmentSize));
        }
        return loadStatus;
    }

    public long remainingSegmentSizeBytesForCompaction(String dataSource) {
        return this.segmentCompactor.getRemainingSegmentSizeBytes(dataSource);
    }

    public CoordinatorDynamicConfig getDynamicConfigs() {
        return CoordinatorDynamicConfig.current(this.configManager);
    }

    public CoordinatorCompactionConfig getCompactionConfig() {
        return CoordinatorCompactionConfig.current(this.configManager);
    }

    public void removeSegment(DataSegment segment) {
        log.info("Removing Segment[%s]", new Object[]{segment.getId()});
        this.metadataSegmentManager.removeSegment(segment.getId().toString());
    }

    public String getCurrentLeader() {
        return this.coordLeaderSelector.getCurrentLeader();
    }

    @VisibleForTesting
    void setDataSourcesSnapshotForTest(DataSourcesSnapshot snapshot) {
        this.dataSourcesSnapshot = snapshot;
    }

    public void moveSegment(ImmutableDruidServer fromServer, ImmutableDruidServer toServer, DataSegment segment, LoadPeonCallback callback) {
        block12: {
            if (segment == null) {
                log.makeAlert((Throwable)new IAE("Can not move null DataSegment", new Object[0]), "Exception moving null segment", new Object[0]).emit();
                if (callback != null) {
                    callback.execute();
                }
                throw new ISE("Cannot move null DataSegment", new Object[0]);
            }
            SegmentId segmentId = segment.getId();
            try {
                if (fromServer.getMetadata().equals(toServer.getMetadata())) {
                    throw new IAE("Cannot move [%s] to and from the same server [%s]", new Object[]{segmentId, fromServer.getName()});
                }
                ImmutableDruidDataSource dataSource = Optional.ofNullable(this.dataSourcesSnapshot).map(m -> m.getDataSource(segment.getDataSource())).orElse(null);
                if (dataSource == null) {
                    throw new IAE("Unable to find dataSource for segment [%s] in metadata", new Object[]{segmentId});
                }
                DataSegment segmentToLoad = dataSource.getSegment(segment.getId());
                if (segmentToLoad == null) {
                    throw new IAE("No segment metadata found for segment Id [%s]", new Object[]{segment.getId()});
                }
                LoadQueuePeon loadPeon = this.loadManagementPeons.get(toServer.getName());
                if (loadPeon == null) {
                    throw new IAE("LoadQueuePeon hasn't been created yet for path [%s]", new Object[]{toServer.getName()});
                }
                LoadQueuePeon dropPeon = this.loadManagementPeons.get(fromServer.getName());
                if (dropPeon == null) {
                    throw new IAE("LoadQueuePeon hasn't been created yet for path [%s]", new Object[]{fromServer.getName()});
                }
                ServerHolder toHolder = new ServerHolder(toServer, loadPeon);
                if (toHolder.getAvailableSize() < segmentToLoad.getSize()) {
                    throw new IAE("Not enough capacity on server [%s] for segment [%s]. Required: %,d, available: %,d.", new Object[]{toServer.getName(), segmentToLoad, segmentToLoad.getSize(), toHolder.getAvailableSize()});
                }
                String toLoadQueueSegPath = ZKPaths.makePath((String)this.zkPaths.getLoadQueuePath(), (String)toServer.getName(), (String[])new String[]{segmentId.toString()});
                LoadPeonCallback loadPeonCallback = () -> {
                    dropPeon.unmarkSegmentToDrop(segmentToLoad);
                    if (callback != null) {
                        callback.execute();
                    }
                };
                dropPeon.markSegmentToDrop(segmentToLoad);
                try {
                    loadPeon.loadSegment(segmentToLoad, () -> {
                        try {
                            if (this.serverInventoryView.isSegmentLoadedByServer(toServer.getName(), segment) && this.curator.checkExists().forPath(toLoadQueueSegPath) == null && !dropPeon.getSegmentsToDrop().contains(segment)) {
                                dropPeon.dropSegment(segment, loadPeonCallback);
                            } else {
                                loadPeonCallback.execute();
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                catch (Exception e) {
                    dropPeon.unmarkSegmentToDrop(segmentToLoad);
                    throw new RuntimeException(e);
                }
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Exception moving segment %s", new Object[]{segmentId}).emit();
                if (callback == null) break block12;
                callback.execute();
            }
        }
    }

    @Nullable
    public Iterable<DataSegment> iterateAvailableDataSegments() {
        Iterable dataSources = Optional.ofNullable(this.dataSourcesSnapshot).map(m -> m.iterateAllSegmentsInSnapshot()).orElse(null);
        return dataSources == null ? null : dataSources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.coordLeaderSelector.registerListener(new DruidLeaderSelector.Listener(){

                @Override
                public void becomeLeader() {
                    DruidCoordinator.this.becomeLeader();
                }

                @Override
                public void stopBeingLeader() {
                    DruidCoordinator.this.stopBeingLeader();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.coordLeaderSelector.unregisterListener();
            this.started = false;
            this.exec.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void becomeLeader() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            log.info("I am the leader of the coordinators, all must bow!", new Object[0]);
            log.info("Starting coordination in [%s]", new Object[]{this.config.getCoordinatorStartDelay()});
            this.metadataSegmentManager.start();
            this.metadataRuleManager.start();
            this.lookupCoordinatorManager.start();
            this.serviceAnnouncer.announce(this.self);
            final int startingLeaderCounter = this.coordLeaderSelector.localTerm();
            ArrayList<Pair> coordinatorRunnables = new ArrayList<Pair>();
            coordinatorRunnables.add(Pair.of((Object)new CoordinatorHistoricalManagerRunnable(startingLeaderCounter), (Object)this.config.getCoordinatorPeriod()));
            if (this.indexingServiceClient != null) {
                coordinatorRunnables.add(Pair.of((Object)new CoordinatorIndexingServiceRunnable(this.makeIndexingServiceHelpers(), startingLeaderCounter), (Object)this.config.getCoordinatorIndexingPeriod()));
            }
            for (final Pair coordinatorRunnable : coordinatorRunnables) {
                ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.exec, (Duration)this.config.getCoordinatorStartDelay(), (Duration)((Duration)coordinatorRunnable.rhs), (Callable)new Callable<ScheduledExecutors.Signal>(){
                    private final CoordinatorRunnable theRunnable;
                    {
                        this.theRunnable = (CoordinatorRunnable)coordinatorRunnable.lhs;
                    }

                    @Override
                    public ScheduledExecutors.Signal call() {
                        if (DruidCoordinator.this.coordLeaderSelector.isLeader() && startingLeaderCounter == DruidCoordinator.this.coordLeaderSelector.localTerm()) {
                            this.theRunnable.run();
                        }
                        if (DruidCoordinator.this.coordLeaderSelector.isLeader() && startingLeaderCounter == DruidCoordinator.this.coordLeaderSelector.localTerm()) {
                            return ScheduledExecutors.Signal.REPEAT;
                        }
                        return ScheduledExecutors.Signal.STOP;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBeingLeader() {
        Object object = this.lock;
        synchronized (object) {
            log.info("I am no longer the leader...", new Object[0]);
            for (String server : this.loadManagementPeons.keySet()) {
                LoadQueuePeon peon = this.loadManagementPeons.remove(server);
                peon.stop();
            }
            this.loadManagementPeons.clear();
            this.serviceAnnouncer.unannounce(this.self);
            this.lookupCoordinatorManager.stop();
            this.metadataRuleManager.stop();
            this.metadataSegmentManager.stop();
        }
    }

    private List<DruidCoordinatorHelper> makeIndexingServiceHelpers() {
        ArrayList<DruidCoordinatorHelper> helpers = new ArrayList<DruidCoordinatorHelper>();
        helpers.add(new DruidCoordinatorSegmentInfoLoader(this));
        helpers.add(this.segmentCompactor);
        helpers.addAll(this.indexingServiceHelpers);
        log.info("Done making indexing service helpers [%s]", new Object[]{helpers.stream().map(helper -> helper.getClass().getCanonicalName()).collect(Collectors.toList())});
        return ImmutableList.copyOf(helpers);
    }

    private class CoordinatorIndexingServiceRunnable
    extends CoordinatorRunnable {
        public CoordinatorIndexingServiceRunnable(List<DruidCoordinatorHelper> helpers, int startingLeaderCounter) {
            super(helpers, startingLeaderCounter);
        }
    }

    private class CoordinatorHistoricalManagerRunnable
    extends CoordinatorRunnable {
        public CoordinatorHistoricalManagerRunnable(int startingLeaderCounter) {
            super((List<DruidCoordinatorHelper>)ImmutableList.of((Object)new DruidCoordinatorSegmentInfoLoader(DruidCoordinator.this), params -> {
                List servers = DruidCoordinator.this.serverInventoryView.getInventory().stream().filter(DruidServer::segmentReplicatable).map(DruidServer::toImmutableDruidServer).collect(Collectors.toList());
                if (log.isDebugEnabled()) {
                    log.debug("Servers", new Object[0]);
                    for (ImmutableDruidServer druidServer : servers) {
                        log.debug("  %s", new Object[]{druidServer});
                        log.debug("    -- DataSources", new Object[0]);
                        for (ImmutableDruidDataSource druidDataSource : druidServer.getDataSources()) {
                            log.debug("    %s", new Object[]{druidDataSource});
                        }
                    }
                }
                Set<String> decommissioningServers = params.getCoordinatorDynamicConfig().getDecommissioningNodes();
                DruidCluster cluster = new DruidCluster();
                for (ImmutableDruidServer server : servers) {
                    if (!DruidCoordinator.this.loadManagementPeons.containsKey(server.getName())) {
                        LoadQueuePeon loadQueuePeon = DruidCoordinator.this.taskMaster.giveMePeon(server);
                        loadQueuePeon.start();
                        log.info("Created LoadQueuePeon for server[%s].", new Object[]{server.getName()});
                        DruidCoordinator.this.loadManagementPeons.put(server.getName(), loadQueuePeon);
                    }
                    cluster.add(new ServerHolder(server, (LoadQueuePeon)DruidCoordinator.this.loadManagementPeons.get(server.getName()), decommissioningServers.contains(server.getHost())));
                }
                DruidCoordinator.this.segmentReplicantLookup = SegmentReplicantLookup.make(cluster);
                HashSet disappeared = Sets.newHashSet(DruidCoordinator.this.loadManagementPeons.keySet());
                for (ImmutableDruidServer server : servers) {
                    disappeared.remove(server.getName());
                }
                for (String name : disappeared) {
                    log.info("Removing listener for server[%s] which is no longer there.", new Object[]{name});
                    LoadQueuePeon peon = (LoadQueuePeon)DruidCoordinator.this.loadManagementPeons.remove(name);
                    peon.stop();
                }
                return params.buildFromExisting().withDruidCluster(cluster).withDatabaseRuleManager(DruidCoordinator.this.metadataRuleManager).withLoadManagementPeons(DruidCoordinator.this.loadManagementPeons).withSegmentReplicantLookup(DruidCoordinator.this.segmentReplicantLookup).withBalancerReferenceTimestamp(DateTimes.nowUtc()).build();
            }, (Object)new DruidCoordinatorRuleRunner(DruidCoordinator.this), (Object)new DruidCoordinatorCleanupUnneeded(), (Object)new DruidCoordinatorCleanupOvershadowed(DruidCoordinator.this), (Object)new DruidCoordinatorBalancer(DruidCoordinator.this), (Object)new DruidCoordinatorLogger(DruidCoordinator.this)), startingLeaderCounter);
        }
    }

    public abstract class CoordinatorRunnable
    implements Runnable {
        private final long startTime = System.currentTimeMillis();
        private final List<DruidCoordinatorHelper> helpers;
        private final int startingLeaderCounter;

        protected CoordinatorRunnable(List<DruidCoordinatorHelper> helpers, int startingLeaderCounter) {
            this.helpers = helpers;
            this.startingLeaderCounter = startingLeaderCounter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            ListeningExecutorService balancerExec = null;
            try {
                DruidCoordinatorHelper helper;
                Object object = DruidCoordinator.this.lock;
                synchronized (object) {
                    if (!DruidCoordinator.this.coordLeaderSelector.isLeader()) {
                        log.info("LEGGO MY EGGO. [%s] is leader.", new Object[]{DruidCoordinator.this.coordLeaderSelector.getCurrentLeader()});
                        DruidCoordinator.this.stopBeingLeader();
                        return;
                    }
                }
                List<Boolean> allStarted = Arrays.asList(DruidCoordinator.this.metadataSegmentManager.isStarted(), DruidCoordinator.this.serverInventoryView.isStarted());
                for (Boolean aBoolean : allStarted) {
                    if (aBoolean.booleanValue()) continue;
                    log.error("InventoryManagers not started[%s]", new Object[]{allStarted});
                    DruidCoordinator.this.stopBeingLeader();
                    return;
                }
                balancerExec = MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)DruidCoordinator.this.getDynamicConfigs().getBalancerComputeThreads(), (String)"coordinator-cost-balancer-%s"));
                BalancerStrategy balancerStrategy = DruidCoordinator.this.factory.createBalancerStrategy(balancerExec);
                DruidCoordinator.this.dataSourcesSnapshot = DruidCoordinator.this.metadataSegmentManager.getDataSourcesSnapshot();
                Collection dataSources = Optional.ofNullable(DruidCoordinator.this.dataSourcesSnapshot).map(m -> m.getDataSources()).orElse(null);
                if (dataSources == null) {
                    log.info("Metadata store not polled yet, skipping this run.", new Object[0]);
                    return;
                }
                DruidCoordinatorRuntimeParams params = DruidCoordinatorRuntimeParams.newBuilder().withStartTime(this.startTime).withDataSources(dataSources).withDynamicConfigs(DruidCoordinator.this.getDynamicConfigs()).withCompactionConfig(DruidCoordinator.this.getCompactionConfig()).withEmitter(DruidCoordinator.this.emitter).withBalancerStrategy(balancerStrategy).withDataSourcesSnapshot(DruidCoordinator.this.dataSourcesSnapshot).build();
                Iterator<DruidCoordinatorHelper> iterator = this.helpers.iterator();
                do {
                    if (!iterator.hasNext()) return;
                    helper = iterator.next();
                } while (!DruidCoordinator.this.coordLeaderSelector.isLeader() || this.startingLeaderCounter != DruidCoordinator.this.coordLeaderSelector.localTerm() || (params = helper.run(params)) != null);
                return;
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Caught exception, ignoring so that schedule keeps going.", new Object[0]).emit();
                return;
            }
            finally {
                if (balancerExec != null) {
                    balancerExec.shutdownNow();
                }
            }
        }
    }
}

