/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.helper.DruidCoordinatorHelper;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

public class DruidCoordinatorCleanupPendingSegments
implements DruidCoordinatorHelper {
    private static final Logger log = new Logger(DruidCoordinatorCleanupPendingSegments.class);
    private static final Period KEEP_PENDING_SEGMENTS_OFFSET = new Period((Object)"P1D");
    private final IndexingServiceClient indexingServiceClient;

    @Inject
    public DruidCoordinatorCleanupPendingSegments(IndexingServiceClient indexingServiceClient) {
        this.indexingServiceClient = indexingServiceClient;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        ArrayList<DateTime> createdTimes = new ArrayList<DateTime>();
        createdTimes.add(this.indexingServiceClient.getActiveTasks().stream().map(TaskStatusPlus::getCreatedTime).min((Comparator<DateTime>)Comparators.naturalNullsFirst()).orElse(DateTimes.nowUtc()));
        TaskStatusPlus completeTaskStatus = this.indexingServiceClient.getLastCompleteTask();
        if (completeTaskStatus != null) {
            createdTimes.add(completeTaskStatus.getCreatedTime());
        }
        createdTimes.sort((Comparator<DateTime>)Comparators.naturalNullsFirst());
        Preconditions.checkState((!createdTimes.isEmpty() ? 1 : 0) != 0, (Object)"Failed to gather createdTimes of tasks");
        DateTime pendingSegmentsCleanupEndTime = ((DateTime)createdTimes.get(0)).minus((ReadablePeriod)KEEP_PENDING_SEGMENTS_OFFSET);
        for (String dataSource : params.getDataSources().keySet()) {
            if (params.getCoordinatorDynamicConfig().getProtectedPendingSegmentDatasources().contains(dataSource)) continue;
            log.info("Killed [%d] pendingSegments created until [%s] for dataSource[%s]", new Object[]{this.indexingServiceClient.killPendingSegments(dataSource, pendingSegmentsCleanupEndTime), pendingSegmentsCleanupEndTime, dataSource});
        }
        return params;
    }
}

