/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.server.coordinator.BalancerStrategy;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.druid.server.coordinator.ReplicationThrottler;
import org.apache.druid.server.coordinator.SegmentReplicantLookup;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.joda.time.DateTime;

public class DruidCoordinatorRuntimeParams {
    private final long startTime;
    private final DruidCluster druidCluster;
    private final MetadataRuleManager databaseRuleManager;
    private final SegmentReplicantLookup segmentReplicantLookup;
    private final Map<String, VersionedIntervalTimeline<String, DataSegment>> dataSources;
    @Nullable
    private final TreeSet<DataSegment> availableSegments;
    private final Map<String, LoadQueuePeon> loadManagementPeons;
    private final ReplicationThrottler replicationManager;
    private final ServiceEmitter emitter;
    private final CoordinatorDynamicConfig coordinatorDynamicConfig;
    private final CoordinatorCompactionConfig coordinatorCompactionConfig;
    private final CoordinatorStats stats;
    private final DateTime balancerReferenceTimestamp;
    private final BalancerStrategy balancerStrategy;
    private final DataSourcesSnapshot dataSourcesSnapshot;

    public static TreeSet<DataSegment> createAvailableSegmentsSet(Iterable<DataSegment> availableSegments) {
        TreeSet<DataSegment> segmentsSet = new TreeSet<DataSegment>(DruidCoordinator.SEGMENT_COMPARATOR_RECENT_FIRST);
        availableSegments.forEach(segmentsSet::add);
        return segmentsSet;
    }

    private DruidCoordinatorRuntimeParams(long startTime, DruidCluster druidCluster, MetadataRuleManager databaseRuleManager, SegmentReplicantLookup segmentReplicantLookup, Map<String, VersionedIntervalTimeline<String, DataSegment>> dataSources, @Nullable TreeSet<DataSegment> availableSegments, Map<String, LoadQueuePeon> loadManagementPeons, ReplicationThrottler replicationManager, ServiceEmitter emitter, CoordinatorDynamicConfig coordinatorDynamicConfig, CoordinatorCompactionConfig coordinatorCompactionConfig, CoordinatorStats stats, DateTime balancerReferenceTimestamp, BalancerStrategy balancerStrategy, DataSourcesSnapshot dataSourcesSnapshot) {
        this.startTime = startTime;
        this.druidCluster = druidCluster;
        this.databaseRuleManager = databaseRuleManager;
        this.segmentReplicantLookup = segmentReplicantLookup;
        this.dataSources = dataSources;
        this.availableSegments = availableSegments;
        this.loadManagementPeons = loadManagementPeons;
        this.replicationManager = replicationManager;
        this.emitter = emitter;
        this.coordinatorDynamicConfig = coordinatorDynamicConfig;
        this.coordinatorCompactionConfig = coordinatorCompactionConfig;
        this.stats = stats;
        this.balancerReferenceTimestamp = balancerReferenceTimestamp;
        this.balancerStrategy = balancerStrategy;
        this.dataSourcesSnapshot = dataSourcesSnapshot;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public DruidCluster getDruidCluster() {
        return this.druidCluster;
    }

    public MetadataRuleManager getDatabaseRuleManager() {
        return this.databaseRuleManager;
    }

    public SegmentReplicantLookup getSegmentReplicantLookup() {
        return this.segmentReplicantLookup;
    }

    public Map<String, VersionedIntervalTimeline<String, DataSegment>> getDataSources() {
        return this.dataSources;
    }

    public TreeSet<DataSegment> getAvailableSegments() {
        Preconditions.checkState((this.availableSegments != null ? 1 : 0) != 0, (Object)"availableSegments must be set");
        return this.availableSegments;
    }

    public Map<String, LoadQueuePeon> getLoadManagementPeons() {
        return this.loadManagementPeons;
    }

    public ReplicationThrottler getReplicationManager() {
        return this.replicationManager;
    }

    public ServiceEmitter getEmitter() {
        return this.emitter;
    }

    public CoordinatorDynamicConfig getCoordinatorDynamicConfig() {
        return this.coordinatorDynamicConfig;
    }

    public CoordinatorCompactionConfig getCoordinatorCompactionConfig() {
        return this.coordinatorCompactionConfig;
    }

    public CoordinatorStats getCoordinatorStats() {
        return this.stats;
    }

    public DateTime getBalancerReferenceTimestamp() {
        return this.balancerReferenceTimestamp;
    }

    public BalancerStrategy getBalancerStrategy() {
        return this.balancerStrategy;
    }

    public DataSourcesSnapshot getDataSourcesSnapshot() {
        return this.dataSourcesSnapshot;
    }

    public boolean hasDeletionWaitTimeElapsed() {
        return System.currentTimeMillis() - this.getStartTime() > this.coordinatorDynamicConfig.getMillisToWaitBeforeDeleting();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder buildFromExisting() {
        return new Builder(this.startTime, this.druidCluster, this.databaseRuleManager, this.segmentReplicantLookup, this.dataSources, this.availableSegments, this.loadManagementPeons, this.replicationManager, this.emitter, this.coordinatorDynamicConfig, this.coordinatorCompactionConfig, this.stats, this.balancerReferenceTimestamp, this.balancerStrategy);
    }

    public Builder buildFromExistingWithoutAvailableSegments() {
        return new Builder(this.startTime, this.druidCluster, this.databaseRuleManager, this.segmentReplicantLookup, this.dataSources, null, this.loadManagementPeons, this.replicationManager, this.emitter, this.coordinatorDynamicConfig, this.coordinatorCompactionConfig, this.stats, this.balancerReferenceTimestamp, this.balancerStrategy);
    }

    public static class Builder {
        private long startTime;
        private DruidCluster druidCluster;
        private MetadataRuleManager databaseRuleManager;
        private SegmentReplicantLookup segmentReplicantLookup;
        private Map<String, VersionedIntervalTimeline<String, DataSegment>> dataSources;
        @Nullable
        private TreeSet<DataSegment> availableSegments;
        private final Map<String, LoadQueuePeon> loadManagementPeons;
        private ReplicationThrottler replicationManager;
        private ServiceEmitter emitter;
        private CoordinatorDynamicConfig coordinatorDynamicConfig;
        private CoordinatorCompactionConfig coordinatorCompactionConfig;
        private CoordinatorStats stats;
        private DateTime balancerReferenceTimestamp;
        private BalancerStrategy balancerStrategy;
        private DataSourcesSnapshot dataSourcesSnapshot;

        Builder() {
            this.startTime = 0L;
            this.druidCluster = null;
            this.databaseRuleManager = null;
            this.segmentReplicantLookup = null;
            this.dataSources = new HashMap<String, VersionedIntervalTimeline<String, DataSegment>>();
            this.availableSegments = null;
            this.loadManagementPeons = new HashMap<String, LoadQueuePeon>();
            this.replicationManager = null;
            this.emitter = null;
            this.stats = new CoordinatorStats();
            this.coordinatorDynamicConfig = CoordinatorDynamicConfig.builder().build();
            this.coordinatorCompactionConfig = CoordinatorCompactionConfig.empty();
            this.balancerReferenceTimestamp = DateTimes.nowUtc();
            this.dataSourcesSnapshot = null;
        }

        Builder(long startTime, DruidCluster cluster, MetadataRuleManager databaseRuleManager, SegmentReplicantLookup segmentReplicantLookup, Map<String, VersionedIntervalTimeline<String, DataSegment>> dataSources, @Nullable TreeSet<DataSegment> availableSegments, Map<String, LoadQueuePeon> loadManagementPeons, ReplicationThrottler replicationManager, ServiceEmitter emitter, CoordinatorDynamicConfig coordinatorDynamicConfig, CoordinatorCompactionConfig coordinatorCompactionConfig, CoordinatorStats stats, DateTime balancerReferenceTimestamp, BalancerStrategy balancerStrategy) {
            this.startTime = startTime;
            this.druidCluster = cluster;
            this.databaseRuleManager = databaseRuleManager;
            this.segmentReplicantLookup = segmentReplicantLookup;
            this.dataSources = dataSources;
            this.availableSegments = availableSegments;
            this.loadManagementPeons = loadManagementPeons;
            this.replicationManager = replicationManager;
            this.emitter = emitter;
            this.coordinatorDynamicConfig = coordinatorDynamicConfig;
            this.coordinatorCompactionConfig = coordinatorCompactionConfig;
            this.stats = stats;
            this.balancerReferenceTimestamp = balancerReferenceTimestamp;
            this.balancerStrategy = balancerStrategy;
        }

        public DruidCoordinatorRuntimeParams build() {
            return new DruidCoordinatorRuntimeParams(this.startTime, this.druidCluster, this.databaseRuleManager, this.segmentReplicantLookup, this.dataSources, this.availableSegments, this.loadManagementPeons, this.replicationManager, this.emitter, this.coordinatorDynamicConfig, this.coordinatorCompactionConfig, this.stats, this.balancerReferenceTimestamp, this.balancerStrategy, this.dataSourcesSnapshot);
        }

        public Builder withStartTime(long time) {
            this.startTime = time;
            return this;
        }

        public Builder withDruidCluster(DruidCluster cluster) {
            this.druidCluster = cluster;
            return this;
        }

        public Builder withDatabaseRuleManager(MetadataRuleManager databaseRuleManager) {
            this.databaseRuleManager = databaseRuleManager;
            return this;
        }

        public Builder withSegmentReplicantLookup(SegmentReplicantLookup lookup) {
            this.segmentReplicantLookup = lookup;
            return this;
        }

        public Builder withDataSources(Map<String, VersionedIntervalTimeline<String, DataSegment>> dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public Builder withDataSources(Collection<ImmutableDruidDataSource> dataSourcesCollection) {
            dataSourcesCollection.forEach(dataSource -> {
                VersionedIntervalTimeline timeline = this.dataSources.computeIfAbsent(dataSource.getName(), k -> new VersionedIntervalTimeline(String.CASE_INSENSITIVE_ORDER));
                dataSource.getSegments().forEach(segment -> timeline.add(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk(segment)));
            });
            return this;
        }

        @VisibleForTesting
        public Builder withAvailableSegmentsInTest(DataSegment ... availableSegments) {
            return this.withAvailableSegmentsInTest(Arrays.asList(availableSegments));
        }

        @VisibleForTesting
        public Builder withAvailableSegmentsInTest(Collection<DataSegment> availableSegments) {
            return this.setAvailableSegments(DruidCoordinatorRuntimeParams.createAvailableSegmentsSet(availableSegments));
        }

        public Builder setAvailableSegments(TreeSet<DataSegment> availableSegments) {
            if (availableSegments.comparator() != DruidCoordinator.SEGMENT_COMPARATOR_RECENT_FIRST) {
                throw new IllegalArgumentException("Expected DruidCoordinator.SEGMENT_COMPARATOR_RECENT_FIRST");
            }
            this.availableSegments = availableSegments;
            return this;
        }

        public Builder withLoadManagementPeons(Map<String, LoadQueuePeon> loadManagementPeonsCollection) {
            this.loadManagementPeons.putAll(loadManagementPeonsCollection);
            return this;
        }

        public Builder withReplicationManager(ReplicationThrottler replicationManager) {
            this.replicationManager = replicationManager;
            return this;
        }

        public Builder withEmitter(ServiceEmitter emitter) {
            this.emitter = emitter;
            return this;
        }

        public Builder withCoordinatorStats(CoordinatorStats stats) {
            this.stats.accumulate(stats);
            return this;
        }

        public Builder withDynamicConfigs(CoordinatorDynamicConfig configs) {
            this.coordinatorDynamicConfig = configs;
            return this;
        }

        public Builder withCompactionConfig(CoordinatorCompactionConfig config) {
            this.coordinatorCompactionConfig = config;
            return this;
        }

        public Builder withBalancerReferenceTimestamp(DateTime balancerReferenceTimestamp) {
            this.balancerReferenceTimestamp = balancerReferenceTimestamp;
            return this;
        }

        public Builder withBalancerStrategy(BalancerStrategy balancerStrategy) {
            this.balancerStrategy = balancerStrategy;
            return this;
        }

        public Builder withDataSourcesSnapshot(DataSourcesSnapshot snapshot) {
            this.dataSourcesSnapshot = snapshot;
            return this;
        }
    }
}

