/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.server.coordinator.BalancerSegmentHolder;
import org.apache.druid.server.coordinator.BalancerStrategy;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.ReservoirSegmentSampler;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.timeline.DataSegment;

public class RandomBalancerStrategy
implements BalancerStrategy {
    @Override
    public ServerHolder findNewSegmentHomeReplicator(DataSegment proposalSegment, List<ServerHolder> serverHolders) {
        if (serverHolders.size() == 1) {
            return null;
        }
        ServerHolder holder = serverHolders.get(ThreadLocalRandom.current().nextInt(serverHolders.size()));
        while (holder.isServingSegment(proposalSegment)) {
            holder = serverHolders.get(ThreadLocalRandom.current().nextInt(serverHolders.size()));
        }
        return holder;
    }

    @Override
    public ServerHolder findNewSegmentHomeBalancer(DataSegment proposalSegment, List<ServerHolder> serverHolders) {
        return null;
    }

    @Override
    public BalancerSegmentHolder pickSegmentToMove(List<ServerHolder> serverHolders) {
        return ReservoirSegmentSampler.getRandomBalancerSegmentHolder(serverHolders);
    }

    @Override
    public Iterator<ServerHolder> pickServersToDrop(DataSegment toDropSegment, NavigableSet<ServerHolder> serverHolders) {
        ArrayList<ServerHolder> serverList = new ArrayList<ServerHolder>(serverHolders);
        Collections.shuffle(serverList);
        return serverList.iterator();
    }

    @Override
    public void emitStats(String tier, CoordinatorStats stats, List<ServerHolder> serverHolderList) {
    }
}

