/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.helper;

import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.helper.DruidCoordinatorHelper;
import org.apache.druid.timeline.DataSegment;

public class DruidCoordinatorCleanupUnneeded
implements DruidCoordinatorHelper {
    private static final Logger log = new Logger(DruidCoordinatorCleanupUnneeded.class);

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        CoordinatorStats stats = new CoordinatorStats();
        TreeSet<DataSegment> availableSegments = params.getAvailableSegments();
        DruidCluster cluster = params.getDruidCluster();
        for (SortedSet sortedSet : cluster.getSortedHistoricalsByTier()) {
            for (ServerHolder serverHolder : sortedSet) {
                ImmutableDruidServer server = serverHolder.getServer();
                for (ImmutableDruidDataSource dataSource : server.getDataSources()) {
                    for (DataSegment segment : dataSource.getSegments()) {
                        LoadQueuePeon queuePeon;
                        if (availableSegments.contains(segment) || (queuePeon = params.getLoadManagementPeons().get(server.getName())).getSegmentsToDrop().contains(segment)) continue;
                        queuePeon.dropSegment(segment, () -> {});
                        stats.addToTieredStat("unneededCount", server.getTier(), 1L);
                        log.info("Dropping uneeded segment [%s] from server [%s] in tier [%s]", new Object[]{segment.getId(), server.getName(), server.getTier()});
                    }
                }
            }
        }
        return params.buildFromExisting().withCoordinatorStats(stats).build();
    }
}

