/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.helper;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.helper.DruidCoordinatorHelper;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.PartitionChunk;

public class DruidCoordinatorLogger
implements DruidCoordinatorHelper {
    private static final Logger log = new Logger(DruidCoordinatorLogger.class);
    private final DruidCoordinator coordinator;

    public DruidCoordinatorLogger(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    private void emitTieredStat(ServiceEmitter emitter, String metricName, String tier, double value) {
        emitter.emit(new ServiceMetricEvent.Builder().setDimension("tier", tier).build(metricName, (Number)value));
    }

    private void emitTieredStats(ServiceEmitter emitter, String metricName, CoordinatorStats stats, String statName) {
        stats.forEachTieredStat(statName, (tier, count) -> this.emitTieredStat(emitter, metricName, (String)tier, count));
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        DruidCluster cluster = params.getDruidCluster();
        CoordinatorStats stats = params.getCoordinatorStats();
        ServiceEmitter emitter = params.getEmitter();
        stats.forEachTieredStat("assignedCount", (tier, count) -> {
            log.info("[%s] : Assigned %s segments among %,d servers", new Object[]{tier, count, cluster.getHistoricalsByTier((String)tier).size()});
            this.emitTieredStat(emitter, "segment/assigned/count", (String)tier, count);
        });
        stats.forEachTieredStat("droppedCount", (tier, count) -> {
            log.info("[%s] : Dropped %s segments among %,d servers", new Object[]{tier, count, cluster.getHistoricalsByTier((String)tier).size()});
            this.emitTieredStat(emitter, "segment/dropped/count", (String)tier, count);
        });
        this.emitTieredStats(emitter, "segment/cost/raw", stats, "initialCost");
        this.emitTieredStats(emitter, "segment/cost/normalization", stats, "normalization");
        this.emitTieredStats(emitter, "segment/moved/count", stats, "movedCount");
        this.emitTieredStats(emitter, "segment/deleted/count", stats, "deletedCount");
        stats.forEachTieredStat("normalizedInitialCostTimesOneThousand", (tier, count) -> this.emitTieredStat(emitter, "segment/cost/normalized", (String)tier, (double)count / 1000.0));
        stats.forEachTieredStat("unneededCount", (tier, count) -> {
            log.info("[%s] : Removed %s unneeded segments among %,d servers", new Object[]{tier, count, cluster.getHistoricalsByTier((String)tier).size()});
            this.emitTieredStat(emitter, "segment/unneeded/count", (String)tier, count);
        });
        emitter.emit(new ServiceMetricEvent.Builder().build("segment/overShadowed/count", (Number)stats.getGlobalStat("overShadowedCount")));
        stats.forEachTieredStat("movedCount", (tier, count) -> log.info("[%s] : Moved %,d segment(s)", new Object[]{tier, count}));
        stats.forEachTieredStat("unmovedCount", (tier, count) -> log.info("[%s] : Let alone %,d segment(s)", new Object[]{tier, count}));
        log.info("Load Queues:", new Object[0]);
        for (Iterable iterable : cluster.getSortedHistoricalsByTier()) {
            for (ServerHolder serverHolder : iterable) {
                ImmutableDruidServer server = serverHolder.getServer();
                LoadQueuePeon queuePeon2 = serverHolder.getPeon();
                log.info("Server[%s, %s, %s] has %,d left to load, %,d left to drop, %,d bytes queued, %,d bytes served.", new Object[]{server.getName(), server.getType().toString(), server.getTier(), queuePeon2.getSegmentsToLoad().size(), queuePeon2.getSegmentsToDrop().size(), queuePeon2.getLoadQueueSize(), server.getCurrSize()});
                if (!log.isDebugEnabled()) continue;
                for (DataSegment segment : queuePeon2.getSegmentsToLoad()) {
                    log.debug("Segment to load[%s]", new Object[]{segment});
                }
                for (DataSegment segment : queuePeon2.getSegmentsToDrop()) {
                    log.debug("Segment to drop[%s]", new Object[]{segment});
                }
            }
        }
        params.getLoadManagementPeons().forEach((serverName, queuePeon) -> {
            emitter.emit(new ServiceMetricEvent.Builder().setDimension("server", serverName).build("segment/loadQueue/size", (Number)queuePeon.getLoadQueueSize()));
            emitter.emit(new ServiceMetricEvent.Builder().setDimension("server", serverName).build("segment/loadQueue/failed", (Number)queuePeon.getAndResetFailedAssignCount()));
            emitter.emit(new ServiceMetricEvent.Builder().setDimension("server", serverName).build("segment/loadQueue/count", (Number)queuePeon.getSegmentsToLoad().size()));
            emitter.emit(new ServiceMetricEvent.Builder().setDimension("server", serverName).build("segment/dropQueue/count", (Number)queuePeon.getSegmentsToDrop().size()));
        });
        this.coordinator.getSegmentAvailability().object2LongEntrySet().forEach(entry -> {
            String dataSource = (String)entry.getKey();
            long count = entry.getLongValue();
            emitter.emit(new ServiceMetricEvent.Builder().setDimension("dataSource", dataSource).build("segment/unavailable/count", (Number)count));
        });
        this.coordinator.computeUnderReplicationCountsPerDataSourcePerTier().forEach((tier, underReplicationCountsPerDataSource) -> {
            for (Object2LongMap.Entry entry : underReplicationCountsPerDataSource.object2LongEntrySet()) {
                String dataSource = (String)entry.getKey();
                long underReplicationCount = entry.getLongValue();
                emitter.emit(new ServiceMetricEvent.Builder().setDimension("tier", tier).setDimension("dataSource", dataSource).build("segment/underReplicated/count", (Number)underReplicationCount));
            }
        });
        emitter.emit(new ServiceMetricEvent.Builder().build("compact/task/count", (Number)stats.getGlobalStat("compactTaskCount")));
        stats.forEachDataSourceStat("segmentsWaitCompact", (dataSource, count) -> emitter.emit(new ServiceMetricEvent.Builder().setDimension("dataSource", dataSource).build("segment/waitCompact/count", (Number)count)));
        Stream<DataSegment> allSegments = params.getDataSources().values().stream().flatMap(timeline -> timeline.getAllTimelineEntries().values().stream()).flatMap(entryMap -> entryMap.values().stream()).flatMap(entry -> StreamSupport.stream(entry.getPartitionHolder().spliterator(), false)).map(PartitionChunk::getObject);
        allSegments.collect(Collectors.groupingBy(DataSegment::getDataSource)).forEach((name, segments) -> {
            long size = segments.stream().mapToLong(DataSegment::getSize).sum();
            emitter.emit(new ServiceMetricEvent.Builder().setDimension("dataSource", name).build("segment/size", (Number)size));
            emitter.emit(new ServiceMetricEvent.Builder().setDimension("dataSource", name).build("segment/count", (Number)segments.size()));
        });
        return params;
    }
}

