/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.helper;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.ReplicationThrottler;
import org.apache.druid.server.coordinator.helper.DruidCoordinatorHelper;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;

public class DruidCoordinatorRuleRunner
implements DruidCoordinatorHelper {
    private static final EmittingLogger log = new EmittingLogger(DruidCoordinatorRuleRunner.class);
    private static int MAX_MISSING_RULES = 10;
    private final ReplicationThrottler replicatorThrottler;
    private final DruidCoordinator coordinator;

    public DruidCoordinatorRuleRunner(DruidCoordinator coordinator) {
        this(new ReplicationThrottler(coordinator.getDynamicConfigs().getReplicationThrottleLimit(), coordinator.getDynamicConfigs().getReplicantLifetime()), coordinator);
    }

    public DruidCoordinatorRuleRunner(ReplicationThrottler replicatorThrottler, DruidCoordinator coordinator) {
        this.replicatorThrottler = replicatorThrottler;
        this.coordinator = coordinator;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        this.replicatorThrottler.updateParams(this.coordinator.getDynamicConfigs().getReplicationThrottleLimit(), this.coordinator.getDynamicConfigs().getReplicantLifetime());
        CoordinatorStats stats = new CoordinatorStats();
        DruidCluster cluster = params.getDruidCluster();
        if (cluster.isEmpty()) {
            log.warn("Uh... I have no servers. Not assigning anything...", new Object[0]);
            return params;
        }
        DataSourcesSnapshot dataSourcesSnapshot = params.getDataSourcesSnapshot();
        Object overshadowed = ImmutableSet.of();
        if (dataSourcesSnapshot != null) {
            overshadowed = (Set)Optional.ofNullable(dataSourcesSnapshot.getOvershadowedSegments()).orElse((ImmutableSet<SegmentId>)ImmutableSet.of());
        }
        for (String tier : cluster.getTierNames()) {
            this.replicatorThrottler.updateReplicationState(tier);
        }
        DruidCoordinatorRuntimeParams paramsWithReplicationManager = params.buildFromExistingWithoutAvailableSegments().withReplicationManager(this.replicatorThrottler).build();
        DateTime now = DateTimes.nowUtc();
        MetadataRuleManager databaseRuleManager = paramsWithReplicationManager.getDatabaseRuleManager();
        ArrayList segmentsWithMissingRules = Lists.newArrayListWithCapacity((int)MAX_MISSING_RULES);
        int missingRules = 0;
        for (DataSegment segment : params.getAvailableSegments()) {
            if (overshadowed.contains(segment.getId())) continue;
            List<Rule> rules = databaseRuleManager.getRulesWithDefault(segment.getDataSource());
            boolean foundMatchingRule = false;
            for (Rule rule : rules) {
                if (!rule.appliesTo(segment, now)) continue;
                stats.accumulate(rule.run(this.coordinator, paramsWithReplicationManager, segment));
                foundMatchingRule = true;
                break;
            }
            if (foundMatchingRule) continue;
            if (segmentsWithMissingRules.size() < MAX_MISSING_RULES) {
                segmentsWithMissingRules.add(segment.getId());
            }
            ++missingRules;
        }
        if (!segmentsWithMissingRules.isEmpty()) {
            log.makeAlert("Unable to find matching rules!", new Object[0]).addData("segmentsWithMissingRulesCount", (Object)missingRules).addData("segmentsWithMissingRules", (Object)segmentsWithMissingRules).emit();
        }
        return params.buildFromExisting().withCoordinatorStats(stats).build();
    }
}

