/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.helper;

import com.google.common.collect.Iterables;
import java.util.TreeSet;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.helper.DruidCoordinatorHelper;
import org.apache.druid.timeline.DataSegment;

public class DruidCoordinatorSegmentInfoLoader
implements DruidCoordinatorHelper {
    private static final EmittingLogger log = new EmittingLogger(DruidCoordinatorSegmentInfoLoader.class);
    private final DruidCoordinator coordinator;

    public DruidCoordinatorSegmentInfoLoader(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        log.info("Starting coordination. Getting available segments.", new Object[0]);
        Iterable<DataSegment> dataSegments = this.coordinator.iterateAvailableDataSegments();
        if (dataSegments == null) {
            log.info("Metadata store not polled yet, canceling this run.", new Object[0]);
            return null;
        }
        Iterable availableSegmentsWithSizeChecking = Iterables.transform(dataSegments, segment -> {
            if (segment.getSize() < 0L) {
                log.makeAlert("No size on a segment", new Object[0]).addData("segment", segment).emit();
            }
            return segment;
        });
        TreeSet<DataSegment> availableSegments = DruidCoordinatorRuntimeParams.createAvailableSegmentsSet(availableSegmentsWithSizeChecking);
        if (log.isDebugEnabled()) {
            log.debug("Available DataSegments", new Object[0]);
            for (DataSegment dataSegment : availableSegments) {
                log.debug("  %s", new Object[]{dataSegment});
            }
        }
        log.info("Found [%,d] available segments.", new Object[]{availableSegments.size()});
        return params.buildFromExisting().setAvailableSegments(availableSegments).build();
    }
}

