/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.helper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.helper.CompactionSegmentIterator;
import org.apache.druid.server.coordinator.helper.SegmentCompactorUtil;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;

public class NewestSegmentFirstIterator
implements CompactionSegmentIterator {
    private static final Logger log = new Logger(NewestSegmentFirstIterator.class);
    private final Map<String, DataSourceCompactionConfig> compactionConfigs;
    private final Map<String, VersionedIntervalTimeline<String, DataSegment>> dataSources;
    private final Map<String, CompactibleTimelineObjectHolderCursor> timelineIterators;
    private final PriorityQueue<QueueEntry> queue = new PriorityQueue((o1, o2) -> Comparators.intervalsByStartThenEnd().compare(((QueueEntry)o2).interval, ((QueueEntry)o1).interval));

    NewestSegmentFirstIterator(Map<String, DataSourceCompactionConfig> compactionConfigs, Map<String, VersionedIntervalTimeline<String, DataSegment>> dataSources, Map<String, List<Interval>> skipIntervals) {
        this.compactionConfigs = compactionConfigs;
        this.dataSources = dataSources;
        this.timelineIterators = new HashMap<String, CompactibleTimelineObjectHolderCursor>(dataSources.size());
        for (Map.Entry<String, VersionedIntervalTimeline<String, DataSegment>> entry : dataSources.entrySet()) {
            List<Interval> searchIntervals;
            String dataSource = entry.getKey();
            VersionedIntervalTimeline<String, DataSegment> timeline = entry.getValue();
            DataSourceCompactionConfig config = compactionConfigs.get(dataSource);
            if (config == null || timeline.isEmpty() || (searchIntervals = NewestSegmentFirstIterator.findInitialSearchInterval(timeline, config.getSkipOffsetFromLatest(), skipIntervals.get(dataSource))).isEmpty()) continue;
            this.timelineIterators.put(dataSource, new CompactibleTimelineObjectHolderCursor(timeline, searchIntervals));
        }
        for (Map.Entry<String, Object> entry : compactionConfigs.entrySet()) {
            String dataSourceName = entry.getKey();
            DataSourceCompactionConfig config = (DataSourceCompactionConfig)entry.getValue();
            if (config == null) {
                throw new ISE("Unknown dataSource[%s]", new Object[]{dataSourceName});
            }
            this.updateQueue(dataSourceName, config);
        }
    }

    @Override
    public Object2LongOpenHashMap<String> remainingSegmentSizeBytes() {
        Object2LongOpenHashMap resultMap = new Object2LongOpenHashMap();
        resultMap.defaultReturnValue(-1L);
        for (QueueEntry entry : this.queue) {
            VersionedIntervalTimeline<String, DataSegment> timeline = this.dataSources.get(entry.getDataSource());
            Interval interval = new Interval((ReadableInstant)timeline.first().getInterval().getStart(), (ReadableInstant)entry.interval.getEnd());
            List holders = timeline.lookup(interval);
            resultMap.put((Object)entry.getDataSource(), holders.stream().flatMap(holder -> StreamSupport.stream(holder.getObject().spliterator(), false)).mapToLong(chunk -> ((DataSegment)chunk.getObject()).getSize()).sum());
        }
        return resultMap;
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public List<DataSegment> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        QueueEntry entry = this.queue.poll();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        List resultSegments = entry.segments;
        Preconditions.checkState((!resultSegments.isEmpty() ? 1 : 0) != 0, (Object)"Queue entry must not be empty");
        String dataSource = ((DataSegment)resultSegments.get(0)).getDataSource();
        this.updateQueue(dataSource, this.compactionConfigs.get(dataSource));
        return resultSegments;
    }

    private void updateQueue(String dataSourceName, DataSourceCompactionConfig config) {
        CompactibleTimelineObjectHolderCursor compactibleTimelineObjectHolderCursor = this.timelineIterators.get(dataSourceName);
        if (compactibleTimelineObjectHolderCursor == null) {
            log.warn("Cannot find timeline for dataSource[%s]. Skip this dataSource", new Object[]{dataSourceName});
            return;
        }
        SegmentsToCompact segmentsToCompact = NewestSegmentFirstIterator.findSegmentsToCompact(compactibleTimelineObjectHolderCursor, config);
        if (segmentsToCompact.getNumSegments() > 1) {
            this.queue.add(new QueueEntry(segmentsToCompact.segments));
        }
    }

    private static SegmentsToCompact findSegmentsToCompact(CompactibleTimelineObjectHolderCursor compactibleTimelineObjectHolderCursor, DataSourceCompactionConfig config) {
        boolean keepSegmentGranularity = config.isKeepSegmentGranularity();
        long inputSegmentSize = config.getInputSegmentSizeBytes();
        int maxNumSegmentsToCompact = config.getMaxNumSegmentsToCompact();
        SegmentsToCompact segmentsToCompact = new SegmentsToCompact();
        while (compactibleTimelineObjectHolderCursor.hasNext() && segmentsToCompact.getTotalSize() < inputSegmentSize && segmentsToCompact.getNumSegments() < maxNumSegmentsToCompact) {
            Interval currentInterval;
            TimelineObjectHolder timeChunkHolder = (TimelineObjectHolder)Preconditions.checkNotNull(compactibleTimelineObjectHolderCursor.get(), (Object)"timelineObjectHolder");
            ArrayList chunks = Lists.newArrayList((Iterator)timeChunkHolder.getObject().iterator());
            long timeChunkSizeBytes = chunks.stream().mapToLong(chunk -> ((DataSegment)chunk.getObject()).getSize()).sum();
            Interval lastInterval = segmentsToCompact.getIntervalOfLastSegment();
            boolean isSameOrAbuttingInterval = lastInterval == null ? true : (currentInterval = ((DataSegment)((PartitionChunk)chunks.get(0)).getObject()).getInterval()).isEqual((ReadableInterval)lastInterval) || currentInterval.abuts((ReadableInterval)lastInterval);
            boolean isCompactibleSize = SegmentCompactorUtil.isCompactibleSize(inputSegmentSize, segmentsToCompact.getTotalSize(), timeChunkSizeBytes);
            boolean isCompactibleNum = SegmentCompactorUtil.isCompactibleNum(maxNumSegmentsToCompact, segmentsToCompact.getNumSegments(), chunks.size());
            if (isCompactibleSize && isCompactibleNum && isSameOrAbuttingInterval && (!keepSegmentGranularity || segmentsToCompact.isEmpty())) {
                chunks.forEach(chunk -> segmentsToCompact.add((DataSegment)chunk.getObject()));
            } else {
                DataSegment segment;
                if (segmentsToCompact.getNumSegments() > 1) {
                    return segmentsToCompact;
                }
                if (!SegmentCompactorUtil.isCompactibleSize(inputSegmentSize, 0L, timeChunkSizeBytes)) {
                    segment = (DataSegment)((PartitionChunk)chunks.get(0)).getObject();
                    segmentsToCompact.clear();
                    log.warn("shardSize[%d] for dataSource[%s] and interval[%s] is larger than inputSegmentSize[%d]. Continue to the next shard.", new Object[]{timeChunkSizeBytes, segment.getDataSource(), segment.getInterval(), inputSegmentSize});
                } else if (maxNumSegmentsToCompact < chunks.size()) {
                    segment = (DataSegment)((PartitionChunk)chunks.get(0)).getObject();
                    segmentsToCompact.clear();
                    log.warn("The number of segments[%d] for dataSource[%s] and interval[%s] is larger than maxNumSegmentsToCompact[%d]. If you see lots of shards are being skipped due to too many segments, consider increasing 'numTargetCompactionSegments' and 'druid.indexer.runner.maxZnodeBytes'. Continue to the next shard.", new Object[]{chunks.size(), segment.getDataSource(), segment.getInterval(), maxNumSegmentsToCompact});
                } else if (segmentsToCompact.getNumSegments() == 1) {
                    segmentsToCompact.clear();
                    chunks.forEach(chunk -> segmentsToCompact.add((DataSegment)chunk.getObject()));
                } else {
                    throw new ISE("Cannot compact segments[%s]. shardBytes[%s], numSegments[%s] with current segmentsToCompact[%s]", new Object[]{chunks.stream().map(PartitionChunk::getObject).collect(Collectors.toList()), timeChunkSizeBytes, chunks.size(), segmentsToCompact});
                }
            }
            compactibleTimelineObjectHolderCursor.next();
        }
        if (segmentsToCompact.getNumSegments() == 1) {
            segmentsToCompact.clear();
        }
        return segmentsToCompact;
    }

    private static List<Interval> findInitialSearchInterval(VersionedIntervalTimeline<String, DataSegment> timeline, Period skipOffset, @Nullable List<Interval> skipIntervals) {
        Preconditions.checkArgument((timeline != null && !timeline.isEmpty() ? 1 : 0) != 0, (Object)"timeline should not be null or empty");
        Preconditions.checkNotNull((Object)skipOffset, (Object)"skipOffset");
        TimelineObjectHolder first = (TimelineObjectHolder)Preconditions.checkNotNull((Object)timeline.first(), (Object)"first");
        TimelineObjectHolder last = (TimelineObjectHolder)Preconditions.checkNotNull((Object)timeline.last(), (Object)"last");
        List<Interval> fullSkipIntervals = NewestSegmentFirstIterator.sortAndAddSkipIntervalFromLatest(last.getInterval().getEnd(), skipOffset, skipIntervals);
        Interval totalInterval = new Interval((ReadableInstant)first.getInterval().getStart(), (ReadableInstant)last.getInterval().getEnd());
        List<Interval> filteredInterval = NewestSegmentFirstIterator.filterSkipIntervals(totalInterval, fullSkipIntervals);
        ArrayList<Interval> searchIntervals = new ArrayList<Interval>();
        for (Interval lookupInterval : filteredInterval) {
            List holders = timeline.lookup(new Interval((ReadableInstant)lookupInterval.getStart(), (ReadableInstant)lookupInterval.getEnd()));
            List segments = holders.stream().flatMap(holder -> StreamSupport.stream(holder.getObject().spliterator(), false)).map(PartitionChunk::getObject).filter(segment -> lookupInterval.contains((ReadableInterval)segment.getInterval())).sorted((s1, s2) -> Comparators.intervalsByStartThenEnd().compare(s1.getInterval(), s2.getInterval())).collect(Collectors.toList());
            if (segments.isEmpty()) continue;
            searchIntervals.add(new Interval((ReadableInstant)((DataSegment)segments.get(0)).getInterval().getStart(), (ReadableInstant)((DataSegment)segments.get(segments.size() - 1)).getInterval().getEnd()));
        }
        return searchIntervals;
    }

    @VisibleForTesting
    static List<Interval> sortAndAddSkipIntervalFromLatest(DateTime latest, Period skipOffset, @Nullable List<Interval> skipIntervals) {
        ArrayList<Interval> nonNullSkipIntervals;
        ArrayList<Object> arrayList = nonNullSkipIntervals = skipIntervals == null ? new ArrayList<Interval>(1) : new ArrayList(skipIntervals.size());
        if (skipIntervals != null) {
            ArrayList<Interval> sortedSkipIntervals = new ArrayList<Interval>(skipIntervals);
            sortedSkipIntervals.sort(Comparators.intervalsByStartThenEnd());
            ArrayList<Interval> overlapIntervals = new ArrayList<Interval>();
            Interval skipFromLatest = new Interval((ReadablePeriod)skipOffset, (ReadableInstant)latest);
            for (Interval interval : sortedSkipIntervals) {
                if (interval.overlaps((ReadableInterval)skipFromLatest)) {
                    overlapIntervals.add(interval);
                    continue;
                }
                nonNullSkipIntervals.add(interval);
            }
            if (!overlapIntervals.isEmpty()) {
                overlapIntervals.add(skipFromLatest);
                nonNullSkipIntervals.add(JodaUtils.umbrellaInterval(overlapIntervals));
            } else {
                nonNullSkipIntervals.add(skipFromLatest);
            }
        } else {
            Interval skipFromLatest = new Interval((ReadablePeriod)skipOffset, (ReadableInstant)latest);
            nonNullSkipIntervals.add(skipFromLatest);
        }
        return nonNullSkipIntervals;
    }

    @VisibleForTesting
    static List<Interval> filterSkipIntervals(Interval totalInterval, List<Interval> skipIntervals) {
        ArrayList<Interval> filteredIntervals = new ArrayList<Interval>(skipIntervals.size() + 1);
        DateTime remainingStart = totalInterval.getStart();
        DateTime remainingEnd = totalInterval.getEnd();
        for (Interval skipInterval : skipIntervals) {
            if (skipInterval.getStart().isBefore((ReadableInstant)remainingStart) && skipInterval.getEnd().isAfter((ReadableInstant)remainingStart)) {
                remainingStart = skipInterval.getEnd();
                continue;
            }
            if (skipInterval.getStart().isBefore((ReadableInstant)remainingEnd) && skipInterval.getEnd().isAfter((ReadableInstant)remainingEnd)) {
                remainingEnd = skipInterval.getStart();
                continue;
            }
            if (!remainingStart.isAfter((ReadableInstant)skipInterval.getStart()) && !remainingEnd.isBefore((ReadableInstant)skipInterval.getEnd())) {
                filteredIntervals.add(new Interval((ReadableInstant)remainingStart, (ReadableInstant)skipInterval.getStart()));
                remainingStart = skipInterval.getEnd();
                continue;
            }
            log.warn("skipInterval[%s] is not contained in remainingInterval[%s]", new Object[]{skipInterval, new Interval((ReadableInstant)remainingStart, (ReadableInstant)remainingEnd)});
        }
        if (!remainingStart.equals((Object)remainingEnd)) {
            filteredIntervals.add(new Interval((ReadableInstant)remainingStart, (ReadableInstant)remainingEnd));
        }
        return filteredIntervals;
    }

    private static class SegmentsToCompact {
        private final List<DataSegment> segments = new ArrayList<DataSegment>();
        private long totalSize;

        private SegmentsToCompact() {
        }

        private void add(DataSegment segment) {
            this.segments.add(segment);
            this.totalSize += segment.getSize();
        }

        private boolean isEmpty() {
            Preconditions.checkState((this.totalSize == 0L == this.segments.isEmpty() ? 1 : 0) != 0);
            return this.segments.isEmpty();
        }

        @Nullable
        private Interval getIntervalOfLastSegment() {
            if (this.segments.isEmpty()) {
                return null;
            }
            return this.segments.get(this.segments.size() - 1).getInterval();
        }

        private int getNumSegments() {
            return this.segments.size();
        }

        private long getTotalSize() {
            return this.totalSize;
        }

        private void clear() {
            this.segments.clear();
            this.totalSize = 0L;
        }

        public String toString() {
            return "SegmentsToCompact{segments=" + this.segments + ", totalSize=" + this.totalSize + '}';
        }
    }

    private static class QueueEntry {
        private final Interval interval;
        private final List<DataSegment> segments;

        private QueueEntry(List<DataSegment> segments) {
            Preconditions.checkArgument((segments != null && !segments.isEmpty() ? 1 : 0) != 0);
            Collections.sort(segments);
            this.interval = new Interval((ReadableInstant)segments.get(0).getInterval().getStart(), (ReadableInstant)segments.get(segments.size() - 1).getInterval().getEnd());
            this.segments = segments;
        }

        private String getDataSource() {
            return this.segments.get(0).getDataSource();
        }
    }

    private static class CompactibleTimelineObjectHolderCursor {
        private final List<TimelineObjectHolder<String, DataSegment>> holders;

        CompactibleTimelineObjectHolderCursor(VersionedIntervalTimeline<String, DataSegment> timeline, List<Interval> totalIntervalsToSearch) {
            this.holders = totalIntervalsToSearch.stream().flatMap(interval -> timeline.lookup(interval).stream().filter(holder -> {
                ArrayList chunks = Lists.newArrayList((Iterator)holder.getObject().iterator());
                long partitionBytes = chunks.stream().mapToLong(chunk -> ((DataSegment)chunk.getObject()).getSize()).sum();
                return chunks.size() > 0 && partitionBytes > 0L && interval.contains((ReadableInterval)((DataSegment)((PartitionChunk)chunks.get(0)).getObject()).getInterval());
            })).collect(Collectors.toList());
        }

        boolean hasNext() {
            return !this.holders.isEmpty();
        }

        @Nullable
        TimelineObjectHolder<String, DataSegment> get() {
            if (this.holders.isEmpty()) {
                return null;
            }
            return this.holders.get(this.holders.size() - 1);
        }

        void next() {
            if (!this.holders.isEmpty()) {
                this.holders.remove(this.holders.size() - 1);
            }
        }
    }
}

