/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.rules;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.druid.server.coordinator.rules.DropRule;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class IntervalDropRule
extends DropRule {
    private final Interval interval;

    @JsonCreator
    public IntervalDropRule(@JsonProperty(value="interval") Interval interval) {
        this.interval = interval;
    }

    @Override
    @JsonProperty
    public String getType() {
        return "dropByInterval";
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public boolean appliesTo(DataSegment segment, DateTime referenceTimestamp) {
        return this.appliesTo(segment.getInterval(), referenceTimestamp);
    }

    @Override
    public boolean appliesTo(Interval theInterval, DateTime referenceTimestamp) {
        return this.interval.contains((ReadableInterval)theInterval);
    }
}

