/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeType;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.http.security.StateResourceFilter;

@Path(value="/druid/coordinator/v1/cluster")
@LazySingleton
@ResourceFilters(value={StateResourceFilter.class})
public class ClusterResource {
    private final DruidNodeDiscoveryProvider druidNodeDiscoveryProvider;

    @Inject
    public ClusterResource(DruidNodeDiscoveryProvider discoveryProvider) {
        this.druidNodeDiscoveryProvider = discoveryProvider;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getClusterServers(@QueryParam(value="full") boolean full) {
        Collection<Object> routerNodes;
        ImmutableMap.Builder entityBuilder = new ImmutableMap.Builder();
        entityBuilder.put((Object)NodeType.COORDINATOR, this.getNodes(NodeType.COORDINATOR, full));
        entityBuilder.put((Object)NodeType.OVERLORD, this.getNodes(NodeType.OVERLORD, full));
        entityBuilder.put((Object)NodeType.BROKER, this.getNodes(NodeType.BROKER, full));
        entityBuilder.put((Object)NodeType.HISTORICAL, this.getNodes(NodeType.HISTORICAL, full));
        Collection<Object> mmNodes = this.getNodes(NodeType.MIDDLE_MANAGER, full);
        if (!mmNodes.isEmpty()) {
            entityBuilder.put((Object)NodeType.MIDDLE_MANAGER, mmNodes);
        }
        if (!(routerNodes = this.getNodes(NodeType.ROUTER, full)).isEmpty()) {
            entityBuilder.put((Object)NodeType.ROUTER, routerNodes);
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)entityBuilder.build()).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{nodeType}")
    public Response getClusterServers(@PathParam(value="nodeType") NodeType nodeType, @QueryParam(value="full") boolean full) {
        if (nodeType == null) {
            return Response.serverError().status(Response.Status.BAD_REQUEST).entity((Object)("Invalid nodeType of null. Valid node types are " + Arrays.toString((Object[])NodeType.values()))).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity(this.getNodes(nodeType, full)).build();
    }

    private Collection<Object> getNodes(NodeType nodeType, boolean full) {
        Collection<Object> discoveryDruidNodes = this.druidNodeDiscoveryProvider.getForNodeType(nodeType).getAllNodes();
        if (full) {
            return discoveryDruidNodes;
        }
        return Collections2.transform(discoveryDruidNodes, discoveryDruidNode -> Node.from(discoveryDruidNode.getDruidNode()));
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class Node {
        private final String host;
        private final String service;
        private final Integer plaintextPort;
        private final Integer tlsPort;

        @JsonCreator
        public Node(String host, String service, Integer plaintextPort, Integer tlsPort) {
            this.host = host;
            this.service = service;
            this.plaintextPort = plaintextPort;
            this.tlsPort = tlsPort;
        }

        @JsonProperty
        public String getHost() {
            return this.host;
        }

        @JsonProperty
        public String getService() {
            return this.service;
        }

        @JsonProperty
        public Integer getPlaintextPort() {
            return this.plaintextPort;
        }

        @JsonProperty
        public Integer getTlsPort() {
            return this.tlsPort;
        }

        public static Node from(DruidNode druidNode) {
            return new Node(druidNode.getHost(), druidNode.getServiceName(), druidNode.getPlaintextPort() > 0 ? Integer.valueOf(druidNode.getPlaintextPort()) : null, druidNode.getTlsPort() > 0 ? Integer.valueOf(druidNode.getTlsPort()) : null);
        }
    }
}

