/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.client.CoordinatorServerView;
import org.apache.druid.client.DruidDataSource;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableSegmentLoadInfo;
import org.apache.druid.client.SegmentLoadInfo;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.MapUtils;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.metadata.MetadataSegmentManager;
import org.apache.druid.metadata.UnknownSegmentIdException;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordinator.rules.LoadRule;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.server.http.InventoryViewUtils;
import org.apache.druid.server.http.security.DatasourceResourceFilter;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

@Path(value="/druid/coordinator/v1/datasources")
public class DataSourcesResource {
    private static final Logger log = new Logger(DataSourcesResource.class);
    private final CoordinatorServerView serverInventoryView;
    private final MetadataSegmentManager databaseSegmentManager;
    private final MetadataRuleManager databaseRuleManager;
    private final IndexingServiceClient indexingServiceClient;
    private final AuthConfig authConfig;
    private final AuthorizerMapper authorizerMapper;

    @Inject
    public DataSourcesResource(CoordinatorServerView serverInventoryView, MetadataSegmentManager databaseSegmentManager, MetadataRuleManager databaseRuleManager, @Nullable IndexingServiceClient indexingServiceClient, AuthConfig authConfig, AuthorizerMapper authorizerMapper) {
        this.serverInventoryView = serverInventoryView;
        this.databaseSegmentManager = databaseSegmentManager;
        this.databaseRuleManager = databaseRuleManager;
        this.indexingServiceClient = indexingServiceClient;
        this.authConfig = authConfig;
        this.authorizerMapper = authorizerMapper;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getQueryableDataSources(@QueryParam(value="full") String full, @QueryParam(value="simple") String simple, @Context HttpServletRequest req) {
        Response.ResponseBuilder builder = Response.ok();
        SortedSet<ImmutableDruidDataSource> datasources = InventoryViewUtils.getSecuredDataSources(req, this.serverInventoryView, this.authorizerMapper);
        SequencedCollection<ImmutableDruidDataSource> entity = full != null ? datasources : (simple != null ? datasources.stream().map(this::makeSimpleDatasource).collect(Collectors.toList()) : datasources.stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toList()));
        return builder.entity(entity).build();
    }

    @GET
    @Path(value="/{dataSourceName}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getTheDataSource(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full) {
        ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return Response.noContent().build();
        }
        if (full != null) {
            return Response.ok((Object)dataSource).build();
        }
        return Response.ok(this.getSimpleDatasource(dataSourceName)).build();
    }

    @POST
    @Path(value="/{dataSourceName}")
    @Consumes(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response enableDataSource(@PathParam(value="dataSourceName") String dataSourceName) {
        if (!this.databaseSegmentManager.enableDataSource(dataSourceName)) {
            return Response.noContent().build();
        }
        return Response.ok().build();
    }

    @DELETE
    @Deprecated
    @Path(value="/{dataSourceName}")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    @Produces(value={"application/json"})
    public Response deleteDataSource(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="kill") String kill, @QueryParam(value="interval") String interval) {
        if (this.indexingServiceClient == null) {
            return Response.ok((Object)ImmutableMap.of((Object)"error", (Object)"no indexing service found")).build();
        }
        if (kill != null && Boolean.valueOf(kill).booleanValue()) {
            try {
                this.indexingServiceClient.killSegments(dataSourceName, Intervals.of((String)interval));
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)"Exception occurred. Probably the interval is invalid", (Object)"message", (Object)e.toString())).build();
            }
            catch (Exception e) {
                return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)"Exception occurred. Are you sure you have an indexing service?", (Object)"message", (Object)e.toString())).build();
            }
        } else if (!this.databaseSegmentManager.removeDataSource(dataSourceName)) {
            return Response.noContent().build();
        }
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{dataSourceName}/intervals/{interval}")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    @Produces(value={"application/json"})
    public Response deleteDataSourceSpecificInterval(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="interval") String interval) {
        if (this.indexingServiceClient == null) {
            return Response.ok((Object)ImmutableMap.of((Object)"error", (Object)"no indexing service found")).build();
        }
        Interval theInterval = Intervals.of((String)interval.replace('_', '/'));
        try {
            this.indexingServiceClient.killSegments(dataSourceName, theInterval);
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)"Exception occurred. Are you sure you have an indexing service?", (Object)"message", (Object)e.toString())).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/{dataSourceName}/intervals")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getSegmentDataSourceIntervals(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="simple") String simple, @QueryParam(value="full") String full) {
        if (simple == null && full == null) {
            ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
            if (dataSource == null) {
                return Response.noContent().build();
            }
            Comparator comparator = Comparators.intervalsByStartThenEnd().reversed();
            TreeSet intervals = new TreeSet(comparator);
            dataSource.getSegments().forEach(segment -> intervals.add(segment.getInterval()));
            return Response.ok(intervals).build();
        }
        return this.getSegmentDataSourceIntervals(dataSourceName, full != null, (Interval interval) -> true);
    }

    @GET
    @Path(value="/{dataSourceName}/intervals/{interval}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getSegmentDataSourceSpecificInterval(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="interval") String interval, @QueryParam(value="simple") String simple, @QueryParam(value="full") String full) {
        Interval theInterval = Intervals.of((String)interval.replace('_', '/'));
        if (simple == null && full == null) {
            ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
            if (dataSource == null) {
                return Response.noContent().build();
            }
            TreeSet<SegmentId> segmentIds = new TreeSet<SegmentId>();
            for (DataSegment dataSegment : dataSource.getSegments()) {
                if (!theInterval.contains((ReadableInterval)dataSegment.getInterval())) continue;
                segmentIds.add(dataSegment.getId());
            }
            return Response.ok(segmentIds).build();
        }
        return this.getSegmentDataSourceIntervals(dataSourceName, full != null, arg_0 -> ((Interval)theInterval).contains(arg_0));
    }

    private Response getSegmentDataSourceIntervals(String dataSourceName, boolean full, Predicate<Interval> intervalFilter) {
        ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return Response.noContent().build();
        }
        Comparator comparator = Comparators.intervalsByStartThenEnd().reversed();
        if (full) {
            TreeMap retVal = new TreeMap(comparator);
            for (DataSegment dataSegment : dataSource.getSegments()) {
                if (!intervalFilter.test(dataSegment.getInterval())) continue;
                Map segments = retVal.computeIfAbsent(dataSegment.getInterval(), i -> new HashMap());
                Pair<DataSegment, Set<String>> val = this.getServersWhereSegmentIsServed(dataSegment.getId());
                if (val == null) continue;
                segments.put(dataSegment.getId(), ImmutableMap.of((Object)"metadata", (Object)val.lhs, (Object)"servers", (Object)val.rhs));
            }
            return Response.ok(retVal).build();
        }
        TreeMap statsPerInterval = new TreeMap(comparator);
        for (DataSegment dataSegment : dataSource.getSegments()) {
            if (!intervalFilter.test(dataSegment.getInterval())) continue;
            Map properties = statsPerInterval.computeIfAbsent(dataSegment.getInterval(), i -> new EnumMap(SimpleProperties.class));
            properties.merge(SimpleProperties.size, dataSegment.getSize(), (a, b) -> (Long)a + (Long)b);
            properties.merge(SimpleProperties.count, 1, (a, b) -> (Integer)a + (Integer)b);
        }
        return Response.ok(statsPerInterval).build();
    }

    @GET
    @Path(value="/{dataSourceName}/segments")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getSegmentDataSourceSegments(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full) {
        ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return Response.noContent().build();
        }
        Response.ResponseBuilder builder = Response.ok();
        if (full != null) {
            return builder.entity(dataSource.getSegments()).build();
        }
        return builder.entity((Object)Iterables.transform(dataSource.getSegments(), DataSegment::getId)).build();
    }

    @GET
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getSegmentDataSourceSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return Response.noContent().build();
        }
        for (SegmentId possibleSegmentId : SegmentId.iteratePossibleParsingsWithDataSource((String)dataSourceName, (String)segmentId)) {
            Pair<DataSegment, Set<String>> retVal = this.getServersWhereSegmentIsServed(possibleSegmentId);
            if (retVal == null) continue;
            return Response.ok((Object)ImmutableMap.of((Object)"metadata", (Object)retVal.lhs, (Object)"servers", (Object)retVal.rhs)).build();
        }
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response deleteDatasourceSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        if (this.databaseSegmentManager.removeSegment(segmentId)) {
            return Response.ok().build();
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    @Consumes(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response enableDatasourceSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        if (!this.databaseSegmentManager.enableSegment(segmentId)) {
            return Response.noContent().build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/{dataSourceName}/tiers")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getSegmentDataSourceTiers(@PathParam(value="dataSourceName") String dataSourceName) {
        HashSet<String> retVal = new HashSet<String>();
        for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
            if (druidServer.getDataSource(dataSourceName) == null) continue;
            retVal.add(druidServer.getTier());
        }
        return Response.ok(retVal).build();
    }

    @Nullable
    private ImmutableDruidDataSource getDataSource(String dataSourceName) {
        List dataSources = this.serverInventoryView.getInventory().stream().map(server -> server.getDataSource(dataSourceName)).filter(Objects::nonNull).map(DruidDataSource::toImmutableDruidDataSource).collect(Collectors.toList());
        if (dataSources.isEmpty()) {
            return null;
        }
        TreeMap<SegmentId, DataSegment> segmentMap = new TreeMap<SegmentId, DataSegment>();
        for (ImmutableDruidDataSource dataSource : dataSources) {
            Collection<DataSegment> segments = dataSource.getSegments();
            for (DataSegment segment : segments) {
                segmentMap.put(segment.getId(), segment);
            }
        }
        return new ImmutableDruidDataSource(dataSourceName, Collections.emptyMap(), segmentMap);
    }

    @Nullable
    private Pair<DataSegment, Set<String>> getServersWhereSegmentIsServed(SegmentId segmentId) {
        DataSegment theSegment = null;
        HashSet<String> servers = new HashSet<String>();
        for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
            DataSegment currSegment = druidServer.getSegment(segmentId);
            if (currSegment == null) continue;
            theSegment = currSegment;
            servers.add(druidServer.getHost());
        }
        if (theSegment == null) {
            return null;
        }
        return new Pair(theSegment, servers);
    }

    private Map<String, Object> makeSimpleDatasource(ImmutableDruidDataSource input) {
        return new ImmutableMap.Builder().put((Object)"name", (Object)input.getName()).put((Object)"properties", this.getSimpleDatasource(input.getName())).build();
    }

    private Map<String, Map<String, Object>> getSimpleDatasource(String dataSourceName) {
        HashMap<String, HashMap<String, Integer>> tiers = new HashMap<String, HashMap<String, Integer>>();
        HashMap<String, Number> segments = new HashMap<String, Number>();
        ImmutableMap retVal = ImmutableMap.of((Object)"tiers", tiers, (Object)"segments", segments);
        HashSet<SegmentId> totalDistinctSegments = new HashSet<SegmentId>();
        HashMap tierDistinctSegments = new HashMap();
        long totalSegmentSize = 0L;
        DateTime minTime = DateTimes.MAX;
        DateTime maxTime = DateTimes.MIN;
        for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
            DruidDataSource druidDataSource = druidServer.getDataSource(dataSourceName);
            String tier = druidServer.getTier();
            if (druidDataSource == null) continue;
            if (!tierDistinctSegments.containsKey(tier)) {
                tierDistinctSegments.put(tier, new HashSet());
            }
            long dataSourceSegmentSize = 0L;
            for (DataSegment dataSegment : druidDataSource.getSegments()) {
                if (!((HashSet)tierDistinctSegments.get(tier)).contains(dataSegment.getId())) {
                    dataSourceSegmentSize += dataSegment.getSize();
                    ((HashSet)tierDistinctSegments.get(tier)).add(dataSegment.getId());
                }
                if (!totalDistinctSegments.add(dataSegment.getId())) continue;
                totalSegmentSize += dataSegment.getSize();
                minTime = DateTimes.min((DateTime)minTime, (DateTime)dataSegment.getInterval().getStart());
                maxTime = DateTimes.max((DateTime)maxTime, (DateTime)dataSegment.getInterval().getEnd());
            }
            HashMap<String, Integer> tierStats = (HashMap<String, Integer>)tiers.get(tier);
            if (tierStats == null) {
                tierStats = new HashMap<String, Integer>();
                tiers.put(druidServer.getTier(), tierStats);
            }
            tierStats.put("segmentCount", ((HashSet)tierDistinctSegments.get(tier)).size());
            long segmentSize = MapUtils.getLong(tierStats, (String)"size", (Long)0L);
            tierStats.put("size", (Integer)(segmentSize + dataSourceSegmentSize));
        }
        segments.put("count", totalDistinctSegments.size());
        segments.put("size", totalSegmentSize);
        segments.put("minTime", (Number)minTime);
        segments.put("maxTime", (Number)maxTime);
        return retVal;
    }

    @GET
    @Path(value="/{dataSourceName}/intervals/{interval}/serverview")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getSegmentDataSourceSpecificInterval(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="interval") String interval, @QueryParam(value="partial") boolean partial) {
        VersionedIntervalTimeline<String, SegmentLoadInfo> timeline = this.serverInventoryView.getTimeline((DataSource)new TableDataSource(dataSourceName));
        Interval theInterval = Intervals.of((String)interval.replace('_', '/'));
        if (timeline == null) {
            log.debug("No timeline found for datasource[%s]", new Object[]{dataSourceName});
            return Response.ok(new ArrayList()).build();
        }
        List lookup = timeline.lookupWithIncompletePartitions(theInterval);
        FunctionalIterable retval = FunctionalIterable.create((Iterable)lookup).transformCat(input -> Iterables.transform((Iterable)input.getObject(), chunk -> ((SegmentLoadInfo)chunk.getObject()).toImmutableSegmentLoadInfo()));
        return Response.ok((Object)retval).build();
    }

    @GET
    @Path(value="/{dataSourceName}/handoffComplete")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response isHandOffComplete(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="interval") String interval, @QueryParam(value="partitionNumber") int partitionNumber, @QueryParam(value="version") String version) {
        try {
            List<Rule> rules = this.databaseRuleManager.getRulesWithDefault(dataSourceName);
            Interval theInterval = Intervals.of((String)interval);
            SegmentDescriptor descriptor = new SegmentDescriptor(theInterval, version, partitionNumber);
            DateTime now = DateTimes.nowUtc();
            boolean dropped = true;
            for (Rule rule : rules) {
                if (!rule.appliesTo(theInterval, now)) continue;
                if (!(rule instanceof LoadRule)) break;
                dropped = false;
                break;
            }
            if (dropped) {
                return Response.ok((Object)true).build();
            }
            VersionedIntervalTimeline<String, SegmentLoadInfo> timeline = this.serverInventoryView.getTimeline((DataSource)new TableDataSource(dataSourceName));
            if (timeline == null) {
                log.debug("No timeline found for datasource[%s]", new Object[]{dataSourceName});
                return Response.ok((Object)false).build();
            }
            List lookup = timeline.lookupWithIncompletePartitions(theInterval);
            FunctionalIterable loadInfoIterable = FunctionalIterable.create((Iterable)lookup).transformCat(input -> Iterables.transform((Iterable)input.getObject(), chunk -> ((SegmentLoadInfo)chunk.getObject()).toImmutableSegmentLoadInfo()));
            if (DataSourcesResource.isSegmentLoaded((Iterable<ImmutableSegmentLoadInfo>)loadInfoIterable, descriptor)) {
                return Response.ok((Object)true).build();
            }
            return Response.ok((Object)false).build();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error while handling hand off check request", new Object[0]);
            return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)e.toString())).build();
        }
    }

    @POST
    @Path(value="/{dataSourceName}/markUnused")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response markDatasourceUnused(@PathParam(value="dataSourceName") String dataSourceName, MarkDatasourceSegmentsPayload payload) {
        if (payload == null || !payload.isValid()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid request payload, either interval or segmentIds array must be specified").build();
        }
        ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            log.warn("datasource not found [%s]", new Object[]{dataSourceName});
            return Response.noContent().build();
        }
        long markedSegmentCount = 0L;
        try {
            Interval interval = payload.getInterval();
            Set<String> segmentIds = payload.getSegmentIds();
            if (interval != null) {
                markedSegmentCount = this.databaseSegmentManager.disableSegments(dataSourceName, interval);
            } else if (segmentIds != null) {
                markedSegmentCount = this.databaseSegmentManager.disableSegments(dataSourceName, segmentIds);
            }
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)"Exception occurred.", (Object)"message", (Object)e.toString())).build();
        }
        if (markedSegmentCount == 0L) {
            return Response.noContent().build();
        }
        return Response.ok().build();
    }

    static boolean isSegmentLoaded(Iterable<ImmutableSegmentLoadInfo> serverView, SegmentDescriptor descriptor) {
        for (ImmutableSegmentLoadInfo segmentLoadInfo : serverView) {
            if (!segmentLoadInfo.getSegment().getInterval().contains((ReadableInterval)descriptor.getInterval()) || segmentLoadInfo.getSegment().getShardSpec().getPartitionNum() != descriptor.getPartitionNumber() || segmentLoadInfo.getSegment().getVersion().compareTo(descriptor.getVersion()) < 0 || !Iterables.any(segmentLoadInfo.getServers(), DruidServerMetadata::segmentReplicatable)) continue;
            return true;
        }
        return false;
    }

    @POST
    @Path(value="/{dataSourceName}/markUsed")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response enableDatasourceSegments(@PathParam(value="dataSourceName") String dataSourceName, MarkDatasourceSegmentsPayload payload) {
        int modified;
        if (payload == null || !payload.isValid()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid request payload, either interval or segmentIds array must be specified").build();
        }
        ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return Response.noContent().build();
        }
        try {
            modified = payload.getInterval() != null ? this.databaseSegmentManager.enableSegments(dataSource.getName(), payload.getInterval()) : this.databaseSegmentManager.enableSegments(dataSource.getName(), payload.getSegmentIds());
        }
        catch (Exception e) {
            if (e.getCause() instanceof UnknownSegmentIdException) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"message", (Object)e.getCause().getMessage())).build();
            }
            return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)"Exception occurred.", (Object)"message", (Object)e.getMessage())).build();
        }
        if (modified == 0) {
            return Response.noContent().build();
        }
        return Response.ok().build();
    }

    @VisibleForTesting
    protected static class MarkDatasourceSegmentsPayload {
        private final Interval interval;
        private final Set<String> segmentIds;

        @JsonCreator
        public MarkDatasourceSegmentsPayload(@JsonProperty(value="interval") Interval interval, @JsonProperty(value="segmentIds") Set<String> segmentIds) {
            this.interval = interval;
            this.segmentIds = segmentIds;
        }

        @JsonProperty
        public Interval getInterval() {
            return this.interval;
        }

        @JsonProperty
        public Set<String> getSegmentIds() {
            return this.segmentIds;
        }

        public boolean isValid() {
            return this.interval == null ^ this.segmentIds == null && (this.segmentIds == null || !this.segmentIds.isEmpty());
        }
    }

    static enum SimpleProperties {
        size,
        count;

    }
}

