/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import org.apache.druid.java.util.common.StringUtils;

public class HostAndPortWithScheme {
    private String scheme;
    private HostAndPort hostAndPort;

    public HostAndPortWithScheme(String scheme, HostAndPort hostAndPort) {
        this.scheme = scheme;
        this.hostAndPort = hostAndPort;
    }

    public static HostAndPortWithScheme fromParts(String scheme, String host, int port) {
        return new HostAndPortWithScheme(scheme, HostAndPort.fromParts((String)host, (int)port));
    }

    public static HostAndPortWithScheme fromString(String hostPortMaybeSchemeString) {
        if (hostPortMaybeSchemeString.startsWith("http")) {
            return HostAndPortWithScheme.fromString(hostPortMaybeSchemeString.substring(0, hostPortMaybeSchemeString.indexOf(58)), hostPortMaybeSchemeString.substring(hostPortMaybeSchemeString.indexOf(58) + 1));
        }
        return HostAndPortWithScheme.fromString("http", hostPortMaybeSchemeString);
    }

    public static HostAndPortWithScheme fromString(String scheme, String hostPortString) {
        return new HostAndPortWithScheme(HostAndPortWithScheme.checkAndGetScheme(scheme), HostAndPort.fromString((String)hostPortString));
    }

    private static String checkAndGetScheme(String scheme) {
        String schemeLowerCase = StringUtils.toLowerCase((String)scheme);
        Preconditions.checkState(("http".equals(schemeLowerCase) || "https".equals(schemeLowerCase) ? 1 : 0) != 0);
        return schemeLowerCase;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHostText() {
        return this.hostAndPort.getHostText();
    }

    public int getPort() {
        return this.hostAndPort.getPort();
    }

    public int getPortOrDefault(int defaultPort) {
        return this.hostAndPort.getPortOrDefault(defaultPort);
    }

    public HostAndPort getHostAndPort() {
        return this.hostAndPort;
    }

    public String toString() {
        return StringUtils.format((String)"%s:%s", (Object[])new Object[]{this.scheme, this.hostAndPort.toString()});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostAndPortWithScheme that = (HostAndPortWithScheme)o;
        if (!this.scheme.equals(that.scheme)) {
            return false;
        }
        return this.hostAndPort.equals((Object)that.hostAndPort);
    }

    public int hashCode() {
        int result = this.scheme.hashCode();
        result = 31 * result + this.hostAndPort.hashCode();
        return result;
    }
}

