/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.metadata.MetadataSegmentManager;
import org.apache.druid.server.http.security.DatasourceResourceFilter;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.SegmentWithOvershadowedStatus;
import org.joda.time.Interval;

@Path(value="/druid/coordinator/v1/metadata")
public class MetadataResource {
    private final MetadataSegmentManager metadataSegmentManager;
    private final IndexerMetadataStorageCoordinator metadataStorageCoordinator;
    private final AuthorizerMapper authorizerMapper;

    @Inject
    public MetadataResource(MetadataSegmentManager metadataSegmentManager, IndexerMetadataStorageCoordinator metadataStorageCoordinator, AuthConfig authConfig, AuthorizerMapper authorizerMapper, @Json ObjectMapper jsonMapper) {
        this.metadataSegmentManager = metadataSegmentManager;
        this.metadataStorageCoordinator = metadataStorageCoordinator;
        this.authorizerMapper = authorizerMapper;
    }

    @GET
    @Path(value="/datasources")
    @Produces(value={"application/json"})
    public Response getDatabaseDataSources(@QueryParam(value="full") String full, @QueryParam(value="includeDisabled") String includeDisabled, @Context HttpServletRequest req) {
        Collection druidDataSources = Optional.ofNullable(this.metadataSegmentManager.getDataSources()).orElse(Collections.emptyList());
        TreeSet<String> dataSourceNamesPreAuth = includeDisabled != null ? new TreeSet<String>(this.metadataSegmentManager.getAllDataSourceNames()) : Sets.newTreeSet((Iterable)Iterables.transform((Iterable)druidDataSources, ImmutableDruidDataSource::getName));
        TreeSet dataSourceNamesPostAuth = new TreeSet();
        Function raGenerator = datasourceName -> Collections.singletonList(AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply(datasourceName));
        Iterables.addAll(dataSourceNamesPostAuth, AuthorizationUtils.filterAuthorizedResources(req, dataSourceNamesPreAuth, raGenerator, this.authorizerMapper));
        if (full != null && includeDisabled == null) {
            return Response.ok().entity((Object)Collections2.filter((Collection)druidDataSources, dataSource -> dataSourceNamesPostAuth.contains(dataSource.getName()))).build();
        }
        return Response.ok().entity(dataSourceNamesPostAuth).build();
    }

    @GET
    @Path(value="/datasources/{dataSourceName}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getDatabaseSegmentDataSource(@PathParam(value="dataSourceName") String dataSourceName) {
        ImmutableDruidDataSource dataSource = this.metadataSegmentManager.getDataSource(dataSourceName);
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)dataSource).build();
    }

    @GET
    @Path(value="/segments")
    @Produces(value={"application/json"})
    public Response getDatabaseSegments(@Context HttpServletRequest req, @QueryParam(value="datasources") Set<String> datasources, @QueryParam(value="includeOvershadowedStatus") String includeOvershadowedStatus) {
        Collection druidDataSources = Optional.ofNullable(this.metadataSegmentManager.getDataSources()).orElse(Collections.emptyList());
        Stream<Object> dataSourceStream = druidDataSources.stream();
        if (datasources != null && !datasources.isEmpty()) {
            dataSourceStream = dataSourceStream.filter(src -> datasources.contains(src.getName()));
        }
        Stream<DataSegment> metadataSegments = dataSourceStream.flatMap(t -> t.getSegments().stream());
        if (includeOvershadowedStatus != null) {
            Iterable<SegmentWithOvershadowedStatus> authorizedSegments = this.findAuthorizedSegmentWithOvershadowedStatus(req, metadataSegments);
            Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
            return builder.entity(authorizedSegments).build();
        }
        Function raGenerator = segment -> Collections.singletonList(AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)segment.getDataSource()));
        Iterable authorizedSegments = AuthorizationUtils.filterAuthorizedResources(req, metadataSegments::iterator, raGenerator, this.authorizerMapper);
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        return builder.entity(authorizedSegments).build();
    }

    private Iterable<SegmentWithOvershadowedStatus> findAuthorizedSegmentWithOvershadowedStatus(HttpServletRequest req, Stream<DataSegment> metadataSegments) {
        Set overshadowedSegments = Optional.ofNullable(this.metadataSegmentManager.getOvershadowedSegments()).orElse(Collections.emptySet());
        Stream<SegmentWithOvershadowedStatus> segmentsWithOvershadowedStatus = metadataSegments.map(segment -> new SegmentWithOvershadowedStatus(segment, overshadowedSegments.contains(segment.getId())));
        Function raGenerator = segment -> Collections.singletonList(AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)segment.getDataSegment().getDataSource()));
        Iterable<SegmentWithOvershadowedStatus> authorizedSegments = AuthorizationUtils.filterAuthorizedResources(req, segmentsWithOvershadowedStatus::iterator, raGenerator, this.authorizerMapper);
        return authorizedSegments;
    }

    @GET
    @Path(value="/datasources/{dataSourceName}/segments")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getDatabaseSegmentDataSourceSegments(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full) {
        ImmutableDruidDataSource dataSource = this.metadataSegmentManager.getDataSource(dataSourceName);
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (full != null) {
            return builder.entity(dataSource.getSegments()).build();
        }
        return builder.entity((Object)Collections2.transform(dataSource.getSegments(), DataSegment::getId)).build();
    }

    @POST
    @Path(value="/datasources/{dataSourceName}/segments")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getDatabaseSegmentDataSourceSegments(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full, List<Interval> intervals) {
        List<DataSegment> segments = this.metadataStorageCoordinator.getUsedSegmentsForIntervals(dataSourceName, intervals);
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (full != null) {
            return builder.entity(segments).build();
        }
        return builder.entity((Object)Collections2.transform(segments, DataSegment::getId)).build();
    }

    @GET
    @Path(value="/datasources/{dataSourceName}/segments/{segmentId}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getDatabaseSegmentDataSourceSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        ImmutableDruidDataSource dataSource = this.metadataSegmentManager.getDataSource(dataSourceName);
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        for (SegmentId possibleSegmentId : SegmentId.iteratePossibleParsingsWithDataSource((String)dataSourceName, (String)segmentId)) {
            DataSegment segment = dataSource.getSegment(possibleSegmentId);
            if (segment == null) continue;
            return Response.status((Response.Status)Response.Status.OK).entity((Object)segment).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

