/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.druid.utils.JvmUtils;
import org.joda.time.Period;

public class ServerConfig {
    public static final int DEFAULT_GZIP_INFLATE_BUFFER_SIZE = 4096;
    @JsonProperty
    @Min(value=1L)
    private int numThreads = Math.max(10, JvmUtils.getRuntimeInfo().getAvailableProcessors() * 17 / 16 + 2) + 30;
    @JsonProperty
    @Min(value=1L)
    private int queueSize = Integer.MAX_VALUE;
    @JsonProperty
    private boolean enableRequestLimit = false;
    @JsonProperty
    @NotNull
    private Period maxIdleTime = new Period((Object)"PT5m");
    @JsonProperty
    @Min(value=0L)
    private long defaultQueryTimeout = TimeUnit.MINUTES.toMillis(5L);
    @JsonProperty
    @Min(value=1L)
    private long maxScatterGatherBytes = Long.MAX_VALUE;
    @JsonProperty
    @Min(value=1L)
    private long maxQueryTimeout = Long.MAX_VALUE;
    @JsonProperty
    private int maxRequestHeaderSize = 8192;
    @JsonProperty
    @NotNull
    private Period gracefulShutdownTimeout = Period.ZERO;
    @JsonProperty
    @NotNull
    private Period unannouncePropagationDelay = Period.ZERO;
    @JsonProperty
    @Min(value=0L)
    private int inflateBufferSize = 4096;
    @JsonProperty
    @Min(value=-1L)
    @Max(value=9L)
    private int compressionLevel = -1;

    public int getNumThreads() {
        return this.numThreads;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public boolean isEnableRequestLimit() {
        return this.enableRequestLimit;
    }

    public Period getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public long getDefaultQueryTimeout() {
        return this.defaultQueryTimeout;
    }

    public long getMaxScatterGatherBytes() {
        return this.maxScatterGatherBytes;
    }

    public long getMaxQueryTimeout() {
        return this.maxQueryTimeout;
    }

    public int getMaxRequestHeaderSize() {
        return this.maxRequestHeaderSize;
    }

    public Period getGracefulShutdownTimeout() {
        return this.gracefulShutdownTimeout;
    }

    public Period getUnannouncePropagationDelay() {
        return this.unannouncePropagationDelay;
    }

    public int getInflateBufferSize() {
        return this.inflateBufferSize;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfig that = (ServerConfig)o;
        return this.numThreads == that.numThreads && this.queueSize == that.queueSize && this.enableRequestLimit == that.enableRequestLimit && this.defaultQueryTimeout == that.defaultQueryTimeout && this.maxScatterGatherBytes == that.maxScatterGatherBytes && this.maxQueryTimeout == that.maxQueryTimeout && this.maxRequestHeaderSize == that.maxRequestHeaderSize && this.inflateBufferSize == that.inflateBufferSize && this.compressionLevel == that.compressionLevel && Objects.equals(this.maxIdleTime, that.maxIdleTime) && Objects.equals(this.gracefulShutdownTimeout, that.gracefulShutdownTimeout) && Objects.equals(this.unannouncePropagationDelay, that.unannouncePropagationDelay);
    }

    public int hashCode() {
        return Objects.hash(this.numThreads, this.queueSize, this.enableRequestLimit, this.maxIdleTime, this.defaultQueryTimeout, this.maxScatterGatherBytes, this.maxQueryTimeout, this.maxRequestHeaderSize, this.gracefulShutdownTimeout, this.unannouncePropagationDelay, this.inflateBufferSize, this.compressionLevel);
    }

    public String toString() {
        return "ServerConfig{numThreads=" + this.numThreads + ", queueSize=" + this.queueSize + ", enableRequestLimit=" + this.enableRequestLimit + ", maxIdleTime=" + this.maxIdleTime + ", defaultQueryTimeout=" + this.defaultQueryTimeout + ", maxScatterGatherBytes=" + this.maxScatterGatherBytes + ", maxQueryTimeout=" + this.maxQueryTimeout + ", maxRequestHeaderSize=" + this.maxRequestHeaderSize + ", gracefulShutdownTimeout=" + this.gracefulShutdownTimeout + ", unannouncePropagationDelay=" + this.unannouncePropagationDelay + ", inflateBufferSize=" + this.inflateBufferSize + ", compressionLevel=" + this.compressionLevel + '}';
    }
}

