/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.listener.announcer;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import org.apache.curator.utils.ZKPaths;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.initialization.ZkPathsConfig;

public class ListeningAnnouncerConfig {
    @JacksonInject
    private final ZkPathsConfig zkPathsConfig;
    @JsonProperty(value="listenersPath")
    private String listenersPath = null;

    @Inject
    public ListeningAnnouncerConfig(ZkPathsConfig zkPathsConfig) {
        this.zkPathsConfig = zkPathsConfig;
    }

    @JsonProperty(value="listenersPath")
    public String getListenersPath() {
        return this.listenersPath == null ? this.zkPathsConfig.defaultPath("listeners") : this.listenersPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListeningAnnouncerConfig that = (ListeningAnnouncerConfig)o;
        return !(this.listenersPath == null ? that.listenersPath != null : !this.listenersPath.equals(that.listenersPath));
    }

    public int hashCode() {
        return this.listenersPath != null ? this.listenersPath.hashCode() : 0;
    }

    public String toString() {
        return "ListeningAnnouncerConfig{listenersPath='" + this.getListenersPath() + '\'' + '}';
    }

    public String getAnnouncementPath(String listenerName) {
        return ZKPaths.makePath((String)this.getListenersPath(), (String)((String)Preconditions.checkNotNull((Object)StringUtils.emptyToNullNonDruidDataString((String)listenerName), (Object)"Listener name cannot be null")));
    }
}

