/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.log;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.IOException;
import javax.validation.constraints.NotNull;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.RequestLogLine;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.log.RequestLoggerProvider;

@JsonTypeName(value="filtered")
public class FilteredRequestLoggerProvider
implements RequestLoggerProvider {
    private static final Logger log = new Logger(FilteredRequestLoggerProvider.class);
    @JsonProperty
    @NotNull
    private RequestLoggerProvider delegate = null;
    @JsonProperty
    private long queryTimeThresholdMs = 0L;
    @JsonProperty
    private long sqlQueryTimeThresholdMs = 0L;

    public RequestLogger get() {
        FilteredRequestLogger logger = new FilteredRequestLogger((RequestLogger)this.delegate.get(), this.queryTimeThresholdMs, this.sqlQueryTimeThresholdMs);
        log.debug((Throwable)new Exception("Stack trace"), "Creating %s at", new Object[]{logger});
        return logger;
    }

    public static class FilteredRequestLogger
    implements RequestLogger {
        private final RequestLogger logger;
        private final long queryTimeThresholdMs;
        private final long sqlQueryTimeThresholdMs;

        public FilteredRequestLogger(RequestLogger logger, long queryTimeThresholdMs, long sqlQueryTimeThresholdMs) {
            this.logger = logger;
            this.queryTimeThresholdMs = queryTimeThresholdMs;
            this.sqlQueryTimeThresholdMs = sqlQueryTimeThresholdMs;
        }

        public long getQueryTimeThresholdMs() {
            return this.queryTimeThresholdMs;
        }

        public RequestLogger getDelegate() {
            return this.logger;
        }

        @Override
        @LifecycleStart
        public void start() throws Exception {
            this.logger.start();
        }

        @Override
        @LifecycleStop
        public void stop() {
            this.logger.stop();
        }

        @Override
        public void logNativeQuery(RequestLogLine requestLogLine) throws IOException {
            Object queryTime = requestLogLine.getQueryStats().getStats().get("query/time");
            if (queryTime != null && ((Number)queryTime).longValue() >= this.queryTimeThresholdMs) {
                this.logger.logNativeQuery(requestLogLine);
            }
        }

        @Override
        public void logSqlQuery(RequestLogLine requestLogLine) throws IOException {
            Object sqlQueryTime = requestLogLine.getQueryStats().getStats().get("sqlQuery/time");
            if (sqlQueryTime != null && ((Number)sqlQueryTime).longValue() >= this.sqlQueryTimeThresholdMs) {
                this.logger.logSqlQuery(requestLogLine);
            }
        }

        public String toString() {
            return "FilteredRequestLogger{logger=" + this.logger + ", queryTimeThresholdMs=" + this.queryTimeThresholdMs + ", sqlQueryTimeThresholdMs=" + this.sqlQueryTimeThresholdMs + '}';
        }
    }
}

