/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.server.security.ResourceType;

public class AuthorizationUtils {
    public static Function<String, ResourceAction> DATASOURCE_READ_RA_GENERATOR = new Function<String, ResourceAction>(){

        public ResourceAction apply(String input) {
            return new ResourceAction(new Resource(input, ResourceType.DATASOURCE), Action.READ);
        }
    };
    public static Function<String, ResourceAction> DATASOURCE_WRITE_RA_GENERATOR = new Function<String, ResourceAction>(){

        public ResourceAction apply(String input) {
            return new ResourceAction(new Resource(input, ResourceType.DATASOURCE), Action.WRITE);
        }
    };

    public static Access authorizeResourceAction(HttpServletRequest request, ResourceAction resourceAction, AuthorizerMapper authorizerMapper) {
        return AuthorizationUtils.authorizeAllResourceActions(request, Collections.singletonList(resourceAction), authorizerMapper);
    }

    public static AuthenticationResult authenticationResultFromRequest(HttpServletRequest request) {
        AuthenticationResult authenticationResult = (AuthenticationResult)request.getAttribute("Druid-Authentication-Result");
        if (authenticationResult == null) {
            throw new ISE("Null authentication result", new Object[0]);
        }
        return authenticationResult;
    }

    public static Access authorizeAllResourceActions(AuthenticationResult authenticationResult, Iterable<ResourceAction> resourceActions, AuthorizerMapper authorizerMapper) {
        Authorizer authorizer = authorizerMapper.getAuthorizer(authenticationResult.getAuthorizerName());
        if (authorizer == null) {
            throw new ISE("No authorizer found with name: [%s].", new Object[]{authenticationResult.getAuthorizerName()});
        }
        HashSet<ResourceAction> resultCache = new HashSet<ResourceAction>();
        for (ResourceAction resourceAction : resourceActions) {
            if (resultCache.contains(resourceAction)) continue;
            Access access = authorizer.authorize(authenticationResult, resourceAction.getResource(), resourceAction.getAction());
            if (!access.isAllowed()) {
                return access;
            }
            resultCache.add(resourceAction);
        }
        return Access.OK;
    }

    public static Access authorizeAllResourceActions(HttpServletRequest request, Iterable<ResourceAction> resourceActions, AuthorizerMapper authorizerMapper) {
        if (request.getAttribute("Druid-Allow-Unsecured-Path") != null) {
            return Access.OK;
        }
        if (request.getAttribute("Druid-Authorization-Checked") != null) {
            throw new ISE("Request already had authorization check.", new Object[0]);
        }
        Access access = AuthorizationUtils.authorizeAllResourceActions(AuthorizationUtils.authenticationResultFromRequest(request), resourceActions, authorizerMapper);
        request.setAttribute("Druid-Authorization-Checked", (Object)access.isAllowed());
        return access;
    }

    public static <ResType> Iterable<ResType> filterAuthorizedResources(HttpServletRequest request, Iterable<ResType> resources, Function<? super ResType, Iterable<ResourceAction>> resourceActionGenerator, AuthorizerMapper authorizerMapper) {
        if (request.getAttribute("Druid-Allow-Unsecured-Path") != null) {
            return resources;
        }
        if (request.getAttribute("Druid-Authorization-Checked") != null) {
            throw new ISE("Request already had authorization check.", new Object[0]);
        }
        AuthenticationResult authenticationResult = AuthorizationUtils.authenticationResultFromRequest(request);
        Iterable<? super ResType> filteredResources = AuthorizationUtils.filterAuthorizedResources(authenticationResult, resources, resourceActionGenerator, authorizerMapper);
        request.setAttribute("Druid-Authorization-Checked", (Object)true);
        return filteredResources;
    }

    public static <ResType> Iterable<ResType> filterAuthorizedResources(AuthenticationResult authenticationResult, Iterable<ResType> resources, Function<? super ResType, Iterable<ResourceAction>> resourceActionGenerator, AuthorizerMapper authorizerMapper) {
        Authorizer authorizer = authorizerMapper.getAuthorizer(authenticationResult.getAuthorizerName());
        if (authorizer == null) {
            throw new ISE("No authorizer found with name: [%s].", new Object[]{authenticationResult.getAuthorizerName()});
        }
        HashMap resultCache = new HashMap();
        Iterable filteredResources = Iterables.filter(resources, resource -> {
            Iterable resourceActions = (Iterable)resourceActionGenerator.apply(resource);
            if (resourceActions == null) {
                return false;
            }
            for (ResourceAction resourceAction : resourceActions) {
                Access access = resultCache.computeIfAbsent(resourceAction, ra -> authorizer.authorize(authenticationResult, ra.getResource(), ra.getAction()));
                if (access.isAllowed()) continue;
                return false;
            }
            return true;
        });
        return filteredResources;
    }

    public static <KeyType, ResType> Map<KeyType, List<ResType>> filterAuthorizedResources(HttpServletRequest request, Map<KeyType, List<ResType>> unfilteredResources, Function<? super ResType, Iterable<ResourceAction>> resourceActionGenerator, AuthorizerMapper authorizerMapper) {
        if (request.getAttribute("Druid-Allow-Unsecured-Path") != null) {
            return unfilteredResources;
        }
        if (request.getAttribute("Druid-Authorization-Checked") != null) {
            throw new ISE("Request already had authorization check.", new Object[0]);
        }
        AuthenticationResult authenticationResult = AuthorizationUtils.authenticationResultFromRequest(request);
        HashMap<KeyType, ArrayList> filteredResources = new HashMap<KeyType, ArrayList>();
        for (Map.Entry<KeyType, List<ResType>> entry : unfilteredResources.entrySet()) {
            ArrayList filteredList;
            if (entry.getValue() == null || (filteredList = Lists.newArrayList(AuthorizationUtils.filterAuthorizedResources(authenticationResult, (Iterable)entry.getValue(), resourceActionGenerator, authorizerMapper))).size() <= 0) continue;
            filteredResources.put(entry.getKey(), filteredList);
        }
        request.setAttribute("Druid-Authorization-Checked", (Object)true);
        return filteredResources;
    }
}

