/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.security.TLSCertificateChecker;

public class CustomCheckX509TrustManager
extends X509ExtendedTrustManager
implements X509TrustManager {
    private static final Logger log = new Logger(CustomCheckX509TrustManager.class);
    private final X509ExtendedTrustManager delegate;
    private final boolean validateServerHostnames;
    private final TLSCertificateChecker certificateChecker;

    public CustomCheckX509TrustManager(X509ExtendedTrustManager delegate, TLSCertificateChecker certificateChecker, boolean validateServerHostnames) {
        this.delegate = delegate;
        this.validateServerHostnames = validateServerHostnames;
        this.certificateChecker = certificateChecker;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType, socket);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.certificateChecker.checkClient(chain, authType, engine, this.delegate);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        if (!this.validateServerHostnames) {
            SSLParameters params = engine.getSSLParameters();
            params.setEndpointIdentificationAlgorithm(null);
            engine.setSSLParameters(params);
        }
        this.certificateChecker.checkServer(chain, authType, engine, this.delegate);
    }
}

