/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.sql.SqlLifecycleFactory;
import org.apache.druid.sql.avatica.DruidStatement;

public class DruidConnection {
    private static final Logger log = new Logger(DruidConnection.class);
    private static final Set<String> SENSITIVE_CONTEXT_FIELDS = Sets.newHashSet((Object[])new String[]{"user", "password"});
    private final String connectionId;
    private final int maxStatements;
    private final ImmutableMap<String, Object> context;
    private final AtomicInteger statementCounter = new AtomicInteger();
    private final AtomicReference<Future<?>> timeoutFuture = new AtomicReference();
    @GuardedBy(value="connectionLock")
    private final ConcurrentMap<Integer, DruidStatement> statements;
    private final Object connectionLock = new Object();
    @GuardedBy(value="connectionLock")
    private boolean open = true;

    public DruidConnection(String connectionId, int maxStatements, Map<String, Object> context) {
        this.connectionId = (String)Preconditions.checkNotNull((Object)connectionId);
        this.maxStatements = maxStatements;
        this.context = ImmutableMap.copyOf(context);
        this.statements = new ConcurrentHashMap<Integer, DruidStatement>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DruidStatement createStatement(SqlLifecycleFactory sqlLifecycleFactory) {
        int statementId = this.statementCounter.incrementAndGet();
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.statements.containsKey(statementId)) {
                throw new ISE("Uh oh, too many statements", new Object[0]);
            }
            if (this.statements.size() >= this.maxStatements) {
                throw new ISE("Too many open statements, limit is[%,d]", new Object[]{this.maxStatements});
            }
            Map sanitizedContext = Maps.filterEntries(this.context, e -> !SENSITIVE_CONTEXT_FIELDS.contains(e.getKey()));
            DruidStatement statement = new DruidStatement(this.connectionId, statementId, (Map<String, Object>)ImmutableSortedMap.copyOf((Map)sanitizedContext), sqlLifecycleFactory.factorize(), () -> {
                log.debug("Connection[%s] closed statement[%s].", new Object[]{this.connectionId, statementId});
                this.statements.remove(statementId);
            });
            this.statements.put(statementId, statement);
            log.debug("Connection[%s] opened statement[%s].", new Object[]{this.connectionId, statementId});
            return statement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DruidStatement getStatement(int statementId) {
        Object object = this.connectionLock;
        synchronized (object) {
            return (DruidStatement)this.statements.get(statementId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeIfEmpty() {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.statements.isEmpty()) {
                this.close();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.connectionLock;
        synchronized (object) {
            for (DruidStatement statement : ImmutableList.copyOf(this.statements.values())) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    log.warn("Connection[%s] failed to close statement[%s]!", new Object[]{this.connectionId, statement.getStatementId()});
                }
            }
            log.debug("Connection[%s] closed.", new Object[]{this.connectionId});
            this.open = false;
        }
    }

    public DruidConnection sync(Future<?> newTimeoutFuture) {
        Future<?> oldFuture = this.timeoutFuture.getAndSet(newTimeoutFuture);
        if (oldFuture != null) {
            oldFuture.cancel(false);
        }
        return this;
    }

    public Map<String, Object> context() {
        return this.context;
    }
}

