/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexNode;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;

public class Aggregations {
    private Aggregations() {
    }

    @Nullable
    public static List<DruidExpression> getArgumentsForSimpleAggregator(PlannerContext plannerContext, RowSignature rowSignature, AggregateCall call, Project project) {
        return call.getArgList().stream().map(i -> Expressions.fromFieldAccess(rowSignature, project, i)).map(rexNode -> Aggregations.toDruidExpressionForSimpleAggregator(plannerContext, rowSignature, rexNode)).collect(Collectors.toList());
    }

    private static DruidExpression toDruidExpressionForSimpleAggregator(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        DruidExpression druidExpression = Expressions.toDruidExpression(plannerContext, rowSignature, rexNode);
        if (druidExpression == null) {
            return null;
        }
        if (druidExpression.isSimpleExtraction() && (!druidExpression.isDirectColumnAccess() || rowSignature.getColumnType(druidExpression.getDirectColumn()) == ValueType.STRING)) {
            return druidExpression.map(simpleExtraction -> null, Function.identity());
        }
        return druidExpression;
    }
}

