/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.planner.Calcites;

public class DimensionExpression {
    private final String outputName;
    private final DruidExpression expression;
    private final ValueType outputType;

    public DimensionExpression(String outputName, DruidExpression expression, ValueType outputType) {
        this.outputName = outputName;
        this.expression = expression;
        this.outputType = outputType;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public DruidExpression getDruidExpression() {
        return this.expression;
    }

    public DimensionSpec toDimensionSpec() {
        if (this.expression.isSimpleExtraction()) {
            return this.expression.getSimpleExtraction().toDimensionSpec(this.outputName, this.outputType);
        }
        return new DefaultDimensionSpec(this.getVirtualColumnName(), this.getOutputName(), this.outputType);
    }

    public List<VirtualColumn> getVirtualColumns(ExprMacroTable macroTable) {
        if (this.expression.isSimpleExtraction()) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)this.expression.toVirtualColumn(this.getVirtualColumnName(), this.outputType, macroTable));
    }

    @Nullable
    public String getVirtualColumnName() {
        return this.expression.isSimpleExtraction() ? null : Calcites.makePrefixedName(this.outputName, "v");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionExpression that = (DimensionExpression)o;
        return Objects.equals(this.outputName, that.outputName) && Objects.equals(this.expression, that.expression) && this.outputType == that.outputType;
    }

    public int hashCode() {
        return Objects.hash(this.outputName, this.expression, this.outputType);
    }

    public String toString() {
        return "DimensionExpression{outputName='" + this.outputName + '\'' + ", expression=" + this.expression + ", outputType=" + this.outputType + '}';
    }
}

