/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;

public class DirectOperatorConversion
implements SqlOperatorConversion {
    private final SqlOperator operator;
    private final String druidFunctionName;

    public DirectOperatorConversion(SqlOperator operator, String druidFunctionName) {
        this.operator = operator;
        this.druidFunctionName = druidFunctionName;
    }

    @Override
    public SqlOperator calciteOperator() {
        return this.operator;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, operands -> DruidExpression.fromExpression(DruidExpression.functionCall(this.druidFunctionName, operands)));
    }
}

