/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.expression.TimestampFloorExprMacro;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.TimeFormatExtractionFn;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.ExpressionDimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.ExtractionFns;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.filtration.BoundRefKey;
import org.apache.druid.sql.calcite.filtration.Bounds;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;
import org.joda.time.Interval;

public class Expressions {
    private Expressions() {
    }

    public static RexNode fromFieldAccess(RowSignature rowSignature, Project project, int fieldNumber) {
        if (project == null) {
            return RexInputRef.of((int)fieldNumber, (RelDataType)rowSignature.getRelDataType((RelDataTypeFactory)new JavaTypeFactoryImpl()));
        }
        return (RexNode)project.getChildExps().get(fieldNumber);
    }

    @Nullable
    public static List<DruidExpression> toDruidExpressions(PlannerContext plannerContext, RowSignature rowSignature, List<RexNode> rexNodes) {
        ArrayList<DruidExpression> retVal = new ArrayList<DruidExpression>(rexNodes.size());
        for (RexNode rexNode : rexNodes) {
            DruidExpression druidExpression = Expressions.toDruidExpression(plannerContext, rowSignature, rexNode);
            if (druidExpression == null) {
                return null;
            }
            retVal.add(druidExpression);
        }
        return retVal;
    }

    @Nullable
    public static DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        SqlKind kind = rexNode.getKind();
        SqlTypeName sqlTypeName = rexNode.getType().getSqlTypeName();
        if (kind == SqlKind.INPUT_REF) {
            RexInputRef ref = (RexInputRef)rexNode;
            String columnName = rowSignature.getRowOrder().get(ref.getIndex());
            if (columnName == null) {
                throw new ISE("WTF?! Expression referred to nonexistent index[%d]", new Object[]{ref.getIndex()});
            }
            return DruidExpression.fromColumn(columnName);
        }
        if (rexNode instanceof RexCall) {
            SqlOperator operator = ((RexCall)rexNode).getOperator();
            SqlOperatorConversion conversion = plannerContext.getOperatorTable().lookupOperatorConversion(operator);
            if (conversion == null) {
                return null;
            }
            return conversion.toDruidExpression(plannerContext, rowSignature, rexNode);
        }
        if (kind == SqlKind.LITERAL) {
            if (RexLiteral.isNullLiteral((RexNode)rexNode)) {
                return DruidExpression.fromExpression(DruidExpression.nullLiteral());
            }
            if (SqlTypeName.NUMERIC_TYPES.contains(sqlTypeName)) {
                return DruidExpression.fromExpression(DruidExpression.numberLiteral((Number)((Object)RexLiteral.value((RexNode)rexNode))));
            }
            if (SqlTypeFamily.INTERVAL_DAY_TIME == sqlTypeName.getFamily()) {
                long milliseconds = ((Number)((Object)RexLiteral.value((RexNode)rexNode))).longValue();
                return DruidExpression.fromExpression(DruidExpression.numberLiteral(milliseconds));
            }
            if (SqlTypeFamily.INTERVAL_YEAR_MONTH == sqlTypeName.getFamily()) {
                long months = ((Number)((Object)RexLiteral.value((RexNode)rexNode))).longValue();
                return DruidExpression.fromExpression(DruidExpression.numberLiteral(months));
            }
            if (SqlTypeName.STRING_TYPES.contains(sqlTypeName)) {
                return DruidExpression.fromExpression(DruidExpression.stringLiteral(RexLiteral.stringValue((RexNode)rexNode)));
            }
            if (SqlTypeName.TIMESTAMP == sqlTypeName || SqlTypeName.DATE == sqlTypeName) {
                if (RexLiteral.isNullLiteral((RexNode)rexNode)) {
                    return DruidExpression.fromExpression(DruidExpression.nullLiteral());
                }
                return DruidExpression.fromExpression(DruidExpression.numberLiteral(Calcites.calciteDateTimeLiteralToJoda(rexNode, plannerContext.getTimeZone()).getMillis()));
            }
            if (SqlTypeName.BOOLEAN == sqlTypeName) {
                return DruidExpression.fromExpression(DruidExpression.numberLiteral(RexLiteral.booleanValue((RexNode)rexNode) ? 1 : 0));
            }
            return null;
        }
        return null;
    }

    @Nullable
    public static DimFilter toFilter(PlannerContext plannerContext, RowSignature rowSignature, RexNode expression) {
        SqlKind kind = expression.getKind();
        if (kind == SqlKind.IS_TRUE || kind == SqlKind.IS_NOT_FALSE) {
            return Expressions.toFilter(plannerContext, rowSignature, (RexNode)Iterables.getOnlyElement((Iterable)((RexCall)expression).getOperands()));
        }
        if (kind == SqlKind.IS_FALSE || kind == SqlKind.IS_NOT_TRUE) {
            return new NotDimFilter(Expressions.toFilter(plannerContext, rowSignature, (RexNode)Iterables.getOnlyElement((Iterable)((RexCall)expression).getOperands())));
        }
        if (kind == SqlKind.CAST && expression.getType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
            return Expressions.toFilter(plannerContext, rowSignature, (RexNode)Iterables.getOnlyElement((Iterable)((RexCall)expression).getOperands()));
        }
        if (kind == SqlKind.AND || kind == SqlKind.OR || kind == SqlKind.NOT) {
            ArrayList<DimFilter> filters = new ArrayList<DimFilter>();
            for (RexNode rexNode : ((RexCall)expression).getOperands()) {
                DimFilter nextFilter = Expressions.toFilter(plannerContext, rowSignature, rexNode);
                if (nextFilter == null) {
                    return null;
                }
                filters.add(nextFilter);
            }
            if (kind == SqlKind.AND) {
                return new AndDimFilter(filters);
            }
            if (kind == SqlKind.OR) {
                return new OrDimFilter(filters);
            }
            assert (kind == SqlKind.NOT);
            return new NotDimFilter((DimFilter)Iterables.getOnlyElement(filters));
        }
        return Expressions.toLeafFilter(plannerContext, rowSignature, expression);
    }

    @Nullable
    private static DimFilter toLeafFilter(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        if (rexNode.isAlwaysTrue()) {
            return Filtration.matchEverything();
        }
        if (rexNode.isAlwaysFalse()) {
            return Filtration.matchNothing();
        }
        DimFilter simpleFilter = Expressions.toSimpleLeafFilter(plannerContext, rowSignature, rexNode);
        return simpleFilter != null ? simpleFilter : Expressions.toExpressionLeafFilter(plannerContext, rowSignature, rexNode);
    }

    @Nullable
    private static DimFilter toSimpleLeafFilter(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        block35: {
            BoundDimFilter filter;
            String val;
            Granularity granularity;
            SqlKind flippedKind;
            RexNode rhs;
            RexNode lhs;
            block37: {
                SqlKind kind;
                block36: {
                    kind = rexNode.getKind();
                    if (kind == SqlKind.IS_TRUE || kind == SqlKind.IS_NOT_FALSE) {
                        return Expressions.toSimpleLeafFilter(plannerContext, rowSignature, (RexNode)Iterables.getOnlyElement((Iterable)((RexCall)rexNode).getOperands()));
                    }
                    if (kind == SqlKind.IS_FALSE || kind == SqlKind.IS_NOT_TRUE) {
                        return new NotDimFilter(Expressions.toSimpleLeafFilter(plannerContext, rowSignature, (RexNode)Iterables.getOnlyElement((Iterable)((RexCall)rexNode).getOperands())));
                    }
                    if (kind == SqlKind.IS_NULL || kind == SqlKind.IS_NOT_NULL) {
                        RexNode operand = (RexNode)Iterables.getOnlyElement((Iterable)((RexCall)rexNode).getOperands());
                        DruidExpression druidExpression = Expressions.toDruidExpression(plannerContext, rowSignature, operand);
                        if (druidExpression == null || !druidExpression.isSimpleExtraction()) {
                            return null;
                        }
                        SelectorDimFilter equalFilter = new SelectorDimFilter(druidExpression.getSimpleExtraction().getColumn(), NullHandling.defaultStringValue(), druidExpression.getSimpleExtraction().getExtractionFn());
                        return kind == SqlKind.IS_NOT_NULL ? new NotDimFilter((DimFilter)equalFilter) : equalFilter;
                    }
                    if (kind != SqlKind.EQUALS && kind != SqlKind.NOT_EQUALS && kind != SqlKind.GREATER_THAN && kind != SqlKind.GREATER_THAN_OR_EQUAL && kind != SqlKind.LESS_THAN && kind != SqlKind.LESS_THAN_OR_EQUAL) break block35;
                    List operands = ((RexCall)rexNode).getOperands();
                    Preconditions.checkState((operands.size() == 2 ? 1 : 0) != 0, (String)"WTF?! Expected 2 operands, got[%,d]", (Object[])new Object[]{operands.size()});
                    boolean flip = false;
                    lhs = (RexNode)operands.get(0);
                    rhs = (RexNode)operands.get(1);
                    if (lhs.getKind() == SqlKind.LITERAL && rhs.getKind() != SqlKind.LITERAL) {
                        RexNode x = lhs;
                        lhs = rhs;
                        rhs = x;
                        flip = true;
                    }
                    if (!flip) break block36;
                    switch (kind) {
                        case EQUALS: 
                        case NOT_EQUALS: {
                            flippedKind = kind;
                            break block37;
                        }
                        case GREATER_THAN: {
                            flippedKind = SqlKind.LESS_THAN;
                            break block37;
                        }
                        case GREATER_THAN_OR_EQUAL: {
                            flippedKind = SqlKind.LESS_THAN_OR_EQUAL;
                            break block37;
                        }
                        case LESS_THAN: {
                            flippedKind = SqlKind.GREATER_THAN;
                            break block37;
                        }
                        case LESS_THAN_OR_EQUAL: {
                            flippedKind = SqlKind.GREATER_THAN_OR_EQUAL;
                            break block37;
                        }
                        default: {
                            throw new ISE("WTF?! Kind[%s] not expected here", new Object[]{kind});
                        }
                    }
                }
                flippedKind = kind;
            }
            if (rhs.getKind() != SqlKind.LITERAL) {
                return null;
            }
            DruidExpression lhsExpression = Expressions.toDruidExpression(plannerContext, rowSignature, lhs);
            if (lhsExpression == null) {
                return null;
            }
            Granularity queryGranularity = Expressions.toQueryGranularity(lhsExpression, plannerContext.getExprMacroTable());
            if (queryGranularity != null) {
                long rhsMillis = Calcites.calciteDateTimeLiteralToJoda(rhs, plannerContext.getTimeZone()).getMillis();
                return Expressions.buildTimeFloorFilter("__time", queryGranularity, flippedKind, rhsMillis);
            }
            if (!lhsExpression.isSimpleExtraction()) {
                return null;
            }
            String column = lhsExpression.getSimpleExtraction().getColumn();
            ExtractionFn extractionFn = lhsExpression.getSimpleExtraction().getExtractionFn();
            if (column.equals("__time") && extractionFn instanceof TimeFormatExtractionFn && (granularity = ExtractionFns.toQueryGranularity(extractionFn)) != null) {
                long rhsMillis = Calcites.calciteDateTimeLiteralToJoda(rhs, plannerContext.getTimeZone()).getMillis();
                Interval rhsInterval = granularity.bucket(DateTimes.utc((long)rhsMillis));
                boolean rhsAligned = rhsInterval.getStartMillis() == rhsMillis;
                BoundRefKey boundRefKey = new BoundRefKey(column, null, StringComparators.NUMERIC);
                return Expressions.getBoundTimeDimFilter(flippedKind, boundRefKey, rhsInterval, rhsAligned);
            }
            RexLiteral rhsLiteral = (RexLiteral)rhs;
            if (SqlTypeName.NUMERIC_TYPES.contains(rhsLiteral.getTypeName())) {
                val = String.valueOf(RexLiteral.value((RexNode)rhsLiteral));
            } else if (SqlTypeName.CHAR_TYPES.contains(rhsLiteral.getTypeName())) {
                val = String.valueOf(RexLiteral.stringValue((RexNode)rhsLiteral));
            } else if (SqlTypeName.TIMESTAMP == rhsLiteral.getTypeName() || SqlTypeName.DATE == rhsLiteral.getTypeName()) {
                val = String.valueOf(Calcites.calciteDateTimeLiteralToJoda((RexNode)rhsLiteral, plannerContext.getTimeZone()).getMillis());
            } else {
                return null;
            }
            StringComparator comparator = Calcites.getStringComparatorForSqlTypeName(lhs.getType().getSqlTypeName());
            BoundRefKey boundRefKey = new BoundRefKey(column, extractionFn, comparator);
            switch (flippedKind) {
                case EQUALS: {
                    filter = Bounds.equalTo(boundRefKey, val);
                    break;
                }
                case NOT_EQUALS: {
                    filter = new NotDimFilter((DimFilter)Bounds.equalTo(boundRefKey, val));
                    break;
                }
                case GREATER_THAN: {
                    filter = Bounds.greaterThan(boundRefKey, val);
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    filter = Bounds.greaterThanOrEqualTo(boundRefKey, val);
                    break;
                }
                case LESS_THAN: {
                    filter = Bounds.lessThan(boundRefKey, val);
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    filter = Bounds.lessThanOrEqualTo(boundRefKey, val);
                    break;
                }
                default: {
                    throw new IllegalStateException("WTF?! Shouldn't have got here...");
                }
            }
            return filter;
        }
        if (rexNode instanceof RexCall) {
            SqlOperator operator = ((RexCall)rexNode).getOperator();
            SqlOperatorConversion conversion = plannerContext.getOperatorTable().lookupOperatorConversion(operator);
            if (conversion == null) {
                return null;
            }
            DimFilter filter = conversion.toDruidFilter(plannerContext, rowSignature, rexNode);
            if (filter != null) {
                return filter;
            }
            DruidExpression expression = conversion.toDruidExpression(plannerContext, rowSignature, rexNode);
            if (expression != null) {
                return new ExpressionDimFilter(expression.getExpression(), plannerContext.getExprMacroTable());
            }
        }
        return null;
    }

    public static ExprType exprTypeForValueType(ValueType valueType) {
        switch (valueType) {
            case LONG: {
                return ExprType.LONG;
            }
            case FLOAT: 
            case DOUBLE: {
                return ExprType.DOUBLE;
            }
            case STRING: {
                return ExprType.STRING;
            }
        }
        throw new ISE("No ExprType for valueType[%s]", new Object[]{valueType});
    }

    @Nullable
    private static DimFilter toExpressionLeafFilter(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        DruidExpression druidExpression = Expressions.toDruidExpression(plannerContext, rowSignature, rexNode);
        return druidExpression == null ? null : new ExpressionDimFilter(druidExpression.getExpression(), plannerContext.getExprMacroTable());
    }

    @Nullable
    public static Granularity toQueryGranularity(DruidExpression expression, ExprMacroTable macroTable) {
        TimestampFloorExprMacro.TimestampFloorExpr expr = Expressions.asTimestampFloorExpr(expression, macroTable);
        if (expr == null) {
            return null;
        }
        Expr arg = expr.getArg();
        PeriodGranularity granularity = expr.getGranularity();
        if ("__time".equals(Parser.getIdentifierIfIdentifier((Expr)arg))) {
            return granularity;
        }
        return null;
    }

    @Nullable
    public static TimestampFloorExprMacro.TimestampFloorExpr asTimestampFloorExpr(DruidExpression expression, ExprMacroTable macroTable) {
        Expr expr = Parser.parse((String)expression.getExpression(), (ExprMacroTable)macroTable);
        if (expr instanceof TimestampFloorExprMacro.TimestampFloorExpr) {
            return (TimestampFloorExprMacro.TimestampFloorExpr)expr;
        }
        return null;
    }

    private static DimFilter buildTimeFloorFilter(String column, Granularity granularity, SqlKind operatorKind, long rhsMillis) {
        BoundRefKey boundRefKey = new BoundRefKey(column, null, StringComparators.NUMERIC);
        Interval rhsInterval = granularity.bucket(DateTimes.utc((long)rhsMillis));
        boolean rhsAligned = rhsInterval.getStartMillis() == rhsMillis;
        return Expressions.getBoundTimeDimFilter(operatorKind, boundRefKey, rhsInterval, rhsAligned);
    }

    private static DimFilter getBoundTimeDimFilter(SqlKind operatorKind, BoundRefKey boundRefKey, Interval interval, boolean isAligned) {
        switch (operatorKind) {
            case EQUALS: {
                return isAligned ? Bounds.interval(boundRefKey, interval) : Filtration.matchNothing();
            }
            case NOT_EQUALS: {
                return isAligned ? new NotDimFilter((DimFilter)Bounds.interval(boundRefKey, interval)) : Filtration.matchEverything();
            }
            case GREATER_THAN: {
                return Bounds.greaterThanOrEqualTo(boundRefKey, String.valueOf(interval.getEndMillis()));
            }
            case GREATER_THAN_OR_EQUAL: {
                return isAligned ? Bounds.greaterThanOrEqualTo(boundRefKey, String.valueOf(interval.getStartMillis())) : Bounds.greaterThanOrEqualTo(boundRefKey, String.valueOf(interval.getEndMillis()));
            }
            case LESS_THAN: {
                return isAligned ? Bounds.lessThan(boundRefKey, String.valueOf(interval.getStartMillis())) : Bounds.lessThan(boundRefKey, String.valueOf(interval.getEndMillis()));
            }
            case LESS_THAN_OR_EQUAL: {
                return Bounds.lessThan(boundRefKey, String.valueOf(interval.getEndMillis()));
            }
        }
        throw new IllegalStateException("WTF?! Shouldn't have got here...");
    }
}

