/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import com.google.common.collect.Iterables;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;

public class UnaryFunctionOperatorConversion
implements SqlOperatorConversion {
    private final SqlOperator operator;
    private final String druidOperator;

    public UnaryFunctionOperatorConversion(SqlOperator operator, String druidOperator) {
        this.operator = operator;
        this.druidOperator = druidOperator;
    }

    @Override
    public SqlOperator calciteOperator() {
        return this.operator;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, operands -> DruidExpression.fromExpression(StringUtils.format((String)"%s(%s)", (Object[])new Object[]{this.druidOperator, ((DruidExpression)Iterables.getOnlyElement((Iterable)operands)).getExpression()})));
    }
}

