/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.expression.TimeUnits;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;

public class CeilOperatorConversion
implements SqlOperatorConversion {
    @Override
    public SqlOperator calciteOperator() {
        return SqlStdOperatorTable.CEIL;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        RexCall call = (RexCall)rexNode;
        RexNode arg = (RexNode)call.getOperands().get(0);
        DruidExpression druidExpression = Expressions.toDruidExpression(plannerContext, rowSignature, arg);
        if (druidExpression == null) {
            return null;
        }
        if (call.getOperands().size() == 1) {
            return druidExpression.map(simpleExtraction -> null, expression -> StringUtils.format((String)"ceil(%s)", (Object[])new Object[]{expression}));
        }
        if (call.getOperands().size() == 2) {
            RexLiteral flag = (RexLiteral)call.getOperands().get(1);
            TimeUnitRange timeUnit = (TimeUnitRange)flag.getValue();
            PeriodGranularity granularity = TimeUnits.toQueryGranularity(timeUnit, plannerContext.getTimeZone());
            if (granularity == null) {
                return null;
            }
            return DruidExpression.fromFunctionCall("timestamp_ceil", Stream.of(druidExpression.getExpression(), DruidExpression.stringLiteral(granularity.getPeriod().toString()), DruidExpression.numberLiteral(granularity.getOrigin() == null ? null : Long.valueOf(granularity.getOrigin().getMillis())), DruidExpression.stringLiteral(granularity.getTimeZone().toString())).map(DruidExpression::fromExpression).collect(Collectors.toList()));
        }
        return null;
    }
}

