/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.LikeDimFilter;
import org.apache.druid.sql.calcite.expression.DirectOperatorConversion;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;

public class LikeOperatorConversion
extends DirectOperatorConversion {
    private static final SqlOperator SQL_FUNCTION = SqlStdOperatorTable.LIKE;

    public LikeOperatorConversion() {
        super(SQL_FUNCTION, "like");
    }

    @Override
    public SqlOperator calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    @Nullable
    public DimFilter toDruidFilter(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        List operands = ((RexCall)rexNode).getOperands();
        DruidExpression druidExpression = Expressions.toDruidExpression(plannerContext, rowSignature, (RexNode)operands.get(0));
        if (druidExpression == null || !druidExpression.isSimpleExtraction()) {
            return null;
        }
        return new LikeDimFilter(druidExpression.getSimpleExtraction().getColumn(), RexLiteral.stringValue((RexNode)((RexNode)operands.get(1))), operands.size() > 2 ? RexLiteral.stringValue((RexNode)((RexNode)operands.get(2))) : null, druidExpression.getSimpleExtraction().getExtractionFn());
    }
}

