/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import com.google.inject.Inject;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.lookup.LookupReferencesManager;
import org.apache.druid.query.lookup.RegisteredLookupExtractionFn;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;

public class QueryLookupOperatorConversion
implements SqlOperatorConversion {
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("LOOKUP").operandTypes(SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER).returnType(SqlTypeName.VARCHAR).functionCategory(SqlFunctionCategory.STRING).build();
    private final LookupReferencesManager lookupReferencesManager;

    @Inject
    public QueryLookupOperatorConversion(LookupReferencesManager lookupReferencesManager) {
        this.lookupReferencesManager = lookupReferencesManager;
    }

    public SqlFunction calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, StringUtils.toLowerCase((String)this.calciteOperator().getName()), inputExpressions -> {
            DruidExpression arg = (DruidExpression)inputExpressions.get(0);
            Expr lookupNameExpr = ((DruidExpression)inputExpressions.get(1)).parse(plannerContext.getExprMacroTable());
            if (arg.isSimpleExtraction() && lookupNameExpr.isLiteral()) {
                return arg.getSimpleExtraction().cascade((ExtractionFn)new RegisteredLookupExtractionFn(this.lookupReferencesManager, (String)lookupNameExpr.getLiteralValue(), false, null, Boolean.valueOf(false), Boolean.valueOf(true)));
            }
            return null;
        });
    }
}

