/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.expression.TimestampExtractExprMacro;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;
import org.joda.time.DateTimeZone;

public class TimeExtractOperatorConversion
implements SqlOperatorConversion {
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("TIME_EXTRACT").operandTypes(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER).requiredOperands(1).returnType(SqlTypeName.BIGINT).functionCategory(SqlFunctionCategory.TIMEDATE).build();

    public static DruidExpression applyTimeExtract(DruidExpression timeExpression, TimestampExtractExprMacro.Unit unit, DateTimeZone timeZone) {
        return DruidExpression.fromFunctionCall("timestamp_extract", (List<DruidExpression>)ImmutableList.of((Object)timeExpression, (Object)DruidExpression.fromExpression(DruidExpression.stringLiteral(unit.name())), (Object)DruidExpression.fromExpression(DruidExpression.stringLiteral(timeZone.getID()))));
    }

    public SqlFunction calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        RexCall call = (RexCall)rexNode;
        RexNode timeArg = (RexNode)call.getOperands().get(0);
        DruidExpression timeExpression = Expressions.toDruidExpression(plannerContext, rowSignature, timeArg);
        if (timeExpression == null) {
            return null;
        }
        TimestampExtractExprMacro.Unit unit = TimestampExtractExprMacro.Unit.valueOf((String)StringUtils.toUpperCase((String)RexLiteral.stringValue((RexNode)((RexNode)call.getOperands().get(1)))));
        DateTimeZone timeZone = call.getOperands().size() > 2 && !RexLiteral.isNullLiteral((RexNode)((RexNode)call.getOperands().get(2))) ? DateTimes.inferTzFromString((String)RexLiteral.stringValue((RexNode)((RexNode)call.getOperands().get(2)))) : plannerContext.getTimeZone();
        return TimeExtractOperatorConversion.applyTimeExtract(timeExpression, unit, timeZone);
    }
}

