/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.java.util.common.IAE;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;

public class PlannerConfig {
    public static final String CTX_KEY_USE_APPROXIMATE_COUNT_DISTINCT = "useApproximateCountDistinct";
    public static final String CTX_KEY_USE_APPROXIMATE_TOPN = "useApproximateTopN";
    public static final String CTX_KEY_USE_FALLBACK = "useFallback";
    @JsonProperty
    private Period metadataRefreshPeriod = new Period((Object)"PT1M");
    @JsonProperty
    private int maxSemiJoinRowsInMemory = 100000;
    @JsonProperty
    private int maxTopNLimit = 100000;
    @JsonProperty
    private int maxQueryCount = 8;
    @JsonProperty
    private int selectThreshold = 1000;
    @JsonProperty
    private boolean useApproximateCountDistinct = true;
    @JsonProperty
    private boolean useApproximateTopN = true;
    @JsonProperty
    private boolean useFallback = false;
    @JsonProperty
    private boolean requireTimeCondition = false;
    @JsonProperty
    private boolean awaitInitializationOnStart = true;
    @JsonProperty
    private DateTimeZone sqlTimeZone = DateTimeZone.UTC;
    @JsonProperty
    private boolean metadataSegmentCacheEnable = false;
    @JsonProperty
    private long metadataSegmentPollPeriod = 60000L;
    private boolean serializeComplexValues = true;

    public long getMetadataSegmentPollPeriod() {
        return this.metadataSegmentPollPeriod;
    }

    public boolean isMetadataSegmentCacheEnable() {
        return this.metadataSegmentCacheEnable;
    }

    public Period getMetadataRefreshPeriod() {
        return this.metadataRefreshPeriod;
    }

    public int getMaxSemiJoinRowsInMemory() {
        return this.maxSemiJoinRowsInMemory;
    }

    public int getMaxTopNLimit() {
        return this.maxTopNLimit;
    }

    public int getMaxQueryCount() {
        return this.maxQueryCount;
    }

    public int getSelectThreshold() {
        return this.selectThreshold;
    }

    public boolean isUseApproximateCountDistinct() {
        return this.useApproximateCountDistinct;
    }

    public boolean isUseApproximateTopN() {
        return this.useApproximateTopN;
    }

    public boolean isUseFallback() {
        return this.useFallback;
    }

    public boolean isRequireTimeCondition() {
        return this.requireTimeCondition;
    }

    public DateTimeZone getSqlTimeZone() {
        return this.sqlTimeZone;
    }

    public boolean isAwaitInitializationOnStart() {
        return this.awaitInitializationOnStart;
    }

    public boolean shouldSerializeComplexValues() {
        return this.serializeComplexValues;
    }

    public PlannerConfig withOverrides(Map<String, Object> context) {
        if (context == null) {
            return this;
        }
        PlannerConfig newConfig = new PlannerConfig();
        newConfig.metadataRefreshPeriod = this.getMetadataRefreshPeriod();
        newConfig.maxSemiJoinRowsInMemory = this.getMaxSemiJoinRowsInMemory();
        newConfig.maxTopNLimit = this.getMaxTopNLimit();
        newConfig.maxQueryCount = this.getMaxQueryCount();
        newConfig.selectThreshold = this.getSelectThreshold();
        newConfig.useApproximateCountDistinct = PlannerConfig.getContextBoolean(context, CTX_KEY_USE_APPROXIMATE_COUNT_DISTINCT, this.isUseApproximateCountDistinct());
        newConfig.useApproximateTopN = PlannerConfig.getContextBoolean(context, CTX_KEY_USE_APPROXIMATE_TOPN, this.isUseApproximateTopN());
        newConfig.useFallback = PlannerConfig.getContextBoolean(context, CTX_KEY_USE_FALLBACK, this.isUseFallback());
        newConfig.requireTimeCondition = this.isRequireTimeCondition();
        newConfig.sqlTimeZone = this.getSqlTimeZone();
        newConfig.awaitInitializationOnStart = this.isAwaitInitializationOnStart();
        newConfig.metadataSegmentCacheEnable = this.isMetadataSegmentCacheEnable();
        newConfig.metadataSegmentPollPeriod = this.getMetadataSegmentPollPeriod();
        newConfig.serializeComplexValues = this.shouldSerializeComplexValues();
        return newConfig;
    }

    private static boolean getContextBoolean(Map<String, Object> context, String parameter, boolean defaultValue) {
        Object value = context.get(parameter);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new IAE("Expected parameter[%s] to be boolean", new Object[]{parameter});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlannerConfig that = (PlannerConfig)o;
        return this.maxSemiJoinRowsInMemory == that.maxSemiJoinRowsInMemory && this.maxTopNLimit == that.maxTopNLimit && this.maxQueryCount == that.maxQueryCount && this.selectThreshold == that.selectThreshold && this.useApproximateCountDistinct == that.useApproximateCountDistinct && this.useApproximateTopN == that.useApproximateTopN && this.useFallback == that.useFallback && this.requireTimeCondition == that.requireTimeCondition && this.awaitInitializationOnStart == that.awaitInitializationOnStart && this.metadataSegmentCacheEnable == that.metadataSegmentCacheEnable && this.metadataSegmentPollPeriod == that.metadataSegmentPollPeriod && this.serializeComplexValues == that.serializeComplexValues && Objects.equals(this.metadataRefreshPeriod, that.metadataRefreshPeriod) && Objects.equals(this.sqlTimeZone, that.sqlTimeZone);
    }

    public int hashCode() {
        return Objects.hash(this.metadataRefreshPeriod, this.maxSemiJoinRowsInMemory, this.maxTopNLimit, this.maxQueryCount, this.selectThreshold, this.useApproximateCountDistinct, this.useApproximateTopN, this.useFallback, this.requireTimeCondition, this.awaitInitializationOnStart, this.sqlTimeZone, this.metadataSegmentCacheEnable, this.metadataSegmentPollPeriod, this.serializeComplexValues);
    }

    public String toString() {
        return "PlannerConfig{metadataRefreshPeriod=" + this.metadataRefreshPeriod + ", maxSemiJoinRowsInMemory=" + this.maxSemiJoinRowsInMemory + ", maxTopNLimit=" + this.maxTopNLimit + ", maxQueryCount=" + this.maxQueryCount + ", selectThreshold=" + this.selectThreshold + ", useApproximateCountDistinct=" + this.useApproximateCountDistinct + ", useApproximateTopN=" + this.useApproximateTopN + ", useFallback=" + this.useFallback + ", requireTimeCondition=" + this.requireTimeCondition + ", awaitInitializationOnStart=" + this.awaitInitializationOnStart + ", metadataSegmentCacheEnable=" + this.metadataSegmentCacheEnable + ", metadataSegmentPollPeriod=" + this.metadataSegmentPollPeriod + ", sqlTimeZone=" + this.sqlTimeZone + ", serializeComplexValues=" + this.serializeComplexValues + '}';
    }
}

