/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.druid.java.util.common.guava.Sequence;

public class PlannerResult {
    private final Supplier<Sequence<Object[]>> resultsSupplier;
    private final RelDataType rowType;
    private final Set<String> datasourceNames;
    private final AtomicBoolean didRun = new AtomicBoolean();

    public PlannerResult(Supplier<Sequence<Object[]>> resultsSupplier, RelDataType rowType, Set<String> datasourceNames) {
        this.resultsSupplier = resultsSupplier;
        this.rowType = rowType;
        this.datasourceNames = ImmutableSet.copyOf(datasourceNames);
    }

    public Sequence<Object[]> run() {
        if (!this.didRun.compareAndSet(false, true)) {
            throw new IllegalStateException("Cannot run more than once");
        }
        return (Sequence)this.resultsSupplier.get();
    }

    public RelDataType rowType() {
        return this.rowType;
    }

    public Set<String> datasourceNames() {
        return this.datasourceNames;
    }
}

