/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.plan.RelOptLattice;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.AbstractConverter;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.rules.AggregateExpandDistinctAggregatesRule;
import org.apache.calcite.rel.rules.AggregateJoinTransposeRule;
import org.apache.calcite.rel.rules.AggregateProjectMergeRule;
import org.apache.calcite.rel.rules.AggregateProjectPullUpConstantsRule;
import org.apache.calcite.rel.rules.AggregateReduceFunctionsRule;
import org.apache.calcite.rel.rules.AggregateRemoveRule;
import org.apache.calcite.rel.rules.AggregateStarTableRule;
import org.apache.calcite.rel.rules.AggregateValuesRule;
import org.apache.calcite.rel.rules.CalcRemoveRule;
import org.apache.calcite.rel.rules.FilterAggregateTransposeRule;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.rel.rules.FilterMergeRule;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.rules.FilterTableScanRule;
import org.apache.calcite.rel.rules.JoinCommuteRule;
import org.apache.calcite.rel.rules.JoinPushExpressionsRule;
import org.apache.calcite.rel.rules.JoinPushThroughJoinRule;
import org.apache.calcite.rel.rules.ProjectFilterTransposeRule;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.rules.ProjectTableScanRule;
import org.apache.calcite.rel.rules.ProjectToWindowRule;
import org.apache.calcite.rel.rules.ProjectWindowTransposeRule;
import org.apache.calcite.rel.rules.PruneEmptyRules;
import org.apache.calcite.rel.rules.ReduceExpressionsRule;
import org.apache.calcite.rel.rules.SortJoinTransposeRule;
import org.apache.calcite.rel.rules.SortProjectTransposeRule;
import org.apache.calcite.rel.rules.SortRemoveRule;
import org.apache.calcite.rel.rules.SortUnionTransposeRule;
import org.apache.calcite.rel.rules.SubQueryRemoveRule;
import org.apache.calcite.rel.rules.TableScanRule;
import org.apache.calcite.rel.rules.UnionMergeRule;
import org.apache.calcite.rel.rules.UnionPullUpConstantsRule;
import org.apache.calcite.rel.rules.UnionToDistinctRule;
import org.apache.calcite.rel.rules.ValuesReduceRule;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.sql2rel.RelFieldTrimmer;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RelBuilder;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.QueryMaker;
import org.apache.druid.sql.calcite.rule.CaseFilteredAggregatorRule;
import org.apache.druid.sql.calcite.rule.DruidRelToBindableRule;
import org.apache.druid.sql.calcite.rule.DruidRelToDruidRule;
import org.apache.druid.sql.calcite.rule.DruidRules;
import org.apache.druid.sql.calcite.rule.DruidSemiJoinRule;
import org.apache.druid.sql.calcite.rule.DruidTableScanRule;
import org.apache.druid.sql.calcite.rule.ProjectAggregatePruneUnusedCallRule;
import org.apache.druid.sql.calcite.rule.SortCollapseRule;

public class Rules {
    public static final int DRUID_CONVENTION_RULES = 0;
    public static final int BINDABLE_CONVENTION_RULES = 1;
    private static final List<RelOptRule> DEFAULT_RULES = ImmutableList.of((Object)AggregateStarTableRule.INSTANCE, (Object)AggregateStarTableRule.INSTANCE2, (Object)TableScanRule.INSTANCE, (Object)ProjectMergeRule.INSTANCE, (Object)FilterTableScanRule.INSTANCE, (Object)ProjectFilterTransposeRule.INSTANCE, (Object)FilterProjectTransposeRule.INSTANCE, (Object)FilterJoinRule.FILTER_ON_JOIN, (Object)JoinPushExpressionsRule.INSTANCE, (Object)FilterAggregateTransposeRule.INSTANCE, (Object)ProjectWindowTransposeRule.INSTANCE, (Object)JoinCommuteRule.INSTANCE, (Object[])new RelOptRule[]{JoinPushThroughJoinRule.RIGHT, JoinPushThroughJoinRule.LEFT, SortProjectTransposeRule.INSTANCE, SortJoinTransposeRule.INSTANCE, SortUnionTransposeRule.INSTANCE});
    private static final List<RelOptRule> MISCELLANEOUS_RULES = ImmutableList.of((Object)Bindables.BINDABLE_TABLE_SCAN_RULE, (Object)ProjectTableScanRule.INSTANCE, (Object)ProjectTableScanRule.INTERPRETER);
    private static final List<RelOptRule> CONSTANT_REDUCTION_RULES = ImmutableList.of((Object)ReduceExpressionsRule.PROJECT_INSTANCE, (Object)ReduceExpressionsRule.CALC_INSTANCE, (Object)ReduceExpressionsRule.JOIN_INSTANCE, (Object)ReduceExpressionsRule.FILTER_INSTANCE, (Object)ValuesReduceRule.FILTER_INSTANCE, (Object)ValuesReduceRule.PROJECT_FILTER_INSTANCE, (Object)ValuesReduceRule.PROJECT_INSTANCE, (Object)AggregateValuesRule.INSTANCE);
    private static final List<RelOptRule> VOLCANO_ABSTRACT_RULES = ImmutableList.of((Object)FilterJoinRule.FILTER_ON_JOIN, (Object)FilterJoinRule.JOIN, (Object)AbstractConverter.ExpandConversionRule.INSTANCE, (Object)JoinCommuteRule.INSTANCE, (Object)AggregateRemoveRule.INSTANCE, (Object)UnionToDistinctRule.INSTANCE, (Object)ProjectRemoveRule.INSTANCE, (Object)AggregateJoinTransposeRule.INSTANCE, (Object)AggregateProjectMergeRule.INSTANCE, (Object)CalcRemoveRule.INSTANCE, (Object)SortRemoveRule.INSTANCE);
    private static final List<RelOptRule> RELOPTUTIL_ABSTRACT_RULES = ImmutableList.of((Object)AggregateProjectPullUpConstantsRule.INSTANCE2, (Object)UnionPullUpConstantsRule.INSTANCE, (Object)PruneEmptyRules.UNION_INSTANCE, (Object)PruneEmptyRules.PROJECT_INSTANCE, (Object)PruneEmptyRules.FILTER_INSTANCE, (Object)PruneEmptyRules.SORT_INSTANCE, (Object)PruneEmptyRules.AGGREGATE_INSTANCE, (Object)PruneEmptyRules.JOIN_LEFT_INSTANCE, (Object)PruneEmptyRules.JOIN_RIGHT_INSTANCE, (Object)PruneEmptyRules.SORT_FETCH_ZERO_INSTANCE, (Object)UnionMergeRule.INSTANCE, (Object)ProjectToWindowRule.PROJECT, (Object[])new RelOptRule[]{FilterMergeRule.INSTANCE});
    private static final List<RelOptRule> SUB_QUERY_REMOVE_RULES = ImmutableList.of((Object)SubQueryRemoveRule.PROJECT, (Object)SubQueryRemoveRule.FILTER, (Object)SubQueryRemoveRule.JOIN);

    private Rules() {
    }

    public static List<Program> programs(PlannerContext plannerContext, QueryMaker queryMaker) {
        Program hepProgram = Programs.sequence((Program[])new Program[]{Programs.subQuery((RelMetadataProvider)DefaultRelMetadataProvider.INSTANCE), new DecorrelateAndTrimFieldsProgram()});
        return ImmutableList.of((Object)Programs.sequence((Program[])new Program[]{hepProgram, Programs.ofRules(Rules.druidConventionRuleSet(plannerContext, queryMaker))}), (Object)Programs.sequence((Program[])new Program[]{hepProgram, Programs.ofRules(Rules.bindableConventionRuleSet(plannerContext, queryMaker))}));
    }

    private static List<RelOptRule> druidConventionRuleSet(PlannerContext plannerContext, QueryMaker queryMaker) {
        return ImmutableList.builder().addAll(Rules.baseRuleSet(plannerContext, queryMaker)).add((Object)DruidRelToDruidRule.instance()).build();
    }

    private static List<RelOptRule> bindableConventionRuleSet(PlannerContext plannerContext, QueryMaker queryMaker) {
        return ImmutableList.builder().addAll(Rules.baseRuleSet(plannerContext, queryMaker)).addAll((Iterable)Bindables.RULES).add((Object)AggregateReduceFunctionsRule.INSTANCE).build();
    }

    private static List<RelOptRule> baseRuleSet(PlannerContext plannerContext, QueryMaker queryMaker) {
        PlannerConfig plannerConfig = plannerContext.getPlannerConfig();
        ImmutableList.Builder rules = ImmutableList.builder();
        rules.addAll(DEFAULT_RULES);
        rules.addAll(MISCELLANEOUS_RULES);
        rules.addAll(CONSTANT_REDUCTION_RULES);
        rules.addAll(VOLCANO_ABSTRACT_RULES);
        rules.addAll(RELOPTUTIL_ABSTRACT_RULES);
        rules.addAll(SUB_QUERY_REMOVE_RULES);
        if (!plannerConfig.isUseApproximateCountDistinct()) {
            rules.add((Object)AggregateExpandDistinctAggregatesRule.JOIN);
        }
        if (plannerConfig.isUseFallback()) {
            rules.add((Object)DruidRelToBindableRule.instance());
        }
        rules.add((Object)SortCollapseRule.instance());
        rules.add((Object)CaseFilteredAggregatorRule.instance());
        rules.add((Object)ProjectAggregatePruneUnusedCallRule.instance());
        rules.add((Object)new DruidTableScanRule(queryMaker));
        rules.addAll(DruidRules.rules());
        if (plannerConfig.getMaxSemiJoinRowsInMemory() > 0) {
            rules.add((Object)DruidSemiJoinRule.instance());
        }
        return rules.build();
    }

    private static class DecorrelateAndTrimFieldsProgram
    implements Program {
        private DecorrelateAndTrimFieldsProgram() {
        }

        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits, List<RelOptMaterialization> materializations, List<RelOptLattice> lattices) {
            RelNode decorrelatedRel = RelDecorrelator.decorrelateQuery((RelNode)rel);
            RelBuilder relBuilder = RelFactories.LOGICAL_BUILDER.create(decorrelatedRel.getCluster(), null);
            return new RelFieldTrimmer(null, relBuilder).trim(decorrelatedRel);
        }
    }
}

