/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.sql.calcite.rel.DruidConvention;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.calcite.rel.PartialDruidQuery;
import org.apache.druid.sql.calcite.rel.QueryMaker;

public class DruidUnionRel
extends DruidRel<DruidUnionRel> {
    private final RelDataType rowType;
    private final List<RelNode> rels;
    private final int limit;

    private DruidUnionRel(RelOptCluster cluster, RelTraitSet traitSet, QueryMaker queryMaker, RelDataType rowType, List<RelNode> rels, int limit) {
        super(cluster, traitSet, queryMaker);
        this.rowType = rowType;
        this.rels = rels;
        this.limit = limit;
    }

    public static DruidUnionRel create(QueryMaker queryMaker, RelDataType rowType, List<RelNode> rels, int limit) {
        Preconditions.checkState((rels.size() > 0 ? 1 : 0) != 0, (Object)"rels must be nonempty");
        return new DruidUnionRel(rels.get(0).getCluster(), rels.get(0).getTraitSet(), queryMaker, rowType, new ArrayList<RelNode>(rels), limit);
    }

    @Override
    @Nullable
    public PartialDruidQuery getPartialDruidQuery() {
        return null;
    }

    @Override
    public int getQueryCount() {
        return this.rels.stream().mapToInt(rel -> ((DruidRel)((Object)rel)).getQueryCount()).sum();
    }

    @Override
    public Sequence<Object[]> runQuery() {
        if (this.limit == 0) {
            return Sequences.empty();
        }
        Sequence baseSequence = Sequences.concat((Iterable)FluentIterable.from(this.rels).transform(rel -> ((DruidRel)((Object)rel)).runQuery()));
        return this.limit > 0 ? baseSequence.limit(this.limit) : baseSequence;
    }

    @Override
    public DruidUnionRel withPartialQuery(PartialDruidQuery newQueryBuilder) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public DruidQuery toDruidQuery(boolean finalizeAggregations) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DruidQuery toDruidQueryForExplaining() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DruidUnionRel asBindable() {
        return new DruidUnionRel(this.getCluster(), this.getTraitSet().replace((RelTrait)BindableConvention.INSTANCE), this.getQueryMaker(), this.rowType, this.rels.stream().map(rel -> RelOptRule.convert((RelNode)rel, (RelTrait)BindableConvention.INSTANCE)).collect(Collectors.toList()), this.limit);
    }

    @Override
    public DruidUnionRel asDruidConvention() {
        return new DruidUnionRel(this.getCluster(), this.getTraitSet().replace((RelTrait)DruidConvention.instance()), this.getQueryMaker(), this.rowType, this.rels.stream().map(rel -> RelOptRule.convert((RelNode)rel, (RelTrait)DruidConvention.instance())).collect(Collectors.toList()), this.limit);
    }

    public List<RelNode> getInputs() {
        return this.rels;
    }

    public void replaceInput(int ordinalInParent, RelNode p) {
        this.rels.set(ordinalInParent, p);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DruidUnionRel(this.getCluster(), traitSet, this.getQueryMaker(), this.rowType, inputs, this.limit);
    }

    @Override
    public List<String> getDataSourceNames() {
        return this.rels.stream().flatMap(rel -> ((DruidRel)((Object)rel)).getDataSourceNames().stream()).distinct().collect(Collectors.toList());
    }

    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        for (int i = 0; i < this.rels.size(); ++i) {
            pw.input(StringUtils.format((String)"input#%d", (Object[])new Object[]{i}), this.rels.get(i));
        }
        return pw.item("limit", (Object)this.limit);
    }

    protected RelDataType deriveRowType() {
        return this.rowType;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeCost(this.rels.stream().mapToDouble(arg_0 -> ((RelMetadataQuery)mq).getRowCount(arg_0)).sum(), 0.0, 0.0);
    }

    public int getLimit() {
        return this.limit;
    }
}

