/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.sql.calcite.table.RowSignature;
import org.apache.druid.timeline.SegmentId;

public class SegmentMetadataHolder {
    private final SegmentId segmentId;
    private final long isPublished;
    private final long isAvailable;
    private final long isRealtime;
    private final Set<String> segmentServers;
    private final long numRows;
    @Nullable
    private final RowSignature rowSignature;

    public static Builder builder(SegmentId segmentId, long isPublished, long isAvailable, long isRealtime, Set<String> segmentServers, RowSignature rowSignature, long numRows) {
        return new Builder(segmentId, isPublished, isAvailable, isRealtime, segmentServers, rowSignature, numRows);
    }

    public static Builder from(SegmentMetadataHolder h) {
        return new Builder(h.getSegmentId(), h.isPublished(), h.isAvailable(), h.isRealtime(), h.getReplicas(), h.getRowSignature(), h.getNumRows());
    }

    private SegmentMetadataHolder(Builder builder) {
        this.rowSignature = builder.rowSignature;
        this.isPublished = builder.isPublished;
        this.isAvailable = builder.isAvailable;
        this.isRealtime = builder.isRealtime;
        this.segmentServers = builder.segmentServers;
        this.numRows = builder.numRows;
        this.segmentId = builder.segmentId;
    }

    public long isPublished() {
        return this.isPublished;
    }

    public long isAvailable() {
        return this.isAvailable;
    }

    public long isRealtime() {
        return this.isRealtime;
    }

    public SegmentId getSegmentId() {
        return this.segmentId;
    }

    public Set<String> getReplicas() {
        return this.segmentServers;
    }

    public long getNumReplicas() {
        return this.segmentServers.size();
    }

    public long getNumRows() {
        return this.numRows;
    }

    @Nullable
    public RowSignature getRowSignature() {
        return this.rowSignature;
    }

    public static class Builder {
        private final SegmentId segmentId;
        private final long isPublished;
        private final long isAvailable;
        private final long isRealtime;
        private Set<String> segmentServers;
        @Nullable
        private RowSignature rowSignature;
        private long numRows;

        private Builder(SegmentId segmentId, long isPublished, long isAvailable, long isRealtime, Set<String> servers, RowSignature rowSignature, long numRows) {
            this.segmentId = segmentId;
            this.isPublished = isPublished;
            this.isAvailable = isAvailable;
            this.isRealtime = isRealtime;
            this.segmentServers = servers;
            this.rowSignature = rowSignature;
            this.numRows = numRows;
        }

        public Builder withRowSignature(RowSignature rowSignature) {
            this.rowSignature = rowSignature;
            return this;
        }

        public Builder withNumRows(long numRows) {
            this.numRows = numRows;
            return this;
        }

        public Builder withReplicas(Set<String> servers) {
            this.segmentServers = servers;
            return this;
        }

        public SegmentMetadataHolder build() {
            return new SegmentMetadataHolder(this);
        }
    }
}

