/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.view;

import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.calcite.schema.TableMacro;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.server.security.Escalator;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.view.DruidViewMacro;
import org.apache.druid.sql.calcite.view.ViewManager;

public class InProcessViewManager
implements ViewManager {
    private final ConcurrentMap<String, DruidViewMacro> views = new ConcurrentHashMap<String, DruidViewMacro>();
    private final Escalator escalator;

    @Inject
    public InProcessViewManager(Escalator escalator) {
        this.escalator = escalator;
    }

    @Override
    public void createView(PlannerFactory plannerFactory, String viewName, String viewSql) {
        TableMacro oldValue = this.views.putIfAbsent(viewName, new DruidViewMacro(plannerFactory, this.escalator, viewSql));
        if (oldValue != null) {
            throw new ISE("View[%s] already exists", new Object[]{viewName});
        }
    }

    @Override
    public void alterView(PlannerFactory plannerFactory, String viewName, String viewSql) {
        TableMacro oldValue = this.views.replace(viewName, new DruidViewMacro(plannerFactory, this.escalator, viewSql));
        if (oldValue != null) {
            throw new ISE("View[%s] does not exist", new Object[]{viewName});
        }
    }

    @Override
    public void dropView(String viewName) {
        TableMacro oldValue = (TableMacro)this.views.remove(viewName);
        if (oldValue == null) {
            throw new ISE("View[%s] does not exist", new Object[]{viewName});
        }
    }

    @Override
    public Map<String, DruidViewMacro> getViews() {
        return this.views;
    }
}

