/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.sql.http.ResultFormat;

public class ArrayLinesWriter
implements ResultFormat.Writer {
    private final OutputStream outputStream;
    private final JsonGenerator jsonGenerator;

    public ArrayLinesWriter(OutputStream outputStream, ObjectMapper jsonMapper) throws IOException {
        this.outputStream = outputStream;
        this.jsonGenerator = jsonMapper.writer().getFactory().createGenerator(outputStream);
        this.jsonGenerator.setRootValueSeparator((SerializableString)new SerializedString("\n"));
    }

    @Override
    public void writeResponseStart() {
    }

    @Override
    public void writeResponseEnd() throws IOException {
        this.jsonGenerator.flush();
        this.outputStream.write(new byte[]{10, 10});
        this.outputStream.flush();
    }

    @Override
    public void writeHeader(List<String> columnNames) throws IOException {
        this.jsonGenerator.writeStartArray();
        for (String columnName : columnNames) {
            this.jsonGenerator.writeString(columnName);
        }
        this.jsonGenerator.writeEndArray();
    }

    @Override
    public void writeRowStart() throws IOException {
        this.jsonGenerator.writeStartArray();
    }

    @Override
    public void writeRowField(String name, @Nullable Object value) throws IOException {
        this.jsonGenerator.writeObject(value);
    }

    @Override
    public void writeRowEnd() throws IOException {
        this.jsonGenerator.writeEndArray();
    }

    @Override
    public void close() throws IOException {
        this.jsonGenerator.close();
    }
}

