/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.sql.http.ResultFormat;

public class SqlQuery {
    private final String query;
    private final ResultFormat resultFormat;
    private final boolean header;
    private final Map<String, Object> context;

    @JsonCreator
    public SqlQuery(@JsonProperty(value="query") String query, @JsonProperty(value="resultFormat") ResultFormat resultFormat, @JsonProperty(value="header") boolean header, @JsonProperty(value="context") Map<String, Object> context) {
        this.query = (String)Preconditions.checkNotNull((Object)query, (Object)"query");
        this.resultFormat = resultFormat == null ? ResultFormat.OBJECT : resultFormat;
        this.header = header;
        this.context = context == null ? ImmutableMap.of() : context;
    }

    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @JsonProperty
    public ResultFormat getResultFormat() {
        return this.resultFormat;
    }

    @JsonProperty(value="header")
    public boolean includeHeader() {
        return this.header;
    }

    @JsonProperty
    public Map<String, Object> getContext() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlQuery sqlQuery = (SqlQuery)o;
        return this.header == sqlQuery.header && Objects.equals(this.query, sqlQuery.query) && this.resultFormat == sqlQuery.resultFormat && Objects.equals(this.context, sqlQuery.context);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.query, this.resultFormat, this.header, this.context});
    }

    public String toString() {
        return "SqlQuery{query='" + this.query + '\'' + ", resultFormat=" + (Object)((Object)this.resultFormat) + ", header=" + this.header + ", context=" + this.context + '}';
    }
}

