/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;

public final class URLBuilder {
    private String protocol;
    private String username;
    private String password;
    private String host;
    private int port;
    private String path;
    private Map<String, String> parameters;
    private Map<String, Map<String, String>> methodParameters;

    public URLBuilder() {
        this.protocol = null;
        this.username = null;
        this.password = null;
        this.host = null;
        this.port = 0;
        this.path = null;
        this.parameters = new HashMap<String, String>();
        this.methodParameters = new HashMap<String, Map<String, String>>();
    }

    public URLBuilder(String protocol, String host, int port) {
        this(protocol, null, null, host, port, null, null);
    }

    public URLBuilder(String protocol, String host, int port, String[] pairs) {
        this(protocol, null, null, host, port, null, CollectionUtils.toStringMap(pairs));
    }

    public URLBuilder(String protocol, String host, int port, Map<String, String> parameters) {
        this(protocol, null, null, host, port, null, parameters);
    }

    public URLBuilder(String protocol, String host, int port, String path) {
        this(protocol, null, null, host, port, path, null);
    }

    public URLBuilder(String protocol, String host, int port, String path, String ... pairs) {
        this(protocol, null, null, host, port, path, CollectionUtils.toStringMap(pairs));
    }

    public URLBuilder(String protocol, String host, int port, String path, Map<String, String> parameters) {
        this(protocol, null, null, host, port, path, parameters);
    }

    public URLBuilder(String protocol, String username, String password, String host, int port, String path, Map<String, String> parameters) {
        this(protocol, username, password, host, port, path, parameters, URL.toMethodParameters(parameters));
    }

    public URLBuilder(String protocol, String username, String password, String host, int port, String path, Map<String, String> parameters, Map<String, Map<String, String>> methodParameters) {
        this.protocol = protocol;
        this.username = username;
        this.password = password;
        this.host = host;
        this.port = port;
        this.path = path;
        this.parameters = parameters != null ? parameters : new HashMap();
        this.methodParameters = methodParameters != null ? methodParameters : new HashMap();
    }

    public static URLBuilder from(URL url) {
        String protocol = url.getProtocol();
        String username = url.getUsername();
        String password = url.getPassword();
        String host = url.getHost();
        int port = url.getPort();
        String path = url.getPath();
        HashMap<String, String> parameters = new HashMap<String, String>(url.getParameters());
        HashMap<String, Map<String, String>> methodParameters = new HashMap<String, Map<String, String>>(url.getMethodParameters());
        return new URLBuilder(protocol, username, password, host, port, path, parameters, methodParameters);
    }

    public URL build() {
        if (StringUtils.isEmpty(this.username) && StringUtils.isNotEmpty(this.password)) {
            throw new IllegalArgumentException("Invalid url, password without username!");
        }
        this.port = this.port < 0 ? 0 : this.port;
        if (this.path != null) {
            int firstNonSlash;
            for (firstNonSlash = 0; firstNonSlash < this.path.length() && this.path.charAt(firstNonSlash) == '/'; ++firstNonSlash) {
            }
            if (firstNonSlash >= this.path.length()) {
                this.path = "";
            } else if (firstNonSlash > 0) {
                this.path = this.path.substring(firstNonSlash);
            }
        }
        if (CollectionUtils.isEmptyMap(this.methodParameters)) {
            return new URL(this.protocol, this.username, this.password, this.host, this.port, this.path, this.parameters);
        }
        return new URL(this.protocol, this.username, this.password, this.host, this.port, this.path, this.parameters, this.methodParameters);
    }

    public URLBuilder setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public URLBuilder setUsername(String username) {
        this.username = username;
        return this;
    }

    public URLBuilder setPassword(String password) {
        this.password = password;
        return this;
    }

    public URLBuilder setHost(String host) {
        this.host = host;
        return this;
    }

    public URLBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public URLBuilder setAddress(String address) {
        String host;
        int i = address.lastIndexOf(58);
        int port = this.port;
        if (i >= 0) {
            host = address.substring(0, i);
            port = Integer.parseInt(address.substring(i + 1));
        } else {
            host = address;
        }
        this.host = host;
        this.port = port;
        return this;
    }

    public URLBuilder setPath(String path) {
        this.path = path;
        return this;
    }

    public URLBuilder addParameterAndEncoded(String key, String value) {
        if (StringUtils.isEmpty(value)) {
            return this;
        }
        return this.addParameter(key, URL.encode(value));
    }

    public URLBuilder addParameter(String key, boolean value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URLBuilder addParameter(String key, char value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URLBuilder addParameter(String key, byte value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URLBuilder addParameter(String key, short value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URLBuilder addParameter(String key, int value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URLBuilder addParameter(String key, long value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URLBuilder addParameter(String key, float value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URLBuilder addParameter(String key, double value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URLBuilder addParameter(String key, Enum<?> value) {
        if (value == null) {
            return this;
        }
        return this.addParameter(key, String.valueOf(value));
    }

    public URLBuilder addParameter(String key, Number value) {
        if (value == null) {
            return this;
        }
        return this.addParameter(key, String.valueOf(value));
    }

    public URLBuilder addParameter(String key, CharSequence value) {
        if (value == null || value.length() == 0) {
            return this;
        }
        return this.addParameter(key, String.valueOf(value));
    }

    public URLBuilder addParameter(String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        this.parameters.put(key, value);
        return this;
    }

    public URLBuilder addMethodParameter(String method, String key, String value) {
        if (StringUtils.isEmpty(method) || StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        URL.putMethodParameter(method, key, value, this.methodParameters);
        return this;
    }

    public URLBuilder addParameterIfAbsent(String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        if (this.hasParameter(key)) {
            return this;
        }
        this.parameters.put(key, value);
        return this;
    }

    public URLBuilder addMethodParameterIfAbsent(String method, String key, String value) {
        if (StringUtils.isEmpty(method) || StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        if (this.hasMethodParameter(method, key)) {
            return this;
        }
        URL.putMethodParameter(method, key, value, this.methodParameters);
        return this;
    }

    public URLBuilder addParameters(Map<String, String> parameters) {
        if (CollectionUtils.isEmptyMap(parameters)) {
            return this;
        }
        boolean hasAndEqual = true;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String newValue;
            String oldValue = this.parameters.get(entry.getKey());
            if (Objects.equals(oldValue, newValue = entry.getValue())) continue;
            hasAndEqual = false;
            break;
        }
        if (hasAndEqual) {
            return this;
        }
        this.parameters.putAll(parameters);
        return this;
    }

    public URLBuilder addMethodParameters(Map<String, Map<String, String>> methodParameters) {
        if (CollectionUtils.isEmptyMap(methodParameters)) {
            return this;
        }
        this.methodParameters.putAll(methodParameters);
        return this;
    }

    public URLBuilder addParametersIfAbsent(Map<String, String> parameters) {
        if (CollectionUtils.isEmptyMap(parameters)) {
            return this;
        }
        this.parameters.putAll(parameters);
        return this;
    }

    public URLBuilder addParameters(String ... pairs) {
        if (pairs == null || pairs.length == 0) {
            return this;
        }
        if (pairs.length % 2 != 0) {
            throw new IllegalArgumentException("Map pairs can not be odd number.");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        int len = pairs.length / 2;
        for (int i = 0; i < len; ++i) {
            map.put(pairs[2 * i], pairs[2 * i + 1]);
        }
        return this.addParameters(map);
    }

    public URLBuilder addParameterString(String query) {
        if (StringUtils.isEmpty(query)) {
            return this;
        }
        return this.addParameters(StringUtils.parseQueryString(query));
    }

    public URLBuilder removeParameter(String key) {
        if (StringUtils.isEmpty(key)) {
            return this;
        }
        return this.removeParameters(key);
    }

    public URLBuilder removeParameters(Collection<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return this;
        }
        return this.removeParameters(keys.toArray(new String[0]));
    }

    public URLBuilder removeParameters(String ... keys) {
        if (keys == null || keys.length == 0) {
            return this;
        }
        for (String key : keys) {
            this.parameters.remove(key);
        }
        return this;
    }

    public URLBuilder clearParameters() {
        this.parameters.clear();
        return this;
    }

    public boolean hasParameter(String key) {
        String value = this.getParameter(key);
        return StringUtils.isNotEmpty(value);
    }

    public boolean hasMethodParameter(String method, String key) {
        if (method == null) {
            String suffix = "." + key;
            for (String fullKey : this.parameters.keySet()) {
                if (!fullKey.endsWith(suffix)) continue;
                return true;
            }
            return false;
        }
        if (key == null) {
            String prefix = method + ".";
            for (String fullKey : this.parameters.keySet()) {
                if (!fullKey.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }
        String value = this.getMethodParameter(method, key);
        return value != null && value.length() > 0;
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public String getMethodParameter(String method, String key) {
        Map<String, String> keyMap = this.methodParameters.get(method);
        String value = null;
        if (keyMap != null) {
            value = keyMap.get(key);
        }
        return value;
    }
}

