/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config.configcenter;

import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.AbstractDynamicConfiguration;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.PathUtils;
import org.apache.dubbo.common.utils.StringUtils;

public abstract class TreePathDynamicConfiguration
extends AbstractDynamicConfiguration {
    public static final String CONFIG_ROOT_PATH_PARAM_NAME = "dubbo.config-center.root-path";
    public static final String CONFIG_BASE_PATH_PARAM_NAME = "dubbo.config-center.base-path";
    public static final String DEFAULT_CONFIG_BASE_PATH = "/config";
    private final String rootPath;

    public TreePathDynamicConfiguration(URL url) {
        super(url);
        this.rootPath = this.getRootPath(url);
    }

    public TreePathDynamicConfiguration(String rootPath, String threadPoolPrefixName, int threadPoolSize, long keepAliveTime, String group, long timeout) {
        super(threadPoolPrefixName, threadPoolSize, keepAliveTime, group, timeout);
        this.rootPath = rootPath;
    }

    @Override
    protected final String doGetConfig(String key, String group) throws Exception {
        String pathKey = this.buildPathKey(group, key);
        return this.doGetConfig(pathKey);
    }

    @Override
    public final boolean publishConfig(String key, String group, String content) {
        String pathKey = this.buildPathKey(group, key);
        return Boolean.TRUE.equals(this.execute(() -> this.doPublishConfig(pathKey, content), this.getDefaultTimeout()));
    }

    @Override
    protected final boolean doRemoveConfig(String key, String group) throws Exception {
        String pathKey = this.buildPathKey(group, key);
        return this.doRemoveConfig(pathKey);
    }

    @Override
    public final void addListener(String key, String group, ConfigurationListener listener) {
        String pathKey = this.buildPathKey(group, key);
        this.doAddListener(pathKey, listener);
    }

    @Override
    public final void removeListener(String key, String group, ConfigurationListener listener) {
        String pathKey = this.buildPathKey(group, key);
        this.doRemoveListener(pathKey, listener);
    }

    @Override
    public final SortedSet<String> getConfigKeys(String group) throws UnsupportedOperationException {
        String groupPath = this.buildGroupPath(group);
        Collection<String> configKeys = this.doGetConfigKeys(groupPath);
        return CollectionUtils.isEmpty(configKeys) ? Collections.emptySortedSet() : Collections.unmodifiableSortedSet(new TreeSet<String>(configKeys));
    }

    protected abstract boolean doPublishConfig(String var1, String var2) throws Exception;

    protected abstract String doGetConfig(String var1) throws Exception;

    protected abstract boolean doRemoveConfig(String var1) throws Exception;

    protected abstract Collection<String> doGetConfigKeys(String var1);

    protected abstract void doAddListener(String var1, ConfigurationListener var2);

    protected abstract void doRemoveListener(String var1, ConfigurationListener var2);

    protected String buildGroupPath(String group) {
        return PathUtils.buildPath(this.rootPath, group);
    }

    protected String buildPathKey(String group, String key) {
        return PathUtils.buildPath(this.buildGroupPath(group), key);
    }

    protected String getRootPath(URL url) {
        String rootPath = url.getParameter(CONFIG_ROOT_PATH_PARAM_NAME, this.buildRootPath(url));
        int rootPathLength = (rootPath = PathUtils.normalize(rootPath)).length();
        if (rootPathLength > 1 && rootPath.endsWith("/")) {
            rootPath = rootPath.substring(0, rootPathLength - 1);
        }
        return rootPath;
    }

    private String buildRootPath(URL url) {
        return "/" + this.getConfigNamespace(url) + this.getConfigBasePath(url);
    }

    protected String getConfigNamespace(URL url) {
        return url.getParameter("config.namespace", "dubbo");
    }

    protected String getConfigBasePath(URL url) {
        String configBasePath = url.getParameter(CONFIG_BASE_PATH_PARAM_NAME, DEFAULT_CONFIG_BASE_PATH);
        if (StringUtils.isNotEmpty(configBasePath) && !configBasePath.startsWith("/")) {
            configBasePath = "/" + configBasePath;
        }
        return configBasePath;
    }
}

