/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class LFUCache<K, V> {
    private Map<K, CacheNode<K, V>> map;
    private CacheDeque<K, V>[] freqTable;
    private final int capacity;
    private int evictionCount;
    private int curSize = 0;
    private final ReentrantLock lock = new ReentrantLock();
    private static final int DEFAULT_INITIAL_CAPACITY = 1000;
    private static final float DEFAULT_EVICTION_FACTOR = 0.75f;

    public LFUCache() {
        this(1000, 0.75f);
    }

    public LFUCache(int maxCapacity, float evictionFactor) {
        int i;
        boolean factorInRange;
        if (maxCapacity <= 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + maxCapacity);
        }
        boolean bl = factorInRange = evictionFactor <= 1.0f || evictionFactor < 0.0f;
        if (!factorInRange || Float.isNaN(evictionFactor)) {
            throw new IllegalArgumentException("Illegal eviction factor value:" + evictionFactor);
        }
        this.capacity = maxCapacity;
        this.evictionCount = (int)((float)this.capacity * evictionFactor);
        this.map = new HashMap<K, CacheNode<K, V>>();
        this.freqTable = new CacheDeque[this.capacity + 1];
        for (i = 0; i <= this.capacity; ++i) {
            this.freqTable[i] = new CacheDeque();
        }
        for (i = 0; i < this.capacity; ++i) {
            this.freqTable[i].nextDeque = this.freqTable[i + 1];
        }
        this.freqTable[this.capacity].nextDeque = this.freqTable[this.capacity];
    }

    public int getCapacity() {
        return this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        CacheNode<K, V> node;
        this.lock.lock();
        try {
            if (this.map.containsKey(key)) {
                node = this.map.get(key);
                if (node != null) {
                    CacheNode.withdrawNode(node);
                }
                node.value = value;
                this.freqTable[0].addLastNode(node);
                this.map.put(key, node);
            } else {
                node = this.freqTable[0].addLast(key, value);
                this.map.put(key, node);
                ++this.curSize;
                if (this.curSize > this.capacity) {
                    this.proceedEviction();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return node.value;
    }

    public V remove(K key) {
        CacheNode<K, V> node = null;
        this.lock.lock();
        try {
            if (this.map.containsKey(key)) {
                node = this.map.remove(key);
                if (node != null) {
                    CacheNode.withdrawNode(node);
                }
                --this.curSize;
            }
        }
        finally {
            this.lock.unlock();
        }
        return node != null ? (V)node.value : null;
    }

    public V get(K key) {
        CacheNode<K, V> node = null;
        this.lock.lock();
        try {
            if (this.map.containsKey(key)) {
                node = this.map.get(key);
                CacheNode.withdrawNode(node);
                node.owner.nextDeque.addLastNode(node);
            }
        }
        finally {
            this.lock.unlock();
        }
        return node != null ? (V)node.value : null;
    }

    private int proceedEviction() {
        int targetSize = this.capacity - this.evictionCount;
        int evictedElements = 0;
        block0: for (int i = 0; i <= this.capacity; ++i) {
            while (!this.freqTable[i].isEmpty()) {
                CacheNode<K, V> node = this.freqTable[i].pollFirst();
                this.remove(node.key);
                if (targetSize >= this.curSize) break block0;
                ++evictedElements;
            }
        }
        return evictedElements;
    }

    public int getSize() {
        return this.curSize;
    }

    static class CacheDeque<K, V> {
        CacheNode<K, V> last = new CacheNode();
        CacheNode<K, V> first = new CacheNode();
        CacheDeque<K, V> nextDeque;

        CacheDeque() {
            this.last.next = this.first;
            this.first.prev = this.last;
        }

        CacheNode<K, V> addLast(K key, V value) {
            CacheNode<K, V> node = new CacheNode<K, V>(key, value);
            node.owner = this;
            node.next = this.last.next;
            node.prev = this.last;
            node.next.prev = node;
            this.last.next = node;
            return node;
        }

        CacheNode<K, V> addLastNode(CacheNode<K, V> node) {
            node.owner = this;
            node.next = this.last.next;
            node.prev = this.last;
            node.next.prev = node;
            this.last.next = node;
            return node;
        }

        CacheNode<K, V> pollFirst() {
            CacheNode node = null;
            if (this.first.prev != this.last) {
                node = this.first.prev;
                this.first.prev = node.prev;
                this.first.prev.next = this.first;
                node.prev = null;
                node.next = null;
            }
            return node;
        }

        boolean isEmpty() {
            return this.last.next == this.first;
        }
    }

    static class CacheNode<K, V> {
        CacheNode<K, V> prev;
        CacheNode<K, V> next;
        K key;
        V value;
        CacheDeque owner;

        CacheNode() {
        }

        CacheNode(K key, V value) {
            this.key = key;
            this.value = value;
        }

        static <K, V> CacheNode<K, V> withdrawNode(CacheNode<K, V> node) {
            if (node != null && node.prev != null) {
                node.prev.next = node.next;
                if (node.next != null) {
                    node.next.prev = node.prev;
                }
            }
            return node;
        }
    }
}

