/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractMethodConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.rpc.model.ApplicationModel;

public abstract class AbstractInterfaceConfig
extends AbstractMethodConfig {
    private static final long serialVersionUID = -1559314110797223229L;
    protected String local;
    protected String stub;
    protected MonitorConfig monitor;
    protected String proxy;
    protected String cluster;
    protected String filter;
    protected String listener;
    protected String owner;
    protected Integer connections;
    protected String layer;
    protected ApplicationConfig application;
    protected ModuleConfig module;
    protected List<RegistryConfig> registries;
    private List<MethodConfig> methods;
    protected String registryIds;
    protected String onconnect;
    protected String ondisconnect;
    protected MetricsConfig metrics;
    protected MetadataReportConfig metadataReportConfig;
    protected ConfigCenterConfig configCenter;
    private Integer callbacks;
    private String scope;
    protected String tag;
    private Boolean auth;
    protected final List<URL> urls = new ArrayList<URL>();

    public List<URL> getExportedUrls() {
        return this.urls;
    }

    public URL toUrl() {
        return this.urls.isEmpty() ? null : this.urls.iterator().next();
    }

    public List<URL> toUrls() {
        return this.urls;
    }

    public void checkRegistry() {
        this.convertRegistryIdsToRegistries();
        for (RegistryConfig registryConfig : this.registries) {
            if (registryConfig.isValid()) continue;
            throw new IllegalStateException("No registry config found or it's not a valid config! The registry config is: " + registryConfig);
        }
    }

    public static void appendRuntimeParameters(Map<String, String> map) {
        map.put("dubbo", Version.getProtocolVersion());
        map.put("release", Version.getVersion());
        map.put("timestamp", String.valueOf(System.currentTimeMillis()));
        if (ConfigUtils.getPid() > 0) {
            map.put("pid", String.valueOf(ConfigUtils.getPid()));
        }
    }

    public void checkInterfaceAndMethods(Class<?> interfaceClass, List<MethodConfig> methods) {
        Assert.notNull(interfaceClass, new IllegalStateException("interface not allow null!"));
        if (!interfaceClass.isInterface()) {
            throw new IllegalStateException("The interface class " + interfaceClass + " is not a interface!");
        }
        if (CollectionUtils.isNotEmpty(methods)) {
            for (MethodConfig methodBean : methods) {
                methodBean.setService(interfaceClass.getName());
                methodBean.setServiceId(this.getId());
                methodBean.refresh();
                String methodName = methodBean.getName();
                if (StringUtils.isEmpty(methodName)) {
                    throw new IllegalStateException("<dubbo:method> name attribute is required! Please check: <dubbo:service interface=\"" + interfaceClass.getName() + "\" ... ><dubbo:method name=\"\" ... /></<dubbo:reference>");
                }
                boolean hasMethod = Arrays.stream(interfaceClass.getMethods()).anyMatch(method -> method.getName().equals(methodName));
                if (hasMethod) continue;
                throw new IllegalStateException("The interface " + interfaceClass.getName() + " not found method " + methodName);
            }
        }
    }

    public void checkStubAndLocal(Class<?> interfaceClass) {
        this.verifyStubAndLocal(this.local, "Local", interfaceClass);
        this.verifyStubAndLocal(this.stub, "Stub", interfaceClass);
    }

    public void verifyStubAndLocal(String className, String label, Class<?> interfaceClass) {
        if (ConfigUtils.isNotEmpty(className)) {
            Class<?> localClass = ConfigUtils.isDefault(className) ? ReflectUtils.forName(interfaceClass.getName() + label) : ReflectUtils.forName(className);
            this.verify(interfaceClass, localClass);
        }
    }

    private void verify(Class<?> interfaceClass, Class<?> localClass) {
        if (!interfaceClass.isAssignableFrom(localClass)) {
            throw new IllegalStateException("The local implementation class " + localClass.getName() + " not implement interface " + interfaceClass.getName());
        }
        try {
            ReflectUtils.findConstructor(localClass, interfaceClass);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No such constructor \"public " + localClass.getSimpleName() + "(" + interfaceClass.getName() + ")\" in local implementation class " + localClass.getName());
        }
    }

    private void convertRegistryIdsToRegistries() {
        this.computeValidRegistryIds();
        if (StringUtils.isEmpty(this.registryIds)) {
            if (CollectionUtils.isEmpty(this.registries)) {
                List<RegistryConfig> registryConfigs = ApplicationModel.getConfigManager().getDefaultRegistries();
                if (registryConfigs.isEmpty()) {
                    registryConfigs = new ArrayList<RegistryConfig>();
                    RegistryConfig registryConfig = new RegistryConfig();
                    registryConfig.refresh();
                    registryConfigs.add(registryConfig);
                } else {
                    registryConfigs = new ArrayList<RegistryConfig>(registryConfigs);
                }
                this.setRegistries(registryConfigs);
            }
        } else {
            String[] ids = CommonConstants.COMMA_SPLIT_PATTERN.split(this.registryIds);
            ArrayList tmpRegistries = new ArrayList();
            Arrays.stream(ids).forEach(id -> {
                if (tmpRegistries.stream().noneMatch(reg -> reg.getId().equals(id))) {
                    Optional<RegistryConfig> globalRegistry = ApplicationModel.getConfigManager().getRegistry((String)id);
                    if (globalRegistry.isPresent()) {
                        tmpRegistries.add(globalRegistry.get());
                    } else {
                        RegistryConfig registryConfig = new RegistryConfig();
                        registryConfig.setId((String)id);
                        registryConfig.refresh();
                        tmpRegistries.add(registryConfig);
                    }
                }
            });
            if (tmpRegistries.size() > ids.length) {
                throw new IllegalStateException("Too much registries found, the registries assigned to this service are :" + this.registryIds + ", but got " + tmpRegistries.size() + " registries!");
            }
            this.setRegistries(tmpRegistries);
        }
    }

    public void completeCompoundConfigs(AbstractInterfaceConfig interfaceConfig) {
        if (interfaceConfig != null) {
            if (this.application == null) {
                this.setApplication(interfaceConfig.getApplication());
            }
            if (this.module == null) {
                this.setModule(interfaceConfig.getModule());
            }
            if (this.registries == null) {
                this.setRegistries(interfaceConfig.getRegistries());
            }
            if (this.monitor == null) {
                this.setMonitor(interfaceConfig.getMonitor());
            }
        }
        if (this.module != null) {
            if (this.registries == null) {
                this.setRegistries(this.module.getRegistries());
            }
            if (this.monitor == null) {
                this.setMonitor(this.module.getMonitor());
            }
        }
        if (this.application != null) {
            if (this.registries == null) {
                this.setRegistries(this.application.getRegistries());
            }
            if (this.monitor == null) {
                this.setMonitor(this.application.getMonitor());
            }
        }
    }

    protected void computeValidRegistryIds() {
        if (StringUtils.isEmpty(this.getRegistryIds()) && this.getApplication() != null && StringUtils.isNotEmpty(this.getApplication().getRegistryIds())) {
            this.setRegistryIds(this.getApplication().getRegistryIds());
        }
    }

    @Deprecated
    public String getLocal() {
        return this.local;
    }

    @Deprecated
    public void setLocal(Boolean local) {
        if (local == null) {
            this.setLocal((String)null);
        } else {
            this.setLocal(local.toString());
        }
    }

    @Deprecated
    public void setLocal(String local) {
        this.local = local;
    }

    public String getStub() {
        return this.stub;
    }

    public void setStub(Boolean stub) {
        if (stub == null) {
            this.setStub((String)null);
        } else {
            this.setStub(stub.toString());
        }
    }

    public void setStub(String stub) {
        this.stub = stub;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public Integer getConnections() {
        return this.connections;
    }

    public void setConnections(Integer connections) {
        this.connections = connections;
    }

    @Parameter(key="reference.filter", append=true)
    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Parameter(key="invoker.listener", append=true)
    public String getListener() {
        return this.listener;
    }

    public void setListener(String listener) {
        this.listener = listener;
    }

    public String getLayer() {
        return this.layer;
    }

    public void setLayer(String layer) {
        this.layer = layer;
    }

    public ApplicationConfig getApplication() {
        if (this.application != null) {
            return this.application;
        }
        return ApplicationModel.getConfigManager().getApplicationOrElseThrow();
    }

    @Deprecated
    public void setApplication(ApplicationConfig application) {
        this.application = application;
        if (application != null) {
            ConfigManager configManager = ApplicationModel.getConfigManager();
            configManager.getApplication().orElseGet(() -> {
                configManager.setApplication(application);
                return application;
            });
        }
    }

    public ModuleConfig getModule() {
        if (this.module != null) {
            return this.module;
        }
        return ApplicationModel.getConfigManager().getModule().orElse(null);
    }

    @Deprecated
    public void setModule(ModuleConfig module) {
        this.module = module;
        if (module != null) {
            ConfigManager configManager = ApplicationModel.getConfigManager();
            configManager.getModule().orElseGet(() -> {
                configManager.setModule(module);
                return module;
            });
        }
    }

    public RegistryConfig getRegistry() {
        return CollectionUtils.isEmpty(this.registries) ? null : this.registries.get(0);
    }

    public void setRegistry(RegistryConfig registry) {
        ArrayList<RegistryConfig> registries = new ArrayList<RegistryConfig>(1);
        registries.add(registry);
        this.setRegistries(registries);
    }

    public List<RegistryConfig> getRegistries() {
        return this.registries;
    }

    public void setRegistries(List<? extends RegistryConfig> registries) {
        this.registries = registries;
    }

    @Parameter(excluded=true)
    public String getRegistryIds() {
        return this.registryIds;
    }

    public void setRegistryIds(String registryIds) {
        this.registryIds = registryIds;
    }

    public List<MethodConfig> getMethods() {
        return this.methods;
    }

    public void setMethods(List<? extends MethodConfig> methods) {
        this.methods = methods;
    }

    public MonitorConfig getMonitor() {
        if (this.monitor != null) {
            return this.monitor;
        }
        return ApplicationModel.getConfigManager().getMonitor().orElse(null);
    }

    @Deprecated
    public void setMonitor(String monitor) {
        this.setMonitor(new MonitorConfig(monitor));
    }

    @Deprecated
    public void setMonitor(MonitorConfig monitor) {
        this.monitor = monitor;
        if (monitor != null) {
            ConfigManager configManager = ApplicationModel.getConfigManager();
            configManager.getMonitor().orElseGet(() -> {
                configManager.setMonitor(monitor);
                return monitor;
            });
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Deprecated
    public ConfigCenterConfig getConfigCenter() {
        if (this.configCenter != null) {
            return this.configCenter;
        }
        Collection<ConfigCenterConfig> configCenterConfigs = ApplicationModel.getConfigManager().getConfigCenters();
        if (CollectionUtils.isNotEmpty(configCenterConfigs)) {
            return configCenterConfigs.iterator().next();
        }
        return null;
    }

    @Deprecated
    public void setConfigCenter(ConfigCenterConfig configCenter) {
        ConfigManager configManager;
        Collection<ConfigCenterConfig> configs;
        this.configCenter = configCenter;
        if (configCenter != null && (CollectionUtils.isEmpty(configs = (configManager = ApplicationModel.getConfigManager()).getConfigCenters()) || configs.stream().noneMatch(existed -> existed.equals(configCenter)))) {
            configManager.addConfigCenter(configCenter);
        }
    }

    public Integer getCallbacks() {
        return this.callbacks;
    }

    public void setCallbacks(Integer callbacks) {
        this.callbacks = callbacks;
    }

    public String getOnconnect() {
        return this.onconnect;
    }

    public void setOnconnect(String onconnect) {
        this.onconnect = onconnect;
    }

    public String getOndisconnect() {
        return this.ondisconnect;
    }

    public void setOndisconnect(String ondisconnect) {
        this.ondisconnect = ondisconnect;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Deprecated
    public MetadataReportConfig getMetadataReportConfig() {
        if (this.metadataReportConfig != null) {
            return this.metadataReportConfig;
        }
        Collection<MetadataReportConfig> metadataReportConfigs = ApplicationModel.getConfigManager().getMetadataConfigs();
        if (CollectionUtils.isNotEmpty(metadataReportConfigs)) {
            return metadataReportConfigs.iterator().next();
        }
        return null;
    }

    @Deprecated
    public void setMetadataReportConfig(MetadataReportConfig metadataReportConfig) {
        ConfigManager configManager;
        Collection<MetadataReportConfig> configs;
        this.metadataReportConfig = metadataReportConfig;
        if (metadataReportConfig != null && (CollectionUtils.isEmpty(configs = (configManager = ApplicationModel.getConfigManager()).getMetadataConfigs()) || configs.stream().noneMatch(existed -> existed.equals(metadataReportConfig)))) {
            configManager.addMetadataReport(metadataReportConfig);
        }
    }

    @Deprecated
    public MetricsConfig getMetrics() {
        if (this.metrics != null) {
            return this.metrics;
        }
        return ApplicationModel.getConfigManager().getMetrics().orElse(null);
    }

    @Deprecated
    public void setMetrics(MetricsConfig metrics) {
        this.metrics = metrics;
        if (metrics != null) {
            ConfigManager configManager = ApplicationModel.getConfigManager();
            configManager.getMetrics().orElseGet(() -> {
                configManager.setMetrics(metrics);
                return metrics;
            });
        }
    }

    @Parameter(key="dubbo.tag", useKeyAsProperty=false)
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Boolean getAuth() {
        return this.auth;
    }

    public void setAuth(Boolean auth) {
        this.auth = auth;
    }

    public SslConfig getSslConfig() {
        return ApplicationModel.getConfigManager().getSsl().orElse(null);
    }
}

