/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config;

import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ConfigurationUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationUtils.class);
    private static Map<String, String> CACHED_DYNAMIC_PROPERTIES = new ConcurrentHashMap<String, String>();

    public static Configuration getSystemConfiguration() {
        return ApplicationModel.getEnvironment().getSystemConfiguration();
    }

    public static Configuration getEnvConfiguration() {
        return ApplicationModel.getEnvironment().getEnvironmentConfiguration();
    }

    public static Configuration getGlobalConfiguration() {
        return ApplicationModel.getEnvironment().getConfiguration();
    }

    public static Configuration getDynamicGlobalConfiguration() {
        return ApplicationModel.getEnvironment().getDynamicGlobalConfiguration();
    }

    public static int getServerShutdownTimeout() {
        int timeout = 10000;
        Configuration configuration = ConfigurationUtils.getGlobalConfiguration();
        String value = StringUtils.trim(configuration.getString("dubbo.service.shutdown.wait"));
        if (value != null && value.length() > 0) {
            try {
                timeout = Integer.parseInt(value);
            }
            catch (Exception exception) {}
        } else {
            value = StringUtils.trim(configuration.getString("dubbo.service.shutdown.wait.seconds"));
            if (value != null && value.length() > 0) {
                try {
                    timeout = Integer.parseInt(value) * 1000;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return timeout;
    }

    public static String getCachedDynamicProperty(String key, String defaultValue) {
        String value = CACHED_DYNAMIC_PROPERTIES.computeIfAbsent(key, _k -> ConfigurationUtils.getDynamicProperty(key, ""));
        return StringUtils.isEmpty(value) ? defaultValue : value;
    }

    public static String getDynamicProperty(String property) {
        return ConfigurationUtils.getDynamicProperty(property, null);
    }

    public static String getDynamicProperty(String property, String defaultValue) {
        return StringUtils.trim(ConfigurationUtils.getDynamicGlobalConfiguration().getString(property, defaultValue));
    }

    public static String getProperty(String property) {
        return ConfigurationUtils.getProperty(property, null);
    }

    public static String getProperty(String property, String defaultValue) {
        return StringUtils.trim(ConfigurationUtils.getGlobalConfiguration().getString(property, defaultValue));
    }

    public static int get(String property, int defaultValue) {
        return ConfigurationUtils.getGlobalConfiguration().getInt(property, defaultValue);
    }

    public static Map<String, String> parseProperties(String content) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isEmpty(content)) {
            logger.warn("You specified the config center, but there's not even one single config item in it.");
        } else {
            Properties properties = new Properties();
            properties.load(new StringReader(content));
            properties.stringPropertyNames().forEach(k -> map.put((String)k, properties.getProperty((String)k)));
        }
        return map;
    }

    public static boolean isEmptyValue(Object value) {
        return value == null || value instanceof String && StringUtils.isBlank((String)value);
    }

    public static <V> Map<String, V> getSubProperties(Collection<Map<String, V>> configMaps, String prefix) {
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        String finalPrefix = prefix;
        LinkedHashMap map = new LinkedHashMap();
        for (Map<String, Object> map2 : configMaps) {
            map2.forEach((key, val) -> {
                if (StringUtils.startsWithIgnoreCase(key, finalPrefix) && !ConfigurationUtils.isEmptyValue(val)) {
                    String k = key.substring(finalPrefix.length());
                    k = StringUtils.convertToSplitName(k, "-");
                    map.putIfAbsent(k, val);
                }
            });
        }
        return map;
    }

    public static <V> boolean hasSubProperties(Collection<Map<String, V>> configMaps, String prefix) {
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        for (Map<String, V> configMap : configMaps) {
            for (Map.Entry<String, V> entry : configMap.entrySet()) {
                String key = entry.getKey();
                if (!StringUtils.startsWithIgnoreCase(key, prefix) || ConfigurationUtils.isEmptyValue(entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public static <V> Set<String> getSubIds(Collection<Map<String, V>> configMaps, String prefix) {
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        for (Map<String, Object> map : configMaps) {
            map.forEach((key, val) -> {
                String k;
                int endIndex;
                if (StringUtils.startsWithIgnoreCase(key, prefix) && !ConfigurationUtils.isEmptyValue(val) && (endIndex = (k = key.substring(prefix.length())).indexOf(".")) > 0) {
                    String id = k.substring(0, endIndex);
                    ids.add(id);
                }
            });
        }
        return ids;
    }
}

