/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.Map;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.support.Parameter;

public class ProtocolConfig
extends AbstractConfig {
    private static final long serialVersionUID = 6913423882496634749L;
    private String name;
    private String host;
    private Integer port;
    private String contextpath;
    private String threadpool;
    private String threadname;
    private Integer corethreads;
    private Integer threads;
    private Integer iothreads;
    private Integer alive;
    private Integer queues;
    private Integer accepts;
    private String codec;
    private String serialization;
    private String charset;
    private Integer payload;
    private Integer buffer;
    private Integer heartbeat;
    private String accesslog;
    private String transporter;
    private String exchanger;
    private String dispatcher;
    private String networker;
    private String server;
    private String client;
    private String telnet;
    private String prompt;
    private String status;
    private Boolean register;
    private Boolean keepAlive;
    private String optimizer;
    private String extension;
    private Map<String, String> parameters;
    private Boolean sslEnabled;

    public ProtocolConfig() {
    }

    public ProtocolConfig(String name) {
        this.setName(name);
    }

    public ProtocolConfig(String name, int port) {
        this.setName(name);
        this.setPort(port);
    }

    @Override
    protected void checkDefault() {
        super.checkDefault();
        if (this.name == null) {
            this.name = "dubbo";
        }
    }

    @Parameter(excluded=true)
    public String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    @Parameter(excluded=true)
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Parameter(excluded=true)
    public Integer getPort() {
        return this.port;
    }

    public final void setPort(Integer port) {
        this.port = port;
    }

    @Deprecated
    @Parameter(excluded=true)
    public String getPath() {
        return this.getContextpath();
    }

    @Deprecated
    public void setPath(String path) {
        this.setContextpath(path);
    }

    @Parameter(excluded=true)
    public String getContextpath() {
        return this.contextpath;
    }

    public void setContextpath(String contextpath) {
        this.contextpath = contextpath;
    }

    public String getThreadpool() {
        return this.threadpool;
    }

    public void setThreadpool(String threadpool) {
        this.threadpool = threadpool;
    }

    public String getThreadname() {
        return this.threadname;
    }

    public void setThreadname(String threadname) {
        this.threadname = threadname;
    }

    public Integer getCorethreads() {
        return this.corethreads;
    }

    public void setCorethreads(Integer corethreads) {
        this.corethreads = corethreads;
    }

    public Integer getThreads() {
        return this.threads;
    }

    public void setThreads(Integer threads) {
        this.threads = threads;
    }

    public Integer getIothreads() {
        return this.iothreads;
    }

    public void setIothreads(Integer iothreads) {
        this.iothreads = iothreads;
    }

    public Integer getAlive() {
        return this.alive;
    }

    public void setAlive(Integer alive) {
        this.alive = alive;
    }

    public Integer getQueues() {
        return this.queues;
    }

    public void setQueues(Integer queues) {
        this.queues = queues;
    }

    public Integer getAccepts() {
        return this.accepts;
    }

    public void setAccepts(Integer accepts) {
        this.accepts = accepts;
    }

    public String getCodec() {
        return this.codec;
    }

    public void setCodec(String codec) {
        this.codec = codec;
    }

    public String getSerialization() {
        return this.serialization;
    }

    public void setSerialization(String serialization) {
        this.serialization = serialization;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public Integer getPayload() {
        return this.payload;
    }

    public void setPayload(Integer payload) {
        this.payload = payload;
    }

    public Integer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(Integer buffer) {
        this.buffer = buffer;
    }

    public Integer getHeartbeat() {
        return this.heartbeat;
    }

    public void setHeartbeat(Integer heartbeat) {
        this.heartbeat = heartbeat;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getAccesslog() {
        return this.accesslog;
    }

    public void setAccesslog(String accesslog) {
        this.accesslog = accesslog;
    }

    public String getTelnet() {
        return this.telnet;
    }

    public void setTelnet(String telnet) {
        this.telnet = telnet;
    }

    @Parameter(escaped=true)
    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Boolean isRegister() {
        return this.register;
    }

    public void setRegister(Boolean register) {
        this.register = register;
    }

    public String getTransporter() {
        return this.transporter;
    }

    public void setTransporter(String transporter) {
        this.transporter = transporter;
    }

    public String getExchanger() {
        return this.exchanger;
    }

    public void setExchanger(String exchanger) {
        this.exchanger = exchanger;
    }

    @Deprecated
    @Parameter(excluded=true)
    public String getDispather() {
        return this.getDispatcher();
    }

    @Deprecated
    public void setDispather(String dispather) {
        this.setDispatcher(dispather);
    }

    public String getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(String dispatcher) {
        this.dispatcher = dispatcher;
    }

    public String getNetworker() {
        return this.networker;
    }

    public void setNetworker(String networker) {
        this.networker = networker;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Parameter(key="ssl-enabled")
    public Boolean getSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public String getOptimizer() {
        return this.optimizer;
    }

    public void setOptimizer(String optimizer) {
        this.optimizer = optimizer;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Override
    @Parameter(excluded=true, attribute=false)
    public boolean isValid() {
        return StringUtils.isNotEmpty(this.name);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ProtocolConfig{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", host='").append(this.host).append('\'');
        sb.append(", port=").append(this.port);
        sb.append(", contextpath='").append(this.contextpath).append('\'');
        sb.append(", threadpool='").append(this.threadpool).append('\'');
        sb.append(", threadname='").append(this.threadname).append('\'');
        sb.append(", corethreads=").append(this.corethreads);
        sb.append(", threads=").append(this.threads);
        sb.append(", iothreads=").append(this.iothreads);
        sb.append(", alive=").append(this.alive);
        sb.append(", queues=").append(this.queues);
        sb.append(", accepts=").append(this.accepts);
        sb.append(", codec='").append(this.codec).append('\'');
        sb.append(", serialization='").append(this.serialization).append('\'');
        sb.append(", charset='").append(this.charset).append('\'');
        sb.append(", payload=").append(this.payload);
        sb.append(", buffer=").append(this.buffer);
        sb.append(", heartbeat=").append(this.heartbeat);
        sb.append(", accesslog='").append(this.accesslog).append('\'');
        sb.append(", transporter='").append(this.transporter).append('\'');
        sb.append(", exchanger='").append(this.exchanger).append('\'');
        sb.append(", dispatcher='").append(this.dispatcher).append('\'');
        sb.append(", networker='").append(this.networker).append('\'');
        sb.append(", server='").append(this.server).append('\'');
        sb.append(", client='").append(this.client).append('\'');
        sb.append(", telnet='").append(this.telnet).append('\'');
        sb.append(", prompt='").append(this.prompt).append('\'');
        sb.append(", status='").append(this.status).append('\'');
        sb.append(", register=").append(this.register);
        sb.append(", keepAlive=").append(this.keepAlive);
        sb.append(", optimizer='").append(this.optimizer).append('\'');
        sb.append(", extension='").append(this.extension).append('\'');
        sb.append(", parameters=").append(this.parameters);
        sb.append(", isDefault=").append(this.isDefault);
        sb.append(", sslEnabled=").append(this.sslEnabled);
        sb.append('}');
        return sb.toString();
    }
}

