/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;

public final class URLBuilder
extends ServiceConfigURL {
    private String protocol;
    private String username;
    private String password;
    private String host;
    private int port;
    private String path;
    private Map<String, String> parameters;
    private Map<String, Object> attributes;
    private Map<String, Map<String, String>> methodParameters;

    public URLBuilder() {
        this.protocol = null;
        this.username = null;
        this.password = null;
        this.host = null;
        this.port = 0;
        this.path = null;
        this.parameters = new HashMap<String, String>();
        this.attributes = new HashMap<String, Object>();
        this.methodParameters = new HashMap<String, Map<String, String>>();
    }

    public URLBuilder(String protocol, String host, int port) {
        this(protocol, (String)null, (String)null, host, port, (String)null, (Map<String, String>)null);
    }

    public URLBuilder(String protocol, String host, int port, String[] pairs) {
        this(protocol, null, null, host, port, null, CollectionUtils.toStringMap(pairs));
    }

    public URLBuilder(String protocol, String host, int port, Map<String, String> parameters) {
        this(protocol, null, null, host, port, null, parameters);
    }

    public URLBuilder(String protocol, String host, int port, String path) {
        this(protocol, (String)null, (String)null, host, port, path, (Map<String, String>)null);
    }

    public URLBuilder(String protocol, String host, int port, String path, String ... pairs) {
        this(protocol, null, null, host, port, path, CollectionUtils.toStringMap(pairs));
    }

    public URLBuilder(String protocol, String host, int port, String path, Map<String, String> parameters) {
        this(protocol, null, null, host, port, path, parameters);
    }

    public URLBuilder(String protocol, String username, String password, String host, int port, String path, Map<String, String> parameters) {
        this(protocol, username, password, host, port, path, parameters, null);
    }

    public URLBuilder(String protocol, String username, String password, String host, int port, String path, Map<String, String> parameters, Map<String, Object> attributes) {
        this.protocol = protocol;
        this.username = username;
        this.password = password;
        this.host = host;
        this.port = port;
        this.path = path;
        this.parameters = parameters != null ? parameters : new HashMap();
        this.attributes = attributes != null ? attributes : new HashMap();
    }

    public static URLBuilder from(URL url) {
        String protocol = url.getProtocol();
        String username = url.getUsername();
        String password = url.getPassword();
        String host = url.getHost();
        int port = url.getPort();
        String path = url.getPath();
        HashMap<String, String> parameters = new HashMap<String, String>(url.getParameters());
        HashMap<String, Object> attributes = new HashMap<String, Object>(url.getAttributes());
        return new URLBuilder(protocol, username, password, host, port, path, parameters, attributes);
    }

    public ServiceConfigURL build() {
        if (StringUtils.isEmpty(this.username) && StringUtils.isNotEmpty(this.password)) {
            throw new IllegalArgumentException("Invalid url, password without username!");
        }
        this.port = Math.max(this.port, 0);
        if (this.path != null) {
            int firstNonSlash;
            for (firstNonSlash = 0; firstNonSlash < this.path.length() && this.path.charAt(firstNonSlash) == '/'; ++firstNonSlash) {
            }
            if (firstNonSlash >= this.path.length()) {
                this.path = "";
            } else if (firstNonSlash > 0) {
                this.path = this.path.substring(firstNonSlash);
            }
        }
        return new ServiceConfigURL(this.protocol, this.username, this.password, this.host, this.port, this.path, this.parameters, this.attributes);
    }

    @Override
    public URLBuilder putAttribute(String key, Object obj) {
        this.attributes.put(key, obj);
        return this;
    }

    @Override
    public URLBuilder setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    @Override
    public URLBuilder setUsername(String username) {
        this.username = username;
        return this;
    }

    @Override
    public URLBuilder setPassword(String password) {
        this.password = password;
        return this;
    }

    @Override
    public URLBuilder setHost(String host) {
        this.host = host;
        return this;
    }

    @Override
    public URLBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    @Override
    public URLBuilder setAddress(String address) {
        String host;
        int i = address.lastIndexOf(58);
        int port = this.port;
        if (i >= 0) {
            host = address.substring(0, i);
            port = Integer.parseInt(address.substring(i + 1));
        } else {
            host = address;
        }
        this.host = host;
        this.port = port;
        return this;
    }

    @Override
    public URLBuilder setPath(String path) {
        this.path = path;
        return this;
    }

    @Override
    public URLBuilder addParameterAndEncoded(String key, String value) {
        if (StringUtils.isEmpty(value)) {
            return this;
        }
        return this.addParameter(key, URL.encode(value));
    }

    @Override
    public URLBuilder addParameter(String key, boolean value) {
        return this.addParameter(key, String.valueOf(value));
    }

    @Override
    public URLBuilder addParameter(String key, char value) {
        return this.addParameter(key, String.valueOf(value));
    }

    @Override
    public URLBuilder addParameter(String key, byte value) {
        return this.addParameter(key, String.valueOf(value));
    }

    @Override
    public URLBuilder addParameter(String key, short value) {
        return this.addParameter(key, String.valueOf(value));
    }

    @Override
    public URLBuilder addParameter(String key, int value) {
        return this.addParameter(key, String.valueOf(value));
    }

    @Override
    public URLBuilder addParameter(String key, long value) {
        return this.addParameter(key, String.valueOf(value));
    }

    @Override
    public URLBuilder addParameter(String key, float value) {
        return this.addParameter(key, String.valueOf(value));
    }

    @Override
    public URLBuilder addParameter(String key, double value) {
        return this.addParameter(key, String.valueOf(value));
    }

    @Override
    public URLBuilder addParameter(String key, Enum<?> value) {
        if (value == null) {
            return this;
        }
        return this.addParameter(key, String.valueOf(value));
    }

    @Override
    public URLBuilder addParameter(String key, Number value) {
        if (value == null) {
            return this;
        }
        return this.addParameter(key, String.valueOf(value));
    }

    @Override
    public URLBuilder addParameter(String key, CharSequence value) {
        if (value == null || value.length() == 0) {
            return this;
        }
        return this.addParameter(key, String.valueOf(value));
    }

    @Override
    public URLBuilder addParameter(String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        this.parameters.put(key, value);
        return this;
    }

    public URLBuilder addMethodParameter(String method, String key, String value) {
        if (StringUtils.isEmpty(method) || StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        URL.putMethodParameter(method, key, value, this.methodParameters);
        return this;
    }

    @Override
    public URLBuilder addParameterIfAbsent(String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        if (this.hasParameter(key)) {
            return this;
        }
        this.parameters.put(key, value);
        return this;
    }

    public URLBuilder addMethodParameterIfAbsent(String method, String key, String value) {
        if (StringUtils.isEmpty(method) || StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        if (this.hasMethodParameter(method, key)) {
            return this;
        }
        URL.putMethodParameter(method, key, value, this.methodParameters);
        return this;
    }

    @Override
    public URLBuilder addParameters(Map<String, String> parameters) {
        if (CollectionUtils.isEmptyMap(parameters)) {
            return this;
        }
        boolean hasAndEqual = true;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String newValue;
            String oldValue = this.parameters.get(entry.getKey());
            if (Objects.equals(oldValue, newValue = entry.getValue())) continue;
            hasAndEqual = false;
            break;
        }
        if (hasAndEqual) {
            return this;
        }
        this.parameters.putAll(parameters);
        return this;
    }

    public URLBuilder addMethodParameters(Map<String, Map<String, String>> methodParameters) {
        if (CollectionUtils.isEmptyMap(methodParameters)) {
            return this;
        }
        this.methodParameters.putAll(methodParameters);
        return this;
    }

    @Override
    public URLBuilder addParametersIfAbsent(Map<String, String> parameters) {
        if (CollectionUtils.isEmptyMap(parameters)) {
            return this;
        }
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            this.parameters.putIfAbsent(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public URLBuilder addParameters(String ... pairs) {
        if (pairs == null || pairs.length == 0) {
            return this;
        }
        if (pairs.length % 2 != 0) {
            throw new IllegalArgumentException("Map pairs can not be odd number.");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        int len = pairs.length / 2;
        for (int i = 0; i < len; ++i) {
            map.put(pairs[2 * i], pairs[2 * i + 1]);
        }
        return this.addParameters(map);
    }

    @Override
    public URLBuilder addParameterString(String query) {
        if (StringUtils.isEmpty(query)) {
            return this;
        }
        return this.addParameters((Map)StringUtils.parseQueryString(query));
    }

    @Override
    public URLBuilder removeParameter(String key) {
        if (StringUtils.isEmpty(key)) {
            return this;
        }
        return this.removeParameters(key);
    }

    @Override
    public URLBuilder removeParameters(Collection<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return this;
        }
        return this.removeParameters(keys.toArray(new String[0]));
    }

    @Override
    public URLBuilder removeParameters(String ... keys) {
        if (keys == null || keys.length == 0) {
            return this;
        }
        for (String key : keys) {
            this.parameters.remove(key);
        }
        return this;
    }

    @Override
    public URLBuilder clearParameters() {
        this.parameters.clear();
        return this;
    }

    @Override
    public boolean hasParameter(String key) {
        String value = this.getParameter(key);
        return StringUtils.isNotEmpty(value);
    }

    @Override
    public boolean hasMethodParameter(String method, String key) {
        if (method == null) {
            String suffix = "." + key;
            for (String fullKey : this.parameters.keySet()) {
                if (!fullKey.endsWith(suffix)) continue;
                return true;
            }
            return false;
        }
        if (key == null) {
            String prefix = method + ".";
            for (String fullKey : this.parameters.keySet()) {
                if (!fullKey.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }
        String value = this.getMethodParameter(method, key);
        return value != null && value.length() > 0;
    }

    @Override
    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    @Override
    public String getMethodParameter(String method, String key) {
        Map<String, String> keyMap = this.methodParameters.get(method);
        String value = null;
        if (keyMap != null) {
            value = keyMap.get(key);
        }
        return value;
    }
}

