/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.url.component.param;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.url.component.param.ParamValue;

public class DynamicValues
implements ParamValue {
    private final Map<Integer, String> index2Value = new ConcurrentHashMap<Integer, String>();
    private final Map<String, Integer> value2Index = new ConcurrentHashMap<String, Integer>();
    private int indexSeq = 0;

    public DynamicValues(String defaultVal) {
        if (defaultVal == null) {
            ++this.indexSeq;
        } else {
            this.add(defaultVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(String value) {
        Integer index = this.value2Index.get(value);
        if (index != null) {
            return index;
        }
        DynamicValues dynamicValues = this;
        synchronized (dynamicValues) {
            if (!this.value2Index.containsKey(value)) {
                this.value2Index.put(value, this.indexSeq);
                this.index2Value.put(this.indexSeq, value);
                ++this.indexSeq;
            }
        }
        return this.value2Index.get(value);
    }

    @Override
    public String getN(Integer n) {
        return this.index2Value.get(n);
    }

    @Override
    public Integer getIndex(String value) {
        Integer index = this.value2Index.get(value);
        if (index == null) {
            return this.add(value);
        }
        return index;
    }

    @Override
    public String defaultVal() {
        return this.getN(0);
    }
}

