/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.beans.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dubbo.common.beans.ScopeBeanException;
import org.apache.dubbo.common.beans.support.InstantiationStrategy;
import org.apache.dubbo.common.extension.ExtensionAccessor;
import org.apache.dubbo.common.extension.ExtensionAccessorAware;
import org.apache.dubbo.common.extension.ExtensionPostProcessor;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.model.ScopeModelAccessor;

public class ScopeBeanFactory {
    private final ScopeBeanFactory parent;
    private ExtensionAccessor extensionAccessor;
    private List<ExtensionPostProcessor> extensionPostProcessors;
    private Map<Class, AtomicInteger> beanNameIdCounterMap = new ConcurrentHashMap<Class, AtomicInteger>();
    private List<BeanInfo> registeredBeanInfos = Collections.synchronizedList(new ArrayList());
    private InstantiationStrategy instantiationStrategy;

    public ScopeBeanFactory(ScopeBeanFactory parent, ExtensionAccessor extensionAccessor) {
        this.parent = parent;
        this.extensionAccessor = extensionAccessor;
        this.extensionPostProcessors = extensionAccessor.getExtensionDirector().getExtensionPostProcessors();
        this.initInstantiationStrategy();
    }

    private void initInstantiationStrategy() {
        for (ExtensionPostProcessor extensionPostProcessor : this.extensionPostProcessors) {
            if (!(extensionPostProcessor instanceof ScopeModelAccessor)) continue;
            this.instantiationStrategy = new InstantiationStrategy((ScopeModelAccessor)((Object)extensionPostProcessor));
            break;
        }
        if (this.instantiationStrategy == null) {
            this.instantiationStrategy = new InstantiationStrategy();
        }
    }

    public <T> T registerBean(Class<T> bean) throws ScopeBeanException {
        return this.getOrRegisterBean(null, bean);
    }

    public <T> T registerBean(String name, Class<T> clazz) throws ScopeBeanException {
        return this.getOrRegisterBean(name, clazz);
    }

    private <T> T createAndRegisterBean(String name, Class<T> clazz) {
        T instance = this.getBean(name, clazz);
        if (instance != null) {
            throw new ScopeBeanException("already exists bean with same name and type, name=" + name + ", type=" + clazz.getName());
        }
        try {
            instance = this.instantiationStrategy.instantiate(clazz);
        }
        catch (Throwable e) {
            throw new ScopeBeanException("create bean instance failed, type=" + clazz.getName(), e);
        }
        this.registerBean(name, instance);
        return instance;
    }

    public void registerBean(Object bean) {
        this.registerBean(null, bean);
    }

    public void registerBean(String name, Object bean) {
        if (this.containsBean(name, bean)) {
            return;
        }
        Class<?> beanClass = bean.getClass();
        if (name == null) {
            name = beanClass.getName() + "#" + this.getNextId(beanClass);
        }
        this.initializeBean(name, bean);
        this.registeredBeanInfos.add(new BeanInfo(name, bean));
    }

    public <T> T getOrRegisterBean(Class<T> type) {
        return this.getOrRegisterBean(null, type);
    }

    public <T> T getOrRegisterBean(String name, Class<T> type) {
        T bean = this.getBean(name, type);
        if (bean == null) {
            bean = this.createAndRegisterBean(name, type);
        }
        return bean;
    }

    public <T> T getOrRegisterBean(Class<T> type, Function<? super Class<T>, ? extends T> mappingFunction) {
        return this.getOrRegisterBean(null, type, mappingFunction);
    }

    public <T> T getOrRegisterBean(String name, Class<T> type, Function<? super Class<T>, ? extends T> mappingFunction) {
        T bean = this.getBean(name, type);
        if (bean == null) {
            bean = mappingFunction.apply(type);
            this.registerBean(name, bean);
        }
        return bean;
    }

    public <T> T initializeBean(T bean) {
        this.initializeBean(null, bean);
        return bean;
    }

    private void initializeBean(String name, Object bean) {
        try {
            if (bean instanceof ExtensionAccessorAware) {
                ((ExtensionAccessorAware)bean).setExtensionAccessor(this.extensionAccessor);
            }
            for (ExtensionPostProcessor processor : this.extensionPostProcessors) {
                processor.postProcessAfterInitialization(bean, name);
            }
        }
        catch (Exception e) {
            throw new ScopeBeanException("register bean failed! name=" + name + ", type=" + bean.getClass().getName(), e);
        }
    }

    private boolean containsBean(String name, Object bean) {
        for (BeanInfo beanInfo : this.registeredBeanInfos) {
            if (beanInfo.instance != bean || name != null && !StringUtils.isEquals(name, beanInfo.name)) continue;
            return true;
        }
        return false;
    }

    private int getNextId(Class<?> beanClass) {
        return this.beanNameIdCounterMap.computeIfAbsent(beanClass, key -> new AtomicInteger()).incrementAndGet();
    }

    public <T> T getBean(Class<T> type) {
        return this.getBean(null, type);
    }

    public <T> T getBean(String name, Class<T> type) {
        T bean = this.getBeanInternal(name, type);
        if (bean == null && this.parent != null) {
            return this.parent.getBean(name, type);
        }
        return bean;
    }

    private <T> T getBeanInternal(String name, Class<T> type) {
        if (type == Object.class) {
            return null;
        }
        ArrayList<BeanInfo> candidates = null;
        BeanInfo firstCandidate = null;
        for (BeanInfo beanInfo2 : this.registeredBeanInfos) {
            if (!type.isAssignableFrom(beanInfo2.instance.getClass())) continue;
            if (StringUtils.isEquals(beanInfo2.name, name)) {
                return (T)beanInfo2.instance;
            }
            if (firstCandidate == null) {
                firstCandidate = beanInfo2;
                continue;
            }
            if (candidates == null) {
                candidates = new ArrayList<BeanInfo>();
                candidates.add(firstCandidate);
            }
            candidates.add(beanInfo2);
        }
        if (candidates != null) {
            if (candidates.size() == 1) {
                return (T)((BeanInfo)candidates.get(0)).instance;
            }
            if (candidates.size() > 1) {
                List candidateBeanNames = candidates.stream().map(beanInfo -> ((BeanInfo)beanInfo).name).collect(Collectors.toList());
                throw new ScopeBeanException("expected single matching bean but found " + candidates.size() + " candidates for type [" + type.getName() + "]: " + candidateBeanNames);
            }
        } else if (firstCandidate != null) {
            return (T)firstCandidate.instance;
        }
        return null;
    }

    static class BeanInfo {
        private String name;
        private Object instance;

        public BeanInfo(String name, Object instance) {
            this.name = name;
            this.instance = instance;
        }
    }
}

