/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.context;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.config.CompositeConfiguration;
import org.apache.dubbo.common.context.ApplicationExt;
import org.apache.dubbo.common.extension.DisableInject;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.config.context.AbstractConfigManager;
import org.apache.dubbo.config.context.ConfigMode;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ConfigManager
extends AbstractConfigManager
implements ApplicationExt {
    private static final Logger logger = LoggerFactory.getLogger(ConfigManager.class);
    public static final String NAME = "config";
    public static final String BEAN_NAME = "dubboConfigManager";
    public static final String DUBBO_CONFIG_MODE = "dubbo.config.mode";
    private ConfigMode configMode = ConfigMode.STRICT;
    private ApplicationModel applicationModel;
    private AtomicBoolean inited = new AtomicBoolean(false);
    private static Set<Class<? extends AbstractConfig>> uniqueConfigTypes = new ConcurrentHashSet<Class<? extends AbstractConfig>>();

    public ConfigManager(ApplicationModel applicationModel) {
        super(applicationModel, Arrays.asList(ApplicationConfig.class, ModuleConfig.class, MonitorConfig.class, MetricsConfig.class, SslConfig.class, ProtocolConfig.class, RegistryConfig.class, ConfigCenterConfig.class, MetadataReportConfig.class));
        this.applicationModel = applicationModel;
    }

    @Override
    public void initialize() throws IllegalStateException {
        if (!this.inited.compareAndSet(false, true)) {
            return;
        }
        CompositeConfiguration configuration = this.applicationModel.getModelEnvironment().getConfiguration();
        String configModeStr = (String)configuration.getProperty(DUBBO_CONFIG_MODE);
        try {
            if (StringUtils.hasText(configModeStr)) {
                this.configMode = ConfigMode.valueOf(configModeStr.toUpperCase());
            }
        }
        catch (Exception e) {
            String msg = "Illegal 'dubbo.config.mode' config value [" + configModeStr + "], available values " + Arrays.toString((Object[])ConfigMode.values());
            logger.error(msg, e);
            throw new IllegalArgumentException(msg, e);
        }
        logger.info("Config settings - config mode: " + (Object)((Object)this.configMode));
    }

    @DisableInject
    public void setApplication(ApplicationConfig application) {
        this.addConfig(application);
    }

    public Optional<ApplicationConfig> getApplication() {
        return Optional.ofNullable(this.getSingleConfig(AbstractConfig.getTagName(ApplicationConfig.class)));
    }

    public ApplicationConfig getApplicationOrElseThrow() {
        return this.getApplication().orElseThrow(() -> new IllegalStateException("There's no ApplicationConfig specified."));
    }

    @DisableInject
    public void setMonitor(MonitorConfig monitor) {
        this.addConfig(monitor);
    }

    public Optional<MonitorConfig> getMonitor() {
        return Optional.ofNullable(this.getSingleConfig(AbstractConfig.getTagName(MonitorConfig.class)));
    }

    @DisableInject
    public void setModule(ModuleConfig module) {
        this.addConfig(module);
    }

    public Optional<ModuleConfig> getModule() {
        return Optional.ofNullable(this.getSingleConfig(AbstractConfig.getTagName(ModuleConfig.class)));
    }

    @DisableInject
    public void setMetrics(MetricsConfig metrics) {
        this.addConfig(metrics);
    }

    public Optional<MetricsConfig> getMetrics() {
        return Optional.ofNullable(this.getSingleConfig(AbstractConfig.getTagName(MetricsConfig.class)));
    }

    @DisableInject
    public void setSsl(SslConfig sslConfig) {
        this.addConfig(sslConfig);
    }

    public Optional<SslConfig> getSsl() {
        return Optional.ofNullable(this.getSingleConfig(AbstractConfig.getTagName(SslConfig.class)));
    }

    public void addConfigCenter(ConfigCenterConfig configCenter) {
        this.addConfig(configCenter);
    }

    public void addConfigCenters(Iterable<ConfigCenterConfig> configCenters) {
        configCenters.forEach(this::addConfigCenter);
    }

    public Optional<Collection<ConfigCenterConfig>> getDefaultConfigCenter() {
        Collection<Object> defaults = ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(ConfigCenterConfig.class)));
        if (CollectionUtils.isEmpty(defaults)) {
            defaults = this.getConfigCenters();
        }
        return Optional.ofNullable(defaults);
    }

    public Optional<ConfigCenterConfig> getConfigCenter(String id) {
        return this.getConfig(ConfigCenterConfig.class, id);
    }

    public Collection<ConfigCenterConfig> getConfigCenters() {
        return this.getConfigs(AbstractConfig.getTagName(ConfigCenterConfig.class));
    }

    public void addMetadataReport(MetadataReportConfig metadataReportConfig) {
        this.addConfig(metadataReportConfig);
    }

    public void addMetadataReports(Iterable<MetadataReportConfig> metadataReportConfigs) {
        metadataReportConfigs.forEach(this::addMetadataReport);
    }

    public Collection<MetadataReportConfig> getMetadataConfigs() {
        return this.getConfigs(AbstractConfig.getTagName(MetadataReportConfig.class));
    }

    public Collection<MetadataReportConfig> getDefaultMetadataConfigs() {
        List<MetadataReportConfig> defaults = ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(MetadataReportConfig.class)));
        if (CollectionUtils.isEmpty(defaults)) {
            return this.getMetadataConfigs();
        }
        return defaults;
    }

    public void addProtocol(ProtocolConfig protocolConfig) {
        this.addConfig(protocolConfig);
    }

    public void addProtocols(Iterable<ProtocolConfig> protocolConfigs) {
        if (protocolConfigs != null) {
            protocolConfigs.forEach(this::addProtocol);
        }
    }

    public Optional<ProtocolConfig> getProtocol(String idOrName) {
        return this.getConfig(ProtocolConfig.class, idOrName);
    }

    public List<ProtocolConfig> getDefaultProtocols() {
        return this.getDefaultConfigs(ProtocolConfig.class);
    }

    @Override
    public <C extends AbstractConfig> List<C> getDefaultConfigs(Class<C> cls) {
        return ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(cls)));
    }

    public Collection<ProtocolConfig> getProtocols() {
        return this.getConfigs(AbstractConfig.getTagName(ProtocolConfig.class));
    }

    public void addRegistry(RegistryConfig registryConfig) {
        this.addConfig(registryConfig);
    }

    public void addRegistries(Iterable<RegistryConfig> registryConfigs) {
        if (registryConfigs != null) {
            registryConfigs.forEach(this::addRegistry);
        }
    }

    public Optional<RegistryConfig> getRegistry(String id) {
        return this.getConfig(RegistryConfig.class, id);
    }

    public List<RegistryConfig> getDefaultRegistries() {
        return ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(RegistryConfig.class)));
    }

    public Collection<RegistryConfig> getRegistries() {
        return this.getConfigs(AbstractConfig.getTagName(RegistryConfig.class));
    }

    @Override
    public void refreshAll() {
        this.getApplication().ifPresent(ApplicationConfig::refresh);
        this.getMonitor().ifPresent(AbstractConfig::refresh);
        this.getModule().ifPresent(AbstractConfig::refresh);
        this.getMetrics().ifPresent(AbstractConfig::refresh);
        this.getSsl().ifPresent(AbstractConfig::refresh);
        this.getProtocols().forEach(AbstractConfig::refresh);
        this.getRegistries().forEach(AbstractConfig::refresh);
        this.getConfigCenters().forEach(AbstractConfig::refresh);
        this.getMetadataConfigs().forEach(AbstractConfig::refresh);
    }

    private boolean isUniqueConfig(AbstractConfig config) {
        if (uniqueConfigTypes.contains(config.getClass())) {
            return true;
        }
        for (Class<? extends AbstractConfig> uniqueConfigType : uniqueConfigTypes) {
            if (!uniqueConfigType.isAssignableFrom(config.getClass())) continue;
            return true;
        }
        return false;
    }

    protected <C extends AbstractConfig> C getSingleConfig(String configType) throws IllegalStateException {
        Map configsMap = this.getConfigsMap(configType);
        int size = configsMap.size();
        if (size < 1) {
            return null;
        }
        if (size > 1) {
            throw new IllegalStateException("Expected single instance of " + configType + ", but found " + size + " instances, please remove redundant configs. instances: " + configsMap.values());
        }
        return (C)((AbstractConfig)configsMap.values().iterator().next());
    }

    @Override
    protected <C extends AbstractConfig> Optional<C> findDuplicatedConfig(Map<String, C> configsMap, C config) {
        Optional<C> prevConfig = this.findConfigByValue(configsMap.values(), config);
        if (prevConfig.isPresent()) {
            if (prevConfig.get() == config) {
                return prevConfig;
            }
            if (logger.isInfoEnabled() && this.duplicatedConfigs.add(config)) {
                logger.info("Ignore duplicated config: " + config);
            }
            return prevConfig;
        }
        if (configsMap.size() > 0 && this.isUniqueConfig(config)) {
            AbstractConfig oldOne = (AbstractConfig)configsMap.values().iterator().next();
            String configName = oldOne.getClass().getSimpleName();
            String msgPrefix = "Duplicate Configs found for " + configName + ", only one unique " + configName + " is allowed for one application. previous: " + oldOne + ", later: " + config + ". According to config mode [" + (Object)((Object)this.configMode) + "], ";
            switch (this.configMode) {
                case STRICT: {
                    if (this.isEquals(oldOne, config)) break;
                    throw new IllegalStateException(msgPrefix + "please remove redundant configs and keep only one.");
                }
                case IGNORE: {
                    if (logger.isWarnEnabled() && this.duplicatedConfigs.add(config)) {
                        logger.warn(msgPrefix + "keep previous config and ignore later config");
                    }
                    return Optional.of(oldOne);
                }
                case OVERRIDE: {
                    configsMap.clear();
                    if (!logger.isWarnEnabled() || !this.duplicatedConfigs.add(config)) break;
                    logger.warn(msgPrefix + "override previous config with later config");
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public void loadConfigs() {
        this.loadConfigsOfTypeFromProps(ApplicationConfig.class);
        this.loadConfigsOfTypeFromProps(ModuleConfig.class);
        this.loadConfigsOfTypeFromProps(MonitorConfig.class);
        this.loadConfigsOfTypeFromProps(MetricsConfig.class);
        this.loadConfigsOfTypeFromProps(ProtocolConfig.class);
        this.loadConfigsOfTypeFromProps(RegistryConfig.class);
        this.loadConfigsOfTypeFromProps(MetadataReportConfig.class);
        this.checkConfigs();
    }

    private void checkConfigs() {
        List<Class> multipleConfigTypes = Arrays.asList(ApplicationConfig.class, ProtocolConfig.class, RegistryConfig.class, MetadataReportConfig.class, MonitorConfig.class, ModuleConfig.class, MetricsConfig.class, SslConfig.class);
        for (Class configType : multipleConfigTypes) {
            this.checkDefaultAndValidateConfigs(configType);
        }
        LinkedHashMap<Integer, ProtocolConfig> protocolPortMap = new LinkedHashMap<Integer, ProtocolConfig>();
        for (ProtocolConfig protocol : this.getProtocols()) {
            Integer port = protocol.getPort();
            if (port == null || port == -1) continue;
            ProtocolConfig prevProtocol = (ProtocolConfig)protocolPortMap.get(port);
            if (prevProtocol != null) {
                throw new IllegalStateException("Duplicated port used by protocol configs, port: " + port + ", configs: " + Arrays.asList(prevProtocol, protocol));
            }
            protocolPortMap.put(port, protocol);
        }
    }

    ConfigMode getConfigMode() {
        return this.configMode;
    }

    static {
        uniqueConfigTypes.add(ApplicationConfig.class);
        uniqueConfigTypes.add(ModuleConfig.class);
        uniqueConfigTypes.add(MonitorConfig.class);
        uniqueConfigTypes.add(MetricsConfig.class);
        uniqueConfigTypes.add(SslConfig.class);
    }
}

